
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

/** 
 * Commission information for a given Order/OfferItem
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderCommission">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:choice>
 *         &lt;xs:element type="xs:string" name="OrderItemID"/>
 *         &lt;xs:element type="xs:string" name="OfferItemID"/>
 *       &lt;/xs:choice>
 *       &lt;xs:choice>
 *         &lt;xs:element name="Amount">
 *           &lt;xs:complexType>
 *             &lt;xs:simpleContent>
 *               &lt;xs:extension base="xs:integer">
 *                 &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
 *                 &lt;xs:attribute type="xs:boolean" use="optional" default="true" name="Taxable"/>
 *               &lt;/xs:extension>
 *             &lt;/xs:simpleContent>
 *           &lt;/xs:complexType>
 *         &lt;/xs:element>
 *         &lt;xs:element type="xs:decimal" name="Percentage"/>
 *       &lt;/xs:choice>
 *       &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
 *       &lt;xs:element name="Remarks">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="Remark" maxOccurs="unbounded">
 *               &lt;!-- Reference to inner class Remark -->
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *           &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OrderCommission implements Serializable
{
    private int choiceSelect = -1;
    private static final int ORDER_ITEM_ID_CHOICE = 0;
    private static final int OFFER_ITEM_ID_CHOICE = 1;
    private String orderItemID;
    private String offerItemID;
    private int choiceSelect1 = -1;
    private static final int AMOUNT_CHOICE = 0;
    private static final int PERCENTAGE_CHOICE = 1;
    private BigInteger amountInteger;
    private String amountCode;
    private Boolean amountTaxable;
    private BigDecimal percentage;
    private String code;
    private List<Remark> remarkList = new ArrayList<Remark>();
    private String remarksRefs;
    private String refs;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if OrderItemID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOrderItemID() {
        return choiceSelect == ORDER_ITEM_ID_CHOICE;
    }

    /** 
     * Get the 'OrderItemID' element value. The airline-assigned unique Order Item ID. Example: ORD769-A850-4EC4-8F46-02293F72D7E6
     * 
     * @return value
     */
    public String getOrderItemID() {
        return orderItemID;
    }

    /** 
     * Set the 'OrderItemID' element value. The airline-assigned unique Order Item ID. Example: ORD769-A850-4EC4-8F46-02293F72D7E6
     * 
     * @param orderItemID
     */
    public void setOrderItemID(String orderItemID) {
        setChoiceSelect(ORDER_ITEM_ID_CHOICE);
        this.orderItemID = orderItemID;
    }

    /** 
     * Check if OfferItemID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOfferItemID() {
        return choiceSelect == OFFER_ITEM_ID_CHOICE;
    }

    /** 
     * Get the 'OfferItemID' element value. Reference to the OfferItemID of the selected OfferItem (contained in either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
     * 
     * @return value
     */
    public String getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' element value. Reference to the OfferItemID of the selected OfferItem (contained in either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
     * 
     * @param offerItemID
     */
    public void setOfferItemID(String offerItemID) {
        setChoiceSelect(OFFER_ITEM_ID_CHOICE);
        this.offerItemID = offerItemID;
    }

    private void setChoiceSelect1(int choice) {
        if (choiceSelect1 == -1) {
            choiceSelect1 = choice;
        } else if (choiceSelect1 != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect1() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect1() {
        choiceSelect1 = -1;
    }

    /** 
     * Check if Amount is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAmount() {
        return choiceSelect1 == AMOUNT_CHOICE;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public BigInteger getAmountInteger() {
        return amountInteger;
    }

    /** 
     * Set the extension value.
     * 
     * @param amountInteger
     */
    public void setAmountInteger(BigInteger amountInteger) {
        setChoiceSelect1(AMOUNT_CHOICE);
        this.amountInteger = amountInteger;
    }

    /** 
     * Get the 'Code' attribute value. Currency code. Example: USD
    Encoding Scheme: ISO 4217 (three alpha character) Currency Code
     * 
     * @return value
     */
    public String getAmountCode() {
        return amountCode;
    }

    /** 
     * Set the 'Code' attribute value. Currency code. Example: USD
    Encoding Scheme: ISO 4217 (three alpha character) Currency Code
     * 
     * @param amountCode
     */
    public void setAmountCode(String amountCode) {
        setChoiceSelect1(AMOUNT_CHOICE);
        this.amountCode = amountCode;
    }

    /** 
     * Get the 'Taxable' attribute value. In some markets, commission is VAT-able (ie Taxable)
     * 
     * @return value
     */
    public Boolean getAmountTaxable() {
        return amountTaxable;
    }

    /** 
     * Set the 'Taxable' attribute value. In some markets, commission is VAT-able (ie Taxable)
     * 
     * @param amountTaxable
     */
    public void setAmountTaxable(Boolean amountTaxable) {
        setChoiceSelect1(AMOUNT_CHOICE);
        this.amountTaxable = amountTaxable;
    }

    /** 
     * Check if Percentage is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPercentage() {
        return choiceSelect1 == PERCENTAGE_CHOICE;
    }

    /** 
     * Get the 'Percentage' element value. Commission percentage. Example: 20
     * 
     * @return value
     */
    public BigDecimal getPercentage() {
        return percentage;
    }

    /** 
     * Set the 'Percentage' element value. Commission percentage. Example: 20
     * 
     * @param percentage
     */
    public void setPercentage(BigDecimal percentage) {
        setChoiceSelect1(PERCENTAGE_CHOICE);
        this.percentage = percentage;
    }

    /** 
     * Get the 'Code' element value. Commission code. Example: 1000, BFST
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Commission code. Example: 1000, BFST
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the list of 'Remark' element items. Remark(s).
     * 
     * @return list
     */
    public List<Remark> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. Remark(s).
     * 
     * @param list
     */
    public void setRemarkList(List<Remark> list) {
        remarkList = list;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRemarksRefs() {
        return remarksRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param remarksRefs
     */
    public void setRemarksRefs(String remarksRefs) {
        this.remarksRefs = remarksRefs;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Remark Text.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="DisplayInd"/>
     *         &lt;xs:attribute type="xs:dateTime" use="optional" name="Timestamp"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Remark implements Serializable
    {
        private String string;
        private Boolean displayInd;
        private DateTime timestamp;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'DisplayInd' attribute value. When true, this remark should be displayed.

        Notes:
        1. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.  The technical implementation of this capability is not dictated by this specification. 
         * 
         * @return value
         */
        public Boolean getDisplayInd() {
            return displayInd;
        }

        /** 
         * Set the 'DisplayInd' attribute value. When true, this remark should be displayed.

        Notes:
        1. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.  The technical implementation of this capability is not dictated by this specification. 
         * 
         * @param displayInd
         */
        public void setDisplayInd(Boolean displayInd) {
            this.displayInd = displayInd;
        }

        /** 
         * Get the 'Timestamp' attribute value. Remark creation timestamp.  Example: 2017-01-13T13:59:38Z
         * 
         * @return value
         */
        public DateTime getTimestamp() {
            return timestamp;
        }

        /** 
         * Set the 'Timestamp' attribute value. Remark creation timestamp.  Example: 2017-01-13T13:59:38Z
         * 
         * @param timestamp
         */
        public void setTimestamp(DateTime timestamp) {
            this.timestamp = timestamp;
        }
    }
}
