
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * ORDER PAYMENT METHOD definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderPaymentMethodType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Type" minOccurs="0"/>
 *     &lt;xs:element name="Method">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element ref="BankAccountMethod" minOccurs="0"/>
 *           &lt;xs:element ref="CashMethod" minOccurs="0"/>
 *           &lt;xs:element ref="DirectBillMethod" minOccurs="0"/>
 *           &lt;xs:element ref="MiscChargeMethod" minOccurs="0"/>
 *           &lt;xs:element ref="OtherMethod" minOccurs="0"/>
 *           &lt;xs:element ref="PaymentCardMethod" minOccurs="0"/>
 *           &lt;xs:element ref="RedemptionMethod" minOccurs="0"/>
 *           &lt;xs:element ref="VoucherMethod" minOccurs="0"/>
 *           &lt;xs:element ref="Check" minOccurs="0"/>
 *         &lt;/xs:sequence>
 *         &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="CurrencyAmountOptType" name="Amount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Qualifier" minOccurs="0"/>
 *     &lt;xs:element name="Promotions" minOccurs="0">
 *       &lt;!-- Reference to inner class Promotions -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Associations" minOccurs="0">
 *       &lt;!-- Reference to inner class Associations -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="Description" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="SplitFormInd"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class OrderPaymentMethodType implements Serializable
{
    private String type;
    private BankAccountMethodType methodBankAccountMethod;
    private CashMethodType methodCashMethod;
    private DirectBillMethodType methodDirectBillMethod;
    private MiscChargeMethodType methodMiscChargeMethod;
    private OtherMethodType methodOtherMethod;
    private PaymentCardMethodType methodPaymentCardMethod;
    private RedemptionMethodType methodRedemptionMethod;
    private VoucherMethodType methodVoucherMethod;
    private Check methodCheck;
    private String methodRefs;
    private CurrencyAmountOptType amount;
    private String qualifier;
    private Promotions promotions;
    private Associations associations;
    private Description description;
    private Boolean splitFormInd;

    /** 
     * Get the 'Type' element value. 
              The form of payment type. Examples: Credit Card, Cash. Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
            
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. 
              The form of payment type. Examples: Credit Card, Cash. Encoding Scheme: IATA PADIS code list data element [9888] Form of Payment Identification
            
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'BankAccountMethod' element value.
     * 
     * @return value
     */
    public BankAccountMethodType getMethodBankAccountMethod() {
        return methodBankAccountMethod;
    }

    /** 
     * Set the 'BankAccountMethod' element value.
     * 
     * @param methodBankAccountMethod
     */
    public void setMethodBankAccountMethod(
            BankAccountMethodType methodBankAccountMethod) {
        this.methodBankAccountMethod = methodBankAccountMethod;
    }

    /** 
     * Get the 'CashMethod' element value.
     * 
     * @return value
     */
    public CashMethodType getMethodCashMethod() {
        return methodCashMethod;
    }

    /** 
     * Set the 'CashMethod' element value.
     * 
     * @param methodCashMethod
     */
    public void setMethodCashMethod(CashMethodType methodCashMethod) {
        this.methodCashMethod = methodCashMethod;
    }

    /** 
     * Get the 'DirectBillMethod' element value.
     * 
     * @return value
     */
    public DirectBillMethodType getMethodDirectBillMethod() {
        return methodDirectBillMethod;
    }

    /** 
     * Set the 'DirectBillMethod' element value.
     * 
     * @param methodDirectBillMethod
     */
    public void setMethodDirectBillMethod(
            DirectBillMethodType methodDirectBillMethod) {
        this.methodDirectBillMethod = methodDirectBillMethod;
    }

    /** 
     * Get the 'MiscChargeMethod' element value.
     * 
     * @return value
     */
    public MiscChargeMethodType getMethodMiscChargeMethod() {
        return methodMiscChargeMethod;
    }

    /** 
     * Set the 'MiscChargeMethod' element value.
     * 
     * @param methodMiscChargeMethod
     */
    public void setMethodMiscChargeMethod(
            MiscChargeMethodType methodMiscChargeMethod) {
        this.methodMiscChargeMethod = methodMiscChargeMethod;
    }

    /** 
     * Get the 'OtherMethod' element value.
     * 
     * @return value
     */
    public OtherMethodType getMethodOtherMethod() {
        return methodOtherMethod;
    }

    /** 
     * Set the 'OtherMethod' element value.
     * 
     * @param methodOtherMethod
     */
    public void setMethodOtherMethod(OtherMethodType methodOtherMethod) {
        this.methodOtherMethod = methodOtherMethod;
    }

    /** 
     * Get the 'PaymentCardMethod' element value.
     * 
     * @return value
     */
    public PaymentCardMethodType getMethodPaymentCardMethod() {
        return methodPaymentCardMethod;
    }

    /** 
     * Set the 'PaymentCardMethod' element value.
     * 
     * @param methodPaymentCardMethod
     */
    public void setMethodPaymentCardMethod(
            PaymentCardMethodType methodPaymentCardMethod) {
        this.methodPaymentCardMethod = methodPaymentCardMethod;
    }

    /** 
     * Get the 'RedemptionMethod' element value.
     * 
     * @return value
     */
    public RedemptionMethodType getMethodRedemptionMethod() {
        return methodRedemptionMethod;
    }

    /** 
     * Set the 'RedemptionMethod' element value.
     * 
     * @param methodRedemptionMethod
     */
    public void setMethodRedemptionMethod(
            RedemptionMethodType methodRedemptionMethod) {
        this.methodRedemptionMethod = methodRedemptionMethod;
    }

    /** 
     * Get the 'VoucherMethod' element value.
     * 
     * @return value
     */
    public VoucherMethodType getMethodVoucherMethod() {
        return methodVoucherMethod;
    }

    /** 
     * Set the 'VoucherMethod' element value.
     * 
     * @param methodVoucherMethod
     */
    public void setMethodVoucherMethod(VoucherMethodType methodVoucherMethod) {
        this.methodVoucherMethod = methodVoucherMethod;
    }

    /** 
     * Get the 'Check' element value. Check (Cheque) Payment
     * 
     * @return value
     */
    public Check getMethodCheck() {
        return methodCheck;
    }

    /** 
     * Set the 'Check' element value. Check (Cheque) Payment
     * 
     * @param methodCheck
     */
    public void setMethodCheck(Check methodCheck) {
        this.methodCheck = methodCheck;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getMethodRefs() {
        return methodRefs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param methodRefs
     */
    public void setMethodRefs(String methodRefs) {
        this.methodRefs = methodRefs;
    }

    /** 
     * Get the 'Amount' element value. 
              The amount for this form of payment. Example: 300 USD
            
     * 
     * @return value
     */
    public CurrencyAmountOptType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. 
              The amount for this form of payment. Example: 300 USD
            
     * 
     * @param amount
     */
    public void setAmount(CurrencyAmountOptType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Qualifier' element value. 
              Used to specify if this is the old, new, or orginal form of payment. Encoding Scheme: IATA PADIS code list 9988 - Data Indicator
            
     * 
     * @return value
     */
    public String getQualifier() {
        return qualifier;
    }

    /** 
     * Set the 'Qualifier' element value. 
              Used to specify if this is the old, new, or orginal form of payment. Encoding Scheme: IATA PADIS code list 9988 - Data Indicator
            
     * 
     * @param qualifier
     */
    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    /** 
     * Get the 'Promotions' element value.
     * 
     * @return value
     */
    public Promotions getPromotions() {
        return promotions;
    }

    /** 
     * Set the 'Promotions' element value.
     * 
     * @param promotions
     */
    public void setPromotions(Promotions promotions) {
        this.promotions = promotions;
    }

    /** 
     * Get the 'Associations' element value.
     * 
     * @return value
     */
    public Associations getAssociations() {
        return associations;
    }

    /** 
     * Set the 'Associations' element value.
     * 
     * @param associations
     */
    public void setAssociations(Associations associations) {
        this.associations = associations;
    }

    /** 
     * Get the 'Description' element value.
     * 
     * @return value
     */
    public Description getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value.
     * 
     * @param description
     */
    public void setDescription(Description description) {
        this.description = description;
    }

    /** 
     * Get the 'SplitFormInd' attribute value. When true, this is a split form of payment.
     * 
     * @return value
     */
    public Boolean getSplitFormInd() {
        return splitFormInd;
    }

    /** 
     * Set the 'SplitFormInd' attribute value. When true, this is a split form of payment.
     * 
     * @param splitFormInd
     */
    public void setSplitFormInd(Boolean splitFormInd) {
        this.splitFormInd = splitFormInd;
    }
    /** 
     * 
              Applied Promotions for this payment form. Note: If specified, this individual payment form information will override any globally specified promotion information.
            
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Promotion" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Promotion -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Promotions implements Serializable
    {
        private List<Promotion> promotionList = new ArrayList<Promotion>();

        /** 
         * Get the list of 'Promotion' element items.
         * 
         * @return list
         */
        public List<Promotion> getPromotionList() {
            return promotionList;
        }

        /** 
         * Set the list of 'Promotion' element items.
         * 
         * @param list
         */
        public void setPromotionList(List<Promotion> list) {
            promotionList = list;
        }
        /** 
         * Promotion Detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotion" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="PromotionType">
         *         &lt;xs:sequence>
         *           &lt;xs:element ref="Associations"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Promotion extends PromotionType implements
            Serializable
        {
            private com.gridnine.farelogix.ndc.Associations associations;

            /** 
             * Get the 'Associations' element value. Association(s), including Passenger and Group.
             * 
             * @return value
             */
            public com.gridnine.farelogix.ndc.Associations getAssociations() {
                return associations;
            }

            /** 
             * Set the 'Associations' element value. Association(s), including Passenger and Group.
             * 
             * @param associations
             */
            public void setAssociations(
                    com.gridnine.farelogix.ndc.Associations associations) {
                this.associations = associations;
            }
        }
    }
    /** 
     * Payment Information Association(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Associations" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="OrderID" minOccurs="0"/>
     *       &lt;xs:element ref="OrderItemID" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="Passengers" minOccurs="0">
     *         &lt;!-- Reference to inner class Passengers -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class OtherAssociation -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Associations implements Serializable
    {
        private OrderIDType orderID;
        private List<OrderItemID> orderItemIDList = new ArrayList<OrderItemID>();
        private Passengers passengers;
        private List<OtherAssociation> otherAssociationList = new ArrayList<OtherAssociation>();

        /** 
         * Get the 'OrderID' element value. Associated Order ID Example: ORDER7333
         * 
         * @return value
         */
        public OrderIDType getOrderID() {
            return orderID;
        }

        /** 
         * Set the 'OrderID' element value. Associated Order ID Example: ORDER7333
         * 
         * @param orderID
         */
        public void setOrderID(OrderIDType orderID) {
            this.orderID = orderID;
        }

        /** 
         * Get the list of 'OrderItemID' element items. Associated Order Item ID(s). Example: ORD7333-001
         * 
         * @return list
         */
        public List<OrderItemID> getOrderItemIDList() {
            return orderItemIDList;
        }

        /** 
         * Set the list of 'OrderItemID' element items. Associated Order Item ID(s). Example: ORD7333-001
         * 
         * @param list
         */
        public void setOrderItemIDList(List<OrderItemID> list) {
            orderItemIDList = list;
        }

        /** 
         * Get the 'Passengers' element value.
         * 
         * @return value
         */
        public Passengers getPassengers() {
            return passengers;
        }

        /** 
         * Set the 'Passengers' element value.
         * 
         * @param passengers
         */
        public void setPassengers(Passengers passengers) {
            this.passengers = passengers;
        }

        /** 
         * Get the list of 'OtherAssociation' element items.
         * 
         * @return list
         */
        public List<OtherAssociation> getOtherAssociationList() {
            return otherAssociationList;
        }

        /** 
         * Set the list of 'OtherAssociation' element items.
         * 
         * @param list
         */
        public void setOtherAssociationList(List<OtherAssociation> list) {
            otherAssociationList = list;
        }
        /** 
         * 
                      Passenger(s)/ Groups associated with the Offer Item. Note: This contains references to Passenger and Group instance(s) defined in the Passengers node.
                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Passengers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element ref="PassengerReference"/>
         *       &lt;xs:element ref="GroupReference"/>
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Passengers implements Serializable
        {
            private int passengersSelect = -1;
            private static final int PASSENGER_REFERENCE_CHOICE = 0;
            private static final int GROUP_REFERENCE_CHOICE = 1;
            private PassengerReference passengerReference;
            private GroupReference groupReference;

            private void setPassengersSelect(int choice) {
                if (passengersSelect == -1) {
                    passengersSelect = choice;
                } else if (passengersSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearPassengersSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearPassengersSelect() {
                passengersSelect = -1;
            }

            /** 
             * Check if PassengerReference is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifPassengerReference() {
                return passengersSelect == PASSENGER_REFERENCE_CHOICE;
            }

            /** 
             * Get the 'PassengerReference' element value. 
                              Association to multiple Passenger instance(s). Example: pax1 pax2
                            
             * 
             * @return value
             */
            public PassengerReference getPassengerReference() {
                return passengerReference;
            }

            /** 
             * Set the 'PassengerReference' element value. 
                              Association to multiple Passenger instance(s). Example: pax1 pax2
                            
             * 
             * @param passengerReference
             */
            public void setPassengerReference(
                    PassengerReference passengerReference) {
                setPassengersSelect(PASSENGER_REFERENCE_CHOICE);
                this.passengerReference = passengerReference;
            }

            /** 
             * Check if GroupReference is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifGroupReference() {
                return passengersSelect == GROUP_REFERENCE_CHOICE;
            }

            /** 
             * Get the 'GroupReference' element value.
             * 
             * @return value
             */
            public GroupReference getGroupReference() {
                return groupReference;
            }

            /** 
             * Set the 'GroupReference' element value.
             * 
             * @param groupReference
             */
            public void setGroupReference(GroupReference groupReference) {
                setPassengersSelect(GROUP_REFERENCE_CHOICE);
                this.groupReference = groupReference;
            }
        }
        /** 
         * 
                      Other Named Association(s). Note: Includes an association type choice (e.g. MediaGroup) and an instance association value (e.g. mediagrp1).
                    
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherAssociation" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="RefValue"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OtherAssociation implements Serializable
        {
            private String type;
            private String refValue;

            /** 
             * Get the 'Type' attribute value. 
                            Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                          
             * 
             * @return value
             */
            public String getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value. 
                            Named Instance Association Type. Examples: CarryOnAllowance, MediaGroup
                          
             * 
             * @param type
             */
            public void setType(String type) {
                this.type = type;
            }

            /** 
             * Get the 'RefValue' attribute value. 
                            Associated object instance value. Example: mediagrp1
                          
             * 
             * @return value
             */
            public String getRefValue() {
                return refValue;
            }

            /** 
             * Set the 'RefValue' attribute value. 
                            Associated object instance value. Example: mediagrp1
                          
             * 
             * @param refValue
             */
            public void setRefValue(String refValue) {
                this.refValue = refValue;
            }
        }
    }
}
