
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Other service information group.  If TravelerAssociationNumber is not included, then OSI applies to all travelers.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://ndc.farelogix.com/aug" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OtherServiceInformation">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="xs:string" name="TravelerIDRef" minOccurs="0" maxOccurs="unbounded"/>
 *       &lt;xs:element type="xs:string" name="AirlineCode" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="OSICode" minOccurs="0"/>
 *       &lt;xs:element type="xs:string" name="Text"/>
 *       &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class OtherServiceInformation implements Serializable
{
    private List<String> travelerIDRefList = new ArrayList<String>();
    private String airlineCode;
    private String OSICode;
    private String text;
    private String actionCode;

    /** 
     * Get the list of 'TravelerIDRef' element items. Unique association ID reference of the traveler associated to this item. No comma separated lists and no ranges allowed.        Example: T1
     * 
     * @return list
     */
    public List<String> getTravelerIDRefList() {
        return travelerIDRefList;
    }

    /** 
     * Set the list of 'TravelerIDRef' element items. Unique association ID reference of the traveler associated to this item. No comma separated lists and no ranges allowed.        Example: T1
     * 
     * @param list
     */
    public void setTravelerIDRefList(List<String> list) {
        travelerIDRefList = list;
    }

    /** 
     * Get the 'AirlineCode' element value. Airline code.  Example: AA
     * 
     * @return value
     */
    public String getAirlineCode() {
        return airlineCode;
    }

    /** 
     * Set the 'AirlineCode' element value. Airline code.  Example: AA
     * 
     * @param airlineCode
     */
    public void setAirlineCode(String airlineCode) {
        this.airlineCode = airlineCode;
    }

    /** 
     * Get the 'OSICode' element value. Conventional code (AIRIMP code) for other service information. Recommended to use when sending OSI to airline. Example: CTCA
     * 
     * @return value
     */
    public String getOSICode() {
        return OSICode;
    }

    /** 
     * Set the 'OSICode' element value. Conventional code (AIRIMP code) for other service information. Recommended to use when sending OSI to airline. Example: CTCA
     * 
     * @param OSICode
     */
    public void setOSICode(String OSICode) {
        this.OSICode = OSICode;
    }

    /** 
     * Get the 'Text' element value. Information text or error text. Example: Free flow text.  
     * 
     * @return value
     */
    public String getText() {
        return text;
    }

    /** 
     * Set the 'Text' element value. Information text or error text. Example: Free flow text.  
     * 
     * @param text
     */
    public void setText(String text) {
        this.text = text;
    }

    /** 
     * Get the 'ActionCode' element value. Action code.  Example: HK
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. Action code.  Example: HK
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }
}
