
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Partner Company Type contextual list.
 Examples: ServiceProvider, ServiceFulfillment, Merchandise
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PartnerTypeListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AirPassProgramHolder"/>
 *     &lt;xs:enumeration value="Merchandise"/>
 *     &lt;xs:enumeration value="ServiceFulfillment"/>
 *     &lt;xs:enumeration value="ServiceProvider"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PartnerTypeListType implements Serializable {
    AIR_PASS_PROGRAM_HOLDER("AirPassProgramHolder"), MERCHANDISE("Merchandise"), SERVICE_FULFILLMENT(
            "ServiceFulfillment"), SERVICE_PROVIDER("ServiceProvider"), OTHER(
            "Other");
    private final String value;

    private PartnerTypeListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PartnerTypeListType convert(String value) {
        for (PartnerTypeListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
