
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for PAYMENT CARD Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCardMetadataType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CardCode"/>
 *     &lt;xs:element type="xs:string" name="CardName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CardType" minOccurs="0"/>
 *     &lt;xs:element name="CardFields" minOccurs="0">
 *       &lt;!-- Reference to inner class CardFields -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Surcharge" minOccurs="0">
 *       &lt;!-- Reference to inner class Surcharge -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="MetadataKey"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentCardMetadataType implements Serializable
{
    private String cardCode;
    private String cardName;
    private String cardType;
    private CardFields cardFields;
    private Surcharge surcharge;
    private String refs;
    private String metadataKey;

    /** 
     * Get the 'CardCode' element value. Card Schema code eg VI, AX, VD
     * 
     * @return value
     */
    public String getCardCode() {
        return cardCode;
    }

    /** 
     * Set the 'CardCode' element value. Card Schema code eg VI, AX, VD
     * 
     * @param cardCode
     */
    public void setCardCode(String cardCode) {
        this.cardCode = cardCode;
    }

    /** 
     * Get the 'CardName' element value. Card Schema name eg Visa, American Express, Visa Debit
     * 
     * @return value
     */
    public String getCardName() {
        return cardName;
    }

    /** 
     * Set the 'CardName' element value. Card Schema name eg Visa, American Express, Visa Debit
     * 
     * @param cardName
     */
    public void setCardName(String cardName) {
        this.cardName = cardName;
    }

    /** 
     * Get the 'CardType' element value. Card Type eg Credit, Debit
     * 
     * @return value
     */
    public String getCardType() {
        return cardType;
    }

    /** 
     * Set the 'CardType' element value. Card Type eg Credit, Debit
     * 
     * @param cardType
     */
    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    /** 
     * Get the 'CardFields' element value.
     * 
     * @return value
     */
    public CardFields getCardFields() {
        return cardFields;
    }

    /** 
     * Set the 'CardFields' element value.
     * 
     * @param cardFields
     */
    public void setCardFields(CardFields cardFields) {
        this.cardFields = cardFields;
    }

    /** 
     * Get the 'Surcharge' element value.
     * 
     * @return value
     */
    public Surcharge getSurcharge() {
        return surcharge;
    }

    /** 
     * Set the 'Surcharge' element value.
     * 
     * @param surcharge
     */
    public void setSurcharge(Surcharge surcharge) {
        this.surcharge = surcharge;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any object instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }

    /** 
     * Get the 'MetadataKey' attribute value. A globally unique identifier for this Metadata instance.
     * 
     * @return value
     */
    public String getMetadataKey() {
        return metadataKey;
    }

    /** 
     * Set the 'MetadataKey' attribute value. A globally unique identifier for this Metadata instance.
     * 
     * @param metadataKey
     */
    public void setMetadataKey(String metadataKey) {
        this.metadataKey = metadataKey;
    }
    /** 
     * List of fields required for this card
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CardFields" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FieldName" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class FieldName -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CardFields implements Serializable
    {
        private List<FieldName> fieldNameList = new ArrayList<FieldName>();

        /** 
         * Get the list of 'FieldName' element items.
         * 
         * @return list
         */
        public List<FieldName> getFieldNameList() {
            return fieldNameList;
        }

        /** 
         * Set the list of 'FieldName' element items.
         * 
         * @param list
         */
        public void setFieldNameList(List<FieldName> list) {
            fieldNameList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FieldName" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:boolean" use="required" name="Mandatory"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FieldName implements Serializable
        {
            private String string;
            private Boolean mandatory;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Mandatory' attribute value. If this field is required then true, otherwise false.
             * 
             * @return value
             */
            public Boolean getMandatory() {
                return mandatory;
            }

            /** 
             * Set the 'Mandatory' attribute value. If this field is required then true, otherwise false.
             * 
             * @param mandatory
             */
            public void setMandatory(Boolean mandatory) {
                this.mandatory = mandatory;
            }
        }
    }
    /** 
     * card surcharge information
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Surcharge" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element type="CurrencyAmountOptType" name="Amount"/>
     *       &lt;xs:element type="xs:decimal" name="PercentageValue"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Surcharge implements Serializable
    {
        private int surchargeSelect = -1;
        private static final int AMOUNT_CHOICE = 0;
        private static final int PERCENTAGE_VALUE_CHOICE = 1;
        private CurrencyAmountOptType amount;
        private BigDecimal percentageValue;

        private void setSurchargeSelect(int choice) {
            if (surchargeSelect == -1) {
                surchargeSelect = choice;
            } else if (surchargeSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearSurchargeSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearSurchargeSelect() {
            surchargeSelect = -1;
        }

        /** 
         * Check if Amount is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAmount() {
            return surchargeSelect == AMOUNT_CHOICE;
        }

        /** 
         * Get the 'Amount' element value.
         * 
         * @return value
         */
        public CurrencyAmountOptType getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' element value.
         * 
         * @param amount
         */
        public void setAmount(CurrencyAmountOptType amount) {
            setSurchargeSelect(AMOUNT_CHOICE);
            this.amount = amount;
        }

        /** 
         * Check if PercentageValue is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPercentageValue() {
            return surchargeSelect == PERCENTAGE_VALUE_CHOICE;
        }

        /** 
         * Get the 'PercentageValue' element value.
         * 
         * @return value
         */
        public BigDecimal getPercentageValue() {
            return percentageValue;
        }

        /** 
         * Set the 'PercentageValue' element value.
         * 
         * @param percentageValue
         */
        public void setPercentageValue(BigDecimal percentageValue) {
            setSurchargeSelect(PERCENTAGE_VALUE_CHOICE);
            this.percentageValue = percentageValue;
        }
    }
}
