
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * PAYMENT METHOD definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentMethodType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Method" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Method -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentMethodType implements Serializable
{
    private List<Method> methodList = new ArrayList<Method>();

    /** 
     * Get the list of 'Method' element items.
     * 
     * @return list
     */
    public List<Method> getMethodList() {
        return methodList;
    }

    /** 
     * Set the list of 'Method' element items.
     * 
     * @param list
     */
    public void setMethodList(List<Method> list) {
        methodList = list;
    }
    /** 
     * Payment Method detail.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Method" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Qualifier" minOccurs="0"/>
     *       &lt;xs:element ref="VoucherMethod" minOccurs="0"/>
     *       &lt;xs:element ref="RedemptionMethod" minOccurs="0"/>
     *       &lt;xs:element ref="PaymentCardMethod" minOccurs="0"/>
     *       &lt;xs:element ref="OtherMethod" minOccurs="0"/>
     *       &lt;xs:element ref="MiscChargeMethod" minOccurs="0"/>
     *       &lt;xs:element ref="DirectBillMethod" minOccurs="0"/>
     *       &lt;xs:element ref="CashMethod" minOccurs="0"/>
     *       &lt;xs:element ref="BankAccountMethod" minOccurs="0"/>
     *       &lt;xs:element ref="Check" minOccurs="0"/>
     *       &lt;xs:element name="Promotions" minOccurs="0">
     *         &lt;!-- Reference to inner class Promotions -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Method implements Serializable
    {
        private String qualifier;
        private VoucherMethodType voucherMethod;
        private RedemptionMethodType redemptionMethod;
        private PaymentCardMethodType paymentCardMethod;
        private OtherMethodType otherMethod;
        private MiscChargeMethodType miscChargeMethod;
        private DirectBillMethodType directBillMethod;
        private CashMethodType cashMethod;
        private BankAccountMethodType bankAccountMethod;
        private Check check;
        private Promotions promotions;
        private String refs;

        /** 
         * Get the 'Qualifier' element value. Used to specify if this is the old, new, or orginal form of payment.

        Encoding Scheme: IATA  PADIS code list 9988 - Data Indicator
         * 
         * @return value
         */
        public String getQualifier() {
            return qualifier;
        }

        /** 
         * Set the 'Qualifier' element value. Used to specify if this is the old, new, or orginal form of payment.

        Encoding Scheme: IATA  PADIS code list 9988 - Data Indicator
         * 
         * @param qualifier
         */
        public void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        /** 
         * Get the 'VoucherMethod' element value.
         * 
         * @return value
         */
        public VoucherMethodType getVoucherMethod() {
            return voucherMethod;
        }

        /** 
         * Set the 'VoucherMethod' element value.
         * 
         * @param voucherMethod
         */
        public void setVoucherMethod(VoucherMethodType voucherMethod) {
            this.voucherMethod = voucherMethod;
        }

        /** 
         * Get the 'RedemptionMethod' element value.
         * 
         * @return value
         */
        public RedemptionMethodType getRedemptionMethod() {
            return redemptionMethod;
        }

        /** 
         * Set the 'RedemptionMethod' element value.
         * 
         * @param redemptionMethod
         */
        public void setRedemptionMethod(RedemptionMethodType redemptionMethod) {
            this.redemptionMethod = redemptionMethod;
        }

        /** 
         * Get the 'PaymentCardMethod' element value.
         * 
         * @return value
         */
        public PaymentCardMethodType getPaymentCardMethod() {
            return paymentCardMethod;
        }

        /** 
         * Set the 'PaymentCardMethod' element value.
         * 
         * @param paymentCardMethod
         */
        public void setPaymentCardMethod(PaymentCardMethodType paymentCardMethod) {
            this.paymentCardMethod = paymentCardMethod;
        }

        /** 
         * Get the 'OtherMethod' element value.
         * 
         * @return value
         */
        public OtherMethodType getOtherMethod() {
            return otherMethod;
        }

        /** 
         * Set the 'OtherMethod' element value.
         * 
         * @param otherMethod
         */
        public void setOtherMethod(OtherMethodType otherMethod) {
            this.otherMethod = otherMethod;
        }

        /** 
         * Get the 'MiscChargeMethod' element value.
         * 
         * @return value
         */
        public MiscChargeMethodType getMiscChargeMethod() {
            return miscChargeMethod;
        }

        /** 
         * Set the 'MiscChargeMethod' element value.
         * 
         * @param miscChargeMethod
         */
        public void setMiscChargeMethod(MiscChargeMethodType miscChargeMethod) {
            this.miscChargeMethod = miscChargeMethod;
        }

        /** 
         * Get the 'DirectBillMethod' element value.
         * 
         * @return value
         */
        public DirectBillMethodType getDirectBillMethod() {
            return directBillMethod;
        }

        /** 
         * Set the 'DirectBillMethod' element value.
         * 
         * @param directBillMethod
         */
        public void setDirectBillMethod(DirectBillMethodType directBillMethod) {
            this.directBillMethod = directBillMethod;
        }

        /** 
         * Get the 'CashMethod' element value.
         * 
         * @return value
         */
        public CashMethodType getCashMethod() {
            return cashMethod;
        }

        /** 
         * Set the 'CashMethod' element value.
         * 
         * @param cashMethod
         */
        public void setCashMethod(CashMethodType cashMethod) {
            this.cashMethod = cashMethod;
        }

        /** 
         * Get the 'BankAccountMethod' element value.
         * 
         * @return value
         */
        public BankAccountMethodType getBankAccountMethod() {
            return bankAccountMethod;
        }

        /** 
         * Set the 'BankAccountMethod' element value.
         * 
         * @param bankAccountMethod
         */
        public void setBankAccountMethod(BankAccountMethodType bankAccountMethod) {
            this.bankAccountMethod = bankAccountMethod;
        }

        /** 
         * Get the 'Check' element value. Check (Cheque) Payment
         * 
         * @return value
         */
        public Check getCheck() {
            return check;
        }

        /** 
         * Set the 'Check' element value. Check (Cheque) Payment
         * 
         * @param check
         */
        public void setCheck(Check check) {
            this.check = check;
        }

        /** 
         * Get the 'Promotions' element value.
         * 
         * @return value
         */
        public Promotions getPromotions() {
            return promotions;
        }

        /** 
         * Set the 'Promotions' element value.
         * 
         * @param promotions
         */
        public void setPromotions(Promotions promotions) {
            this.promotions = promotions;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Applied Promotions for this payment form.

        Note: If specified, this individual payment form information will override any globally specified promotion information.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Promotion" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Promotion -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Promotions implements Serializable
        {
            private List<Promotion> promotionList = new ArrayList<Promotion>();

            /** 
             * Get the list of 'Promotion' element items.
             * 
             * @return list
             */
            public List<Promotion> getPromotionList() {
                return promotionList;
            }

            /** 
             * Set the list of 'Promotion' element items.
             * 
             * @param list
             */
            public void setPromotionList(List<Promotion> list) {
                promotionList = list;
            }
            /** 
             * Promotion Detail.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Promotion" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:complexContent>
             *       &lt;xs:extension base="PromotionType">
             *         &lt;xs:sequence>
             *           &lt;xs:element ref="Associations"/>
             *         &lt;/xs:sequence>
             *       &lt;/xs:extension>
             *     &lt;/xs:complexContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Promotion extends PromotionType implements
                Serializable
            {
                private Associations associations;

                /** 
                 * Get the 'Associations' element value. Association(s), including Passenger and Group.
                 * 
                 * @return value
                 */
                public Associations getAssociations() {
                    return associations;
                }

                /** 
                 * Set the 'Associations' element value. Association(s), including Passenger and Group.
                 * 
                 * @param associations
                 */
                public void setAssociations(Associations associations) {
                    this.associations = associations;
                }
            }
        }
    }
}
