
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * A data type for Offer Penalty Type list constraint.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyListType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Cancellation"/>
 *     &lt;xs:enumeration value="Change"/>
 *     &lt;xs:enumeration value="NoShow"/>
 *     &lt;xs:enumeration value="Upgrade"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PenaltyListType implements Serializable {
    CANCELLATION("Cancellation"), CHANGE("Change"), NO_SHOW("NoShow"), UPGRADE(
            "Upgrade"), OTHER("Other");
    private final String value;

    private PenaltyListType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PenaltyListType convert(String value) {
        for (PenaltyListType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
