
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * 
 A data type for Policy Type list constraint. Examples: Privacy_PII, Payment_PCI, Credentialing

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PolicyTypeSimpleType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Privacy_PII"/>
 *     &lt;xs:enumeration value="Payment_PCI"/>
 *     &lt;xs:enumeration value="Credentialing"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PolicyTypeSimpleType implements Serializable {
    /** 
     * 
    Personnally Identifting Information Privacy Policy.
    
     */
    PRIVACY_PII("Privacy_PII"), PAYMENT_PCI("Payment_PCI"), CREDENTIALING(
            "Credentialing");
    private final String value;

    private PolicyTypeSimpleType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PolicyTypeSimpleType convert(String value) {
        for (PolicyTypeSimpleType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
