
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * PRE-PAID TRAVEL Programs.

 Notes:
 1. Supports pricing flight offers and/ or other benefits from non-revenue and Air Pass Program certificates.

 2. Each Prepaid Travel Program MUST be associated to ONE individual Traveler.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrePaidProgramQualifier">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="PrepaidProgramDetail">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:sequence>
 *               &lt;xs:element ref="AirlineID"/>
 *               &lt;xs:element name="Certificate" maxOccurs="unbounded">
 *                 &lt;!-- Reference to inner class Certificate -->
 *               &lt;/xs:element>
 *             &lt;/xs:sequence>
 *             &lt;xs:sequence>
 *               &lt;xs:element type="xs:string" name="ProgramName"/>
 *               &lt;xs:element type="xs:string" name="ProgramCode" minOccurs="0"/>
 *               &lt;xs:element name="Holder" minOccurs="0">
 *                 &lt;!-- Reference to inner class Holder -->
 *               &lt;/xs:element>
 *             &lt;/xs:sequence>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PrePaidProgramQualifier implements Serializable
{
    private AirlineIDType prepaidProgramDetailAirlineID;
    private List<Certificate> certificateList = new ArrayList<Certificate>();
    private String prepaidProgramDetailProgramName;
    private String prepaidProgramDetailProgramCode;
    private Holder holder;
    private String refs;

    /** 
     * Get the 'AirlineID' element value. Program issuing airline designator code. Example: BA

    Encoding Scheme: IATA/ A4A (two to three character) Airline Designator Code
     * 
     * @return value
     */
    public AirlineIDType getPrepaidProgramDetailAirlineID() {
        return prepaidProgramDetailAirlineID;
    }

    /** 
     * Set the 'AirlineID' element value. Program issuing airline designator code. Example: BA

    Encoding Scheme: IATA/ A4A (two to three character) Airline Designator Code
     * 
     * @param prepaidProgramDetailAirlineID
     */
    public void setPrepaidProgramDetailAirlineID(
            AirlineIDType prepaidProgramDetailAirlineID) {
        this.prepaidProgramDetailAirlineID = prepaidProgramDetailAirlineID;
    }

    /** 
     * Get the list of 'Certificate' element items.
     * 
     * @return list
     */
    public List<Certificate> getCertificateList() {
        return certificateList;
    }

    /** 
     * Set the list of 'Certificate' element items.
     * 
     * @param list
     */
    public void setCertificateList(List<Certificate> list) {
        certificateList = list;
    }

    /** 
     * Get the 'ProgramName' element value. Program Name. Example: PASSPRO
     * 
     * @return value
     */
    public String getPrepaidProgramDetailProgramName() {
        return prepaidProgramDetailProgramName;
    }

    /** 
     * Set the 'ProgramName' element value. Program Name. Example: PASSPRO
     * 
     * @param prepaidProgramDetailProgramName
     */
    public void setPrepaidProgramDetailProgramName(
            String prepaidProgramDetailProgramName) {
        this.prepaidProgramDetailProgramName = prepaidProgramDetailProgramName;
    }

    /** 
     * Get the 'ProgramCode' element value. Program Code. Example: PP01
     * 
     * @return value
     */
    public String getPrepaidProgramDetailProgramCode() {
        return prepaidProgramDetailProgramCode;
    }

    /** 
     * Set the 'ProgramCode' element value. Program Code. Example: PP01
     * 
     * @param prepaidProgramDetailProgramCode
     */
    public void setPrepaidProgramDetailProgramCode(
            String prepaidProgramDetailProgramCode) {
        this.prepaidProgramDetailProgramCode = prepaidProgramDetailProgramCode;
    }

    /** 
     * Get the 'Holder' element value.
     * 
     * @return value
     */
    public Holder getHolder() {
        return holder;
    }

    /** 
     * Set the 'Holder' element value.
     * 
     * @param holder
     */
    public void setHolder(Holder holder) {
        this.holder = holder;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Certificate information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Certificate" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Number">
     *         &lt;xs:complexType>
     *           &lt;xs:simpleContent>
     *             &lt;xs:extension base="xs:string">
     *               &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *             &lt;/xs:extension>
     *           &lt;/xs:simpleContent>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="Application" minOccurs="0"/>
     *       &lt;xs:element name="EffectivePeriod" minOccurs="0">
     *         &lt;!-- Reference to inner class EffectivePeriod -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * 
     * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
     *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
     * &lt;/xs:attributeGroup>
     * </pre>
     */
    public static class Certificate implements Serializable
    {
        private String numberString;
        private String numberRefs;
        private String application;
        private EffectivePeriod effectivePeriod;
        private String refs;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getNumberString() {
            return numberString;
        }

        /** 
         * Set the extension value.
         * 
         * @param numberString
         */
        public void setNumberString(String numberString) {
            this.numberString = numberString;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getNumberRefs() {
            return numberRefs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param numberRefs
         */
        public void setNumberRefs(String numberRefs) {
            this.numberRefs = numberRefs;
        }

        /** 
         * Get the 'Application' element value. Certificate Application.  Example: Billing
         * 
         * @return value
         */
        public String getApplication() {
            return application;
        }

        /** 
         * Set the 'Application' element value. Certificate Application.  Example: Billing
         * 
         * @param application
         */
        public void setApplication(String application) {
            this.application = application;
        }

        /** 
         * Get the 'EffectivePeriod' element value.
         * 
         * @return value
         */
        public EffectivePeriod getEffectivePeriod() {
            return effectivePeriod;
        }

        /** 
         * Set the 'EffectivePeriod' element value.
         * 
         * @param effectivePeriod
         */
        public void setEffectivePeriod(EffectivePeriod effectivePeriod) {
            this.effectivePeriod = effectivePeriod;
        }

        /** 
         * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @return value
         */
        public String getRefs() {
            return refs;
        }

        /** 
         * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
         * 
         * @param refs
         */
        public void setRefs(String refs) {
            this.refs = refs;
        }
        /** 
         * Certificate Effective/ Expiration Period.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EffectivePeriod" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="YearPeriod"/>
         *       &lt;xs:element ref="YearMonthPeriod"/>
         *       &lt;xs:element ref="TimePeriod"/>
         *       &lt;xs:element ref="QuarterPeriod"/>
         *       &lt;xs:element ref="MonthPeriod"/>
         *       &lt;xs:element ref="DayPeriod"/>
         *       &lt;xs:element ref="DateTimePeriod"/>
         *       &lt;xs:element ref="DatePeriod"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class EffectivePeriod implements Serializable
        {
            private YearPeriodRepType yearPeriod;
            private YearMonthPeriodRepType yearMonthPeriod;
            private TimePeriodRepType timePeriod;
            private QuarterPeriodRepType quarterPeriod;
            private MonthPeriodRepType monthPeriod;
            private DayPeriodRepType dayPeriod;
            private DateTimePeriodRepType dateTimePeriod;
            private DatePeriodRepType datePeriod;

            /** 
             * Get the 'YearPeriod' element value.
             * 
             * @return value
             */
            public YearPeriodRepType getYearPeriod() {
                return yearPeriod;
            }

            /** 
             * Set the 'YearPeriod' element value.
             * 
             * @param yearPeriod
             */
            public void setYearPeriod(YearPeriodRepType yearPeriod) {
                this.yearPeriod = yearPeriod;
            }

            /** 
             * Get the 'YearMonthPeriod' element value.
             * 
             * @return value
             */
            public YearMonthPeriodRepType getYearMonthPeriod() {
                return yearMonthPeriod;
            }

            /** 
             * Set the 'YearMonthPeriod' element value.
             * 
             * @param yearMonthPeriod
             */
            public void setYearMonthPeriod(
                    YearMonthPeriodRepType yearMonthPeriod) {
                this.yearMonthPeriod = yearMonthPeriod;
            }

            /** 
             * Get the 'TimePeriod' element value.
             * 
             * @return value
             */
            public TimePeriodRepType getTimePeriod() {
                return timePeriod;
            }

            /** 
             * Set the 'TimePeriod' element value.
             * 
             * @param timePeriod
             */
            public void setTimePeriod(TimePeriodRepType timePeriod) {
                this.timePeriod = timePeriod;
            }

            /** 
             * Get the 'QuarterPeriod' element value.
             * 
             * @return value
             */
            public QuarterPeriodRepType getQuarterPeriod() {
                return quarterPeriod;
            }

            /** 
             * Set the 'QuarterPeriod' element value.
             * 
             * @param quarterPeriod
             */
            public void setQuarterPeriod(QuarterPeriodRepType quarterPeriod) {
                this.quarterPeriod = quarterPeriod;
            }

            /** 
             * Get the 'MonthPeriod' element value.
             * 
             * @return value
             */
            public MonthPeriodRepType getMonthPeriod() {
                return monthPeriod;
            }

            /** 
             * Set the 'MonthPeriod' element value.
             * 
             * @param monthPeriod
             */
            public void setMonthPeriod(MonthPeriodRepType monthPeriod) {
                this.monthPeriod = monthPeriod;
            }

            /** 
             * Get the 'DayPeriod' element value.
             * 
             * @return value
             */
            public DayPeriodRepType getDayPeriod() {
                return dayPeriod;
            }

            /** 
             * Set the 'DayPeriod' element value.
             * 
             * @param dayPeriod
             */
            public void setDayPeriod(DayPeriodRepType dayPeriod) {
                this.dayPeriod = dayPeriod;
            }

            /** 
             * Get the 'DateTimePeriod' element value.
             * 
             * @return value
             */
            public DateTimePeriodRepType getDateTimePeriod() {
                return dateTimePeriod;
            }

            /** 
             * Set the 'DateTimePeriod' element value.
             * 
             * @param dateTimePeriod
             */
            public void setDateTimePeriod(DateTimePeriodRepType dateTimePeriod) {
                this.dateTimePeriod = dateTimePeriod;
            }

            /** 
             * Get the 'DatePeriod' element value.
             * 
             * @return value
             */
            public DatePeriodRepType getDatePeriod() {
                return datePeriod;
            }

            /** 
             * Set the 'DatePeriod' element value.
             * 
             * @param datePeriod
             */
            public void setDatePeriod(DatePeriodRepType datePeriod) {
                this.datePeriod = datePeriod;
            }
        }
    }
    /** 
     * Agency or Corporate Certificate holder or program owner information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Holder" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="AgencyID"/>
     *       &lt;xs:element ref="PartnerID"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Holder implements Serializable
    {
        private int holderSelect = -1;
        private static final int AGENCY_ID_CHOICE = 0;
        private static final int PARTNER_ID_CHOICE = 1;
        private AgencyID agencyID;
        private PartnerCompanyIDType partnerID;

        private void setHolderSelect(int choice) {
            if (holderSelect == -1) {
                holderSelect = choice;
            } else if (holderSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearHolderSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearHolderSelect() {
            holderSelect = -1;
        }

        /** 
         * Check if AgencyID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAgencyID() {
            return holderSelect == AGENCY_ID_CHOICE;
        }

        /** 
         * Get the 'AgencyID' element value.
         * 
         * @return value
         */
        public AgencyID getAgencyID() {
            return agencyID;
        }

        /** 
         * Set the 'AgencyID' element value.
         * 
         * @param agencyID
         */
        public void setAgencyID(AgencyID agencyID) {
            setHolderSelect(AGENCY_ID_CHOICE);
            this.agencyID = agencyID;
        }

        /** 
         * Check if PartnerID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPartnerID() {
            return holderSelect == PARTNER_ID_CHOICE;
        }

        /** 
         * Get the 'PartnerID' element value.
         * 
         * @return value
         */
        public PartnerCompanyIDType getPartnerID() {
            return partnerID;
        }

        /** 
         * Set the 'PartnerID' element value.
         * 
         * @param partnerID
         */
        public void setPartnerID(PartnerCompanyIDType partnerID) {
            setHolderSelect(PARTNER_ID_CHOICE);
            this.partnerID = partnerID;
        }
    }
}
