
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * Offer/ Offer Item: PRICE GUARANTEE Time Limit definition.

 Price Guarantee Time Limit value.
 Examples: 2017-05-30T09:00:00,  2015-01-13T13:59:38Z

 Notes:
 1. This is the period for which an Offer price is guaranteed.

 2. On expiry an Offer may be re-priced up to the point an accountable document is issued.

 3. A Price Guarantee cannot extend beyond the Offer Expiration Time Limit unless an Order has been created.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceGuarTimeLimitType">
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PriceGuarTimeLimitType implements Serializable
{
    private String refs;

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
