
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * PROMOTION helper object.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PromotionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Code">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="xs:string">
 *             &lt;xs:attributeGroup ref="ObjectPolicyMetaAttrGroup"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Link" minOccurs="0"/>
 *     &lt;xs:element name="Issuer" minOccurs="0">
 *       &lt;!-- Reference to inner class Issuer -->
 *     &lt;/xs:element>
 *     &lt;xs:element ref="Remarks" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VoucherOwner" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class PromotionType implements Serializable
{
    private String codeString;
    private ObjectPolicyMetaAttrGroup codeObjectPolicyMetaAttrGroup;
    private String link;
    private Issuer issuer;
    private Remarks remarks;
    private String voucherOwner;
    private String refs;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getCodeString() {
        return codeString;
    }

    /** 
     * Set the extension value.
     * 
     * @param codeString
     */
    public void setCodeString(String codeString) {
        this.codeString = codeString;
    }

    /** 
     * Get the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
     * 
     * @return value
     */
    public ObjectPolicyMetaAttrGroup getCodeObjectPolicyMetaAttrGroup() {
        return codeObjectPolicyMetaAttrGroup;
    }

    /** 
     * Set the 'ObjectPolicyMetaAttrGroup' attributeGroup value.
     * 
     * @param codeObjectPolicyMetaAttrGroup
     */
    public void setCodeObjectPolicyMetaAttrGroup(
            ObjectPolicyMetaAttrGroup codeObjectPolicyMetaAttrGroup) {
        this.codeObjectPolicyMetaAttrGroup = codeObjectPolicyMetaAttrGroup;
    }

    /** 
     * Get the 'Link' element value. Promotion url. Example: http://promos.site.com
     * 
     * @return value
     */
    public String getLink() {
        return link;
    }

    /** 
     * Set the 'Link' element value. Promotion url. Example: http://promos.site.com
     * 
     * @param link
     */
    public void setLink(String link) {
        this.link = link;
    }

    /** 
     * Get the 'Issuer' element value.
     * 
     * @return value
     */
    public Issuer getIssuer() {
        return issuer;
    }

    /** 
     * Set the 'Issuer' element value.
     * 
     * @param issuer
     */
    public void setIssuer(Issuer issuer) {
        this.issuer = issuer;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }

    /** 
     * Get the 'VoucherOwner' element value. This is the name of the person holding the voucher."
     * 
     * @return value
     */
    public String getVoucherOwner() {
        return voucherOwner;
    }

    /** 
     * Set the 'VoucherOwner' element value. This is the name of the person holding the voucher."
     * 
     * @param voucherOwner
     */
    public void setVoucherOwner(String voucherOwner) {
        this.voucherOwner = voucherOwner;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
    /** 
     * Promotion Owner or Sponsor.
    Used in conjunction with Code (Promotion code ID or number), Link (Promotion URL),  and Remarks (Promotion remarks).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Issuer" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="AirlineID"/>
     *       &lt;xs:element ref="AgencyID"/>
     *       &lt;xs:element ref="PartnerID"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Issuer implements Serializable
    {
        private int issuerSelect = -1;
        private static final int AIRLINE_ID_CHOICE = 0;
        private static final int AGENCY_ID_CHOICE = 1;
        private static final int PARTNER_ID_CHOICE = 2;
        private AirlineIDType airlineID;
        private AgencyID agencyID;
        private PartnerCompanyIDType partnerID;

        private void setIssuerSelect(int choice) {
            if (issuerSelect == -1) {
                issuerSelect = choice;
            } else if (issuerSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearIssuerSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearIssuerSelect() {
            issuerSelect = -1;
        }

        /** 
         * Check if AirlineID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAirlineID() {
            return issuerSelect == AIRLINE_ID_CHOICE;
        }

        /** 
         * Get the 'AirlineID' element value. A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .

         * 
         * @return value
         */
        public AirlineIDType getAirlineID() {
            return airlineID;
        }

        /** 
         * Set the 'AirlineID' element value. A two-character alpha-numeric code assigned according to the IATA Resolution 762 or a three-letter airline designator assigned by ICAO.  Refer to IATA Airline Coding Directory .

         * 
         * @param airlineID
         */
        public void setAirlineID(AirlineIDType airlineID) {
            setIssuerSelect(AIRLINE_ID_CHOICE);
            this.airlineID = airlineID;
        }

        /** 
         * Check if AgencyID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAgencyID() {
            return issuerSelect == AGENCY_ID_CHOICE;
        }

        /** 
         * Get the 'AgencyID' element value.
         * 
         * @return value
         */
        public AgencyID getAgencyID() {
            return agencyID;
        }

        /** 
         * Set the 'AgencyID' element value.
         * 
         * @param agencyID
         */
        public void setAgencyID(AgencyID agencyID) {
            setIssuerSelect(AGENCY_ID_CHOICE);
            this.agencyID = agencyID;
        }

        /** 
         * Check if PartnerID is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPartnerID() {
            return issuerSelect == PARTNER_ID_CHOICE;
        }

        /** 
         * Get the 'PartnerID' element value.
         * 
         * @return value
         */
        public PartnerCompanyIDType getPartnerID() {
            return partnerID;
        }

        /** 
         * Set the 'PartnerID' element value.
         * 
         * @param partnerID
         */
        public void setPartnerID(PartnerCompanyIDType partnerID) {
            setIssuerSelect(PARTNER_ID_CHOICE);
            this.partnerID = partnerID;
        }
    }
}
