
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;

/** 
 * The reissued flown flight coupon information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReissuedFlownType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="FlightCouponData" minOccurs="0">
 *       &lt;!-- Reference to inner class FlightCouponData -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="Number"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="CouponItinerarySeqNbr"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FareBasisCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TicketDocumentNbr"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="DateOfIssue"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="WaiverCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TicketDesignatorCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReissuedFlownType implements Serializable
{
    private FlightCouponData flightCouponData;
    private BigInteger number;
    private BigInteger couponItinerarySeqNbr;
    private String fareBasisCode;
    private String ticketDocumentNbr;
    private LocalDate dateOfIssue;
    private String waiverCode;
    private String ticketDesignatorCode;

    /** 
     * Get the 'FlightCouponData' element value.
     * 
     * @return value
     */
    public FlightCouponData getFlightCouponData() {
        return flightCouponData;
    }

    /** 
     * Set the 'FlightCouponData' element value.
     * 
     * @param flightCouponData
     */
    public void setFlightCouponData(FlightCouponData flightCouponData) {
        this.flightCouponData = flightCouponData;
    }

    /** 
     * Get the 'Number' attribute value. Coupon number.
     * 
     * @return value
     */
    public BigInteger getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' attribute value. Coupon number.
     * 
     * @param number
     */
    public void setNumber(BigInteger number) {
        this.number = number;
    }

    /** 
     * Get the 'CouponItinerarySeqNbr' attribute value. The number representing the order in which this coupon was used or is to be used.
     * 
     * @return value
     */
    public BigInteger getCouponItinerarySeqNbr() {
        return couponItinerarySeqNbr;
    }

    /** 
     * Set the 'CouponItinerarySeqNbr' attribute value. The number representing the order in which this coupon was used or is to be used.
     * 
     * @param couponItinerarySeqNbr
     */
    public void setCouponItinerarySeqNbr(BigInteger couponItinerarySeqNbr) {
        this.couponItinerarySeqNbr = couponItinerarySeqNbr;
    }

    /** 
     * Get the 'FareBasisCode' attribute value. The applicable fare basis code.
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' attribute value. The applicable fare basis code.
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'TicketDocumentNbr' attribute value. Document number comprised of the airline code, form code, and serial number.
     * 
     * @return value
     */
    public String getTicketDocumentNbr() {
        return ticketDocumentNbr;
    }

    /** 
     * Set the 'TicketDocumentNbr' attribute value. Document number comprised of the airline code, form code, and serial number.
     * 
     * @param ticketDocumentNbr
     */
    public void setTicketDocumentNbr(String ticketDocumentNbr) {
        this.ticketDocumentNbr = ticketDocumentNbr;
    }

    /** 
     * Get the 'DateOfIssue' attribute value. The date the ticket was issued.
     * 
     * @return value
     */
    public LocalDate getDateOfIssue() {
        return dateOfIssue;
    }

    /** 
     * Set the 'DateOfIssue' attribute value. The date the ticket was issued.
     * 
     * @param dateOfIssue
     */
    public void setDateOfIssue(LocalDate dateOfIssue) {
        this.dateOfIssue = dateOfIssue;
    }

    /** 
     * Get the 'WaiverCode' attribute value. A validating carrier assigned code allowing a fare rule modification or override applied to a flown coupon from the ticket being reissued.
     * 
     * @return value
     */
    public String getWaiverCode() {
        return waiverCode;
    }

    /** 
     * Set the 'WaiverCode' attribute value. A validating carrier assigned code allowing a fare rule modification or override applied to a flown coupon from the ticket being reissued.
     * 
     * @param waiverCode
     */
    public void setWaiverCode(String waiverCode) {
        this.waiverCode = waiverCode;
    }

    /** 
     * Get the 'TicketDesignatorCode' attribute value. The applicable code as provided for in ATA SIPP Reso 110.16 or IATA Reso 728, for each flown coupon from the ticket being reissued.
     * 
     * @return value
     */
    public String getTicketDesignatorCode() {
        return ticketDesignatorCode;
    }

    /** 
     * Set the 'TicketDesignatorCode' attribute value. The applicable code as provided for in ATA SIPP Reso 110.16 or IATA Reso 728, for each flown coupon from the ticket being reissued.
     * 
     * @param ticketDesignatorCode
     */
    public void setTicketDesignatorCode(String ticketDesignatorCode) {
        this.ticketDesignatorCode = ticketDesignatorCode;
    }
    /** 
     * Departure, date, time, arrival, RPH, flight number information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightCouponData" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="CouponFlightSegmentType">
     *         &lt;xs:sequence>
     *           &lt;xs:element name="IntermediateStop" minOccurs="0" maxOccurs="9">
     *             &lt;!-- Reference to inner class IntermediateStop -->
     *           &lt;/xs:element>
     *         &lt;/xs:sequence>
     *         &lt;xs:attribute type="xs:boolean" use="optional" name="StopoverInd"/>
     *         &lt;xs:attribute type="xs:string" name="InvoluntaryIndCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightCouponData extends CouponFlightSegmentType
        implements Serializable
    {
        private List<IntermediateStop> intermediateStopList = new ArrayList<IntermediateStop>();
        private Boolean stopoverInd;
        private String involuntaryIndCode;

        /** 
         * Get the list of 'IntermediateStop' element items.
         * 
         * @return list
         */
        public List<IntermediateStop> getIntermediateStopList() {
            return intermediateStopList;
        }

        /** 
         * Set the list of 'IntermediateStop' element items.
         * 
         * @param list
         */
        public void setIntermediateStopList(List<IntermediateStop> list) {
            intermediateStopList = list;
        }

        /** 
         * Get the 'StopoverInd' attribute value. When true, a stopover is permitted.
         * 
         * @return value
         */
        public Boolean getStopoverInd() {
            return stopoverInd;
        }

        /** 
         * Set the 'StopoverInd' attribute value. When true, a stopover is permitted.
         * 
         * @param stopoverInd
         */
        public void setStopoverInd(Boolean stopoverInd) {
            this.stopoverInd = stopoverInd;
        }

        /** 
         * Get the 'InvoluntaryIndCode' attribute value. Used to indiccate when a transaction occurred due to a diversion en route.  Refer to IATA PADIS Code List for data element 1245.
         * 
         * @return value
         */
        public String getInvoluntaryIndCode() {
            return involuntaryIndCode;
        }

        /** 
         * Set the 'InvoluntaryIndCode' attribute value. Used to indiccate when a transaction occurred due to a diversion en route.  Refer to IATA PADIS Code List for data element 1245.
         * 
         * @param involuntaryIndCode
         */
        public void setInvoluntaryIndCode(String involuntaryIndCode) {
            this.involuntaryIndCode = involuntaryIndCode;
        }
        /** 
         * An intermediate airport/city code stop.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IntermediateStop" minOccurs="0" maxOccurs="9">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="AiportCode"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class IntermediateStop implements Serializable
        {
            private String aiportCode;

            /** 
             * Get the 'AiportCode' attribute value. Airport city code.
             * 
             * @return value
             */
            public String getAiportCode() {
                return aiportCode;
            }

            /** 
             * Set the 'AiportCode' attribute value. Airport city code.
             * 
             * @param aiportCode
             */
            public void setAiportCode(String aiportCode) {
                this.aiportCode = aiportCode;
            }
        }
    }
}
