
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A data type for RULE Metadata.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RuleMetadataType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="MetadataObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="RuleID"/>
 *         &lt;xs:element type="xs:string" name="Name" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Status" minOccurs="0"/>
 *         &lt;xs:element name="Values" minOccurs="0">
 *           &lt;!-- Reference to inner class Values -->
 *         &lt;/xs:element>
 *         &lt;xs:element ref="Remarks" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RuleMetadataType extends MetadataObjectBaseType implements
    Serializable
{
    private String ruleID;
    private String name;
    private String status;
    private Values values;
    private Remarks remarks;

    /** 
     * Get the 'RuleID' element value. Unique Rule ID which was applied during transaction processing. Example: PRICERULE001 Note: Optional rule context and name may also be specified.
     * 
     * @return value
     */
    public String getRuleID() {
        return ruleID;
    }

    /** 
     * Set the 'RuleID' element value. Unique Rule ID which was applied during transaction processing. Example: PRICERULE001 Note: Optional rule context and name may also be specified.
     * 
     * @param ruleID
     */
    public void setRuleID(String ruleID) {
        this.ruleID = ruleID;
    }

    /** 
     * Get the 'Name' element value. Rule name.  Example: Rule001
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Rule name.  Example: Rule001
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'Status' element value. Rule status.  Examples: ActionRequired, RuleExecuted, Other
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value. Rule status.  Examples: ActionRequired, RuleExecuted, Other
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 
     * Get the 'Values' element value.
     * 
     * @return value
     */
    public Values getValues() {
        return values;
    }

    /** 
     * Set the 'Values' element value.
     * 
     * @param values
     */
    public void setValues(Values values) {
        this.values = values;
    }

    /** 
     * Get the 'Remarks' element value.
     * 
     * @return value
     */
    public Remarks getRemarks() {
        return remarks;
    }

    /** 
     * Set the 'Remarks' element value.
     * 
     * @param remarks
     */
    public void setRemarks(Remarks remarks) {
        this.remarks = remarks;
    }
    /** 
     * Rule Value(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Values" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Value" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Value -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Values implements Serializable
    {
        private List<Value> valueList = new ArrayList<Value>();

        /** 
         * Get the list of 'Value' element items.
         * 
         * @return list
         */
        public List<Value> getValueList() {
            return valueList;
        }

        /** 
         * Set the list of 'Value' element items.
         * 
         * @param list
         */
        public void setValueList(List<Value> list) {
            valueList = list;
        }
        /** 
         * Rule value detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Value" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element ref="NodePath" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="Instruction"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Value implements Serializable
        {
            private List<NodePathType> nodePathList = new ArrayList<NodePathType>();
            private String instruction;

            /** 
             * Get the list of 'NodePath' element items.
             * 
             * @return list
             */
            public List<NodePathType> getNodePathList() {
                return nodePathList;
            }

            /** 
             * Set the list of 'NodePath' element items.
             * 
             * @param list
             */
            public void setNodePathList(List<NodePathType> list) {
                nodePathList = list;
            }

            /** 
             * Get the 'Instruction' element value. Business rule instruction.
            Example: [NodePath.r1] {EQ('FR')} [NodePath.r2]{EQ(true)}
             * 
             * @return value
             */
            public String getInstruction() {
                return instruction;
            }

            /** 
             * Set the 'Instruction' element value. Business rule instruction.
            Example: [NodePath.r1] {EQ('FR')} [NodePath.r2]{EQ(true)}
             * 
             * @param instruction
             */
            public void setInstruction(String instruction) {
                this.instruction = instruction;
            }
        }
    }
}
