
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Seat size and marketing information definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatDataType">
 *   &lt;xs:sequence>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="Descriptions" name="Descriptions" minOccurs="0"/>
 *       &lt;xs:element type="SizeUnitSimpleType" name="UOM" minOccurs="0"/>
 *       &lt;xs:choice>
 *         &lt;xs:sequence>
 *           &lt;!-- Reference to inner class Sequence -->
 *         &lt;/xs:sequence>
 *         &lt;xs:element name="Keywords" minOccurs="0">
 *           &lt;!-- Reference to inner class Keywords -->
 *         &lt;/xs:element>
 *       &lt;/xs:choice>
 *     &lt;/xs:sequence>
 *     &lt;xs:element type="SeatMapMessageType" name="Marketing" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatDataType implements Serializable
{
    private Descriptions descriptions;
    private SizeUnitSimpleType UOM;
    private int choiceSelect = -1;
    private static final int SEAT_PITCH_LOW_CHOICE = 0;
    private static final int KEYWORDS_CHOICE = 1;
    private Sequence seatPitchLow;
    private Keywords keywords;
    private SeatMapMessageType marketing;

    /** 
     * Get the 'Descriptions' element value.
     * 
     * @return value
     */
    public Descriptions getDescriptions() {
        return descriptions;
    }

    /** 
     * Set the 'Descriptions' element value.
     * 
     * @param descriptions
     */
    public void setDescriptions(Descriptions descriptions) {
        this.descriptions = descriptions;
    }

    /** 
     * Get the 'UOM' element value. Associated Keyword Unit of Measure, if relevant. Example: INCH
     * 
     * @return value
     */
    public SizeUnitSimpleType getUOM() {
        return UOM;
    }

    /** 
     * Set the 'UOM' element value. Associated Keyword Unit of Measure, if relevant. Example: INCH
     * 
     * @param UOM
     */
    public void setUOM(SizeUnitSimpleType UOM) {
        this.UOM = UOM;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if SeatPitchLow is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSeatPitchLow() {
        return choiceSelect == SEAT_PITCH_LOW_CHOICE;
    }

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getSeatPitchLow() {
        return seatPitchLow;
    }

    /** 
     * Set the sequence value.
     * 
     * @param seatPitchLow
     */
    public void setSeatPitchLow(Sequence seatPitchLow) {
        setChoiceSelect(SEAT_PITCH_LOW_CHOICE);
        this.seatPitchLow = seatPitchLow;
    }

    /** 
     * Check if Keywords is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifKeywords() {
        return choiceSelect == KEYWORDS_CHOICE;
    }

    /** 
     * Get the 'Keywords' element value.
     * 
     * @return value
     */
    public Keywords getKeywords() {
        return keywords;
    }

    /** 
     * Set the 'Keywords' element value.
     * 
     * @param keywords
     */
    public void setKeywords(Keywords keywords) {
        setChoiceSelect(KEYWORDS_CHOICE);
        this.keywords = keywords;
    }

    /** 
     * Get the 'Marketing' element value. Images and/or links for the entire section defined by the range of rows.
     * 
     * @return value
     */
    public SeatMapMessageType getMarketing() {
        return marketing;
    }

    /** 
     * Set the 'Marketing' element value. Images and/or links for the entire section defined by the range of rows.
     * 
     * @param marketing
     */
    public void setMarketing(SeatMapMessageType marketing) {
        this.marketing = marketing;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:element type="xs:decimal" name="SeatPitchLow" minOccurs="0"/>
     *   &lt;xs:element type="xs:decimal" name="SeatWidthLow" minOccurs="0"/>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private BigDecimal seatPitchLow;
        private BigDecimal seatWidthLow;

        /** 
         * Get the 'SeatPitchLow' element value. Lowest Pitch Measurement value for this section. Example: 32
         * 
         * @return value
         */
        public BigDecimal getSeatPitchLow() {
            return seatPitchLow;
        }

        /** 
         * Set the 'SeatPitchLow' element value. Lowest Pitch Measurement value for this section. Example: 32
         * 
         * @param seatPitchLow
         */
        public void setSeatPitchLow(BigDecimal seatPitchLow) {
            this.seatPitchLow = seatPitchLow;
        }

        /** 
         * Get the 'SeatWidthLow' element value. Lowest Width Measurement value for this section. Example: 20
         * 
         * @return value
         */
        public BigDecimal getSeatWidthLow() {
            return seatWidthLow;
        }

        /** 
         * Set the 'SeatWidthLow' element value. Lowest Width Measurement value for this section. Example: 20
         * 
         * @param seatWidthLow
         */
        public void setSeatWidthLow(BigDecimal seatWidthLow) {
            this.seatWidthLow = seatWidthLow;
        }
    }
    /** 
     * Seat Description Key-Value Word Pairs.
    Examples:
    ReclineDegree - 25
    BedLengthLowEnd - 68
    BedLengthHighEnd - 78
    WidthLowEnd - 20
    WidthHighEnd - 21.5
    PitchLowEnd - 32
    PitchHighEnd - 34.4

     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Keywords" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="KeyWordType" name="KeyWord" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Keywords implements Serializable
    {
        private List<KeyWordType> keyWordList = new ArrayList<KeyWordType>();

        /** 
         * Get the list of 'KeyWord' element items. Key-Value detail.
         * 
         * @return list
         */
        public List<KeyWordType> getKeyWordList() {
            return keyWordList;
        }

        /** 
         * Set the list of 'KeyWord' element items. Key-Value detail.
         * 
         * @param list
         */
        public void setKeyWordList(List<KeyWordType> list) {
            keyWordList = list;
        }
    }
}
