
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

/** 
 * SECURE PAYMENT definiton.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurePaymentAlertType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="TrxProcessObjectBaseType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="PayerAuth" minOccurs="0">
 *           &lt;!-- Reference to inner class PayerAuth -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="TransactionType" minOccurs="0">
 *           &lt;!-- Reference to inner class TransactionType -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="EnrollmentStatus" minOccurs="0">
 *           &lt;!-- Reference to inner class EnrollmentStatus -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Airline" minOccurs="0">
 *           &lt;!-- Reference to inner class Airline -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="Reference" minOccurs="0">
 *           &lt;!-- Reference to inner class Reference -->
 *         &lt;/xs:element>
 *         &lt;xs:element type="SecurePaymentUrlType" name="URLs" minOccurs="0"/>
 *         &lt;xs:element name="Details" minOccurs="0">
 *           &lt;!-- Reference to inner class Details -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="ProcessingInfos" minOccurs="0">
 *           &lt;!-- Reference to inner class ProcessingInfos -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SecurePaymentAlertType extends TrxProcessObjectBaseType implements
    Serializable
{
    private PayerAuth payerAuth;
    private TransactionType transactionType;
    private EnrollmentStatus enrollmentStatus;
    private Airline airline;
    private Reference reference;
    private SecurePaymentUrlType URLs;
    private Details details;
    private ProcessingInfos processingInfos;

    /** 
     * Get the 'PayerAuth' element value.
     * 
     * @return value
     */
    public PayerAuth getPayerAuth() {
        return payerAuth;
    }

    /** 
     * Set the 'PayerAuth' element value.
     * 
     * @param payerAuth
     */
    public void setPayerAuth(PayerAuth payerAuth) {
        this.payerAuth = payerAuth;
    }

    /** 
     * Get the 'TransactionType' element value.
     * 
     * @return value
     */
    public TransactionType getTransactionType() {
        return transactionType;
    }

    /** 
     * Set the 'TransactionType' element value.
     * 
     * @param transactionType
     */
    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    /** 
     * Get the 'EnrollmentStatus' element value.
     * 
     * @return value
     */
    public EnrollmentStatus getEnrollmentStatus() {
        return enrollmentStatus;
    }

    /** 
     * Set the 'EnrollmentStatus' element value.
     * 
     * @param enrollmentStatus
     */
    public void setEnrollmentStatus(EnrollmentStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    /** 
     * Get the 'Airline' element value.
     * 
     * @return value
     */
    public Airline getAirline() {
        return airline;
    }

    /** 
     * Set the 'Airline' element value.
     * 
     * @param airline
     */
    public void setAirline(Airline airline) {
        this.airline = airline;
    }

    /** 
     * Get the 'Reference' element value.
     * 
     * @return value
     */
    public Reference getReference() {
        return reference;
    }

    /** 
     * Set the 'Reference' element value.
     * 
     * @param reference
     */
    public void setReference(Reference reference) {
        this.reference = reference;
    }

    /** 
     * Get the 'URLs' element value. Airline and 3DS Merchant URL(s).
     * 
     * @return value
     */
    public SecurePaymentUrlType getURLs() {
        return URLs;
    }

    /** 
     * Set the 'URLs' element value. Airline and 3DS Merchant URL(s).
     * 
     * @param URLs
     */
    public void setURLs(SecurePaymentUrlType URLs) {
        this.URLs = URLs;
    }

    /** 
     * Get the 'Details' element value.
     * 
     * @return value
     */
    public Details getDetails() {
        return details;
    }

    /** 
     * Set the 'Details' element value.
     * 
     * @param details
     */
    public void setDetails(Details details) {
        this.details = details;
    }

    /** 
     * Get the 'ProcessingInfos' element value.
     * 
     * @return value
     */
    public ProcessingInfos getProcessingInfos() {
        return processingInfos;
    }

    /** 
     * Set the 'ProcessingInfos' element value.
     * 
     * @param processingInfos
     */
    public void setProcessingInfos(ProcessingInfos processingInfos) {
        this.processingInfos = processingInfos;
    }
    /** 
     * Payer Authentication Request or Response structure.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PayerAuth" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element type="xs:string" name="PAReq"/>
     *       &lt;xs:element type="xs:string" name="PARes"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PayerAuth implements Serializable
    {
        private int payerAuthSelect = -1;
        private static final int PA_REQ_CHOICE = 0;
        private static final int PA_RES_CHOICE = 1;
        private String PAReq;
        private String PARes;

        private void setPayerAuthSelect(int choice) {
            if (payerAuthSelect == -1) {
                payerAuthSelect = choice;
            } else if (payerAuthSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearPayerAuthSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearPayerAuthSelect() {
            payerAuthSelect = -1;
        }

        /** 
         * Check if PAReq is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPAReq() {
            return payerAuthSelect == PA_REQ_CHOICE;
        }

        /** 
         * Get the 'PAReq' element value. Payer Authentication Request value.
        Example: eNp1UttugzAM/RXE+0gosF5kUkFZtT506rp222sUvJatXBqgtPv6JQzW7WFRIvnY1rF9HJie04NxQlk
        meeabtkVNAzO/GAw==
         * 
         * @return value
         */
        public String getPAReq() {
            return PAReq;
        }

        /** 
         * Set the 'PAReq' element value. Payer Authentication Request value.
        Example: eNp1UttugzAM/RXE+0gosF5kUkFZtT506rp222sUvJatXBqgtPv6JQzW7WFRIvnY1rF9HJie04NxQlk
        meeabtkVNAzO/GAw==
         * 
         * @param PAReq
         */
        public void setPAReq(String PAReq) {
            setPayerAuthSelect(PA_REQ_CHOICE);
            this.PAReq = PAReq;
        }

        /** 
         * Check if PARes is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPARes() {
            return payerAuthSelect == PA_RES_CHOICE;
        }

        /** 
         * Get the 'PARes' element value. Payer Authentication Response value.
        Example: eJzVWFmzosgSfudXdPQ8Gt1sbkzYRhQ7KCjI/sYOsimgoL/+lp7Tp5c5t2d67tMw8yv/WqiluJXS8WyyVFEQT28qz

        Note: This is the PARes (Payer Authentication Response) to be POSTed back to the TermURL (the URL to which the user will be directed at the conclusion of 3D secure authentication.)
         * 
         * @return value
         */
        public String getPARes() {
            return PARes;
        }

        /** 
         * Set the 'PARes' element value. Payer Authentication Response value.
        Example: eJzVWFmzosgSfudXdPQ8Gt1sbkzYRhQ7KCjI/sYOsimgoL/+lp7Tp5c5t2d67tMw8yv/WqiluJXS8WyyVFEQT28qz

        Note: This is the PARes (Payer Authentication Response) to be POSTed back to the TermURL (the URL to which the user will be directed at the conclusion of 3D secure authentication.)
         * 
         * @param PARes
         */
        public void setPARes(String PARes) {
            setPayerAuthSelect(PA_RES_CHOICE);
            this.PARes = PARes;
        }
    }
    /** 
     * 3D Secure Transaction Type.
    Examples:
    Authorize: Authorize amount (no funds transferred)
    Complete: Complete a previous authorization (funds are transferred)
    Purchase: Purchase (funds are transferred immediately)
    Refund: Refund (funds transferred immediately)
    Validate: Validation Transaction (a small authorized transaction amount to validate card details including expiry date and address)
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TransactionType" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TransactionType implements Serializable
    {
        private String string;
        private String context;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Context' attribute value. Transaction Type context.
         * 
         * @return value
         */
        public String getContext() {
            return context;
        }

        /** 
         * Set the 'Context' attribute value. Transaction Type context.
         * 
         * @param context
         */
        public void setContext(String context) {
            this.context = context;
        }
    }
    /** 
     * 3D Secure Program Enrollment Status. Examples: CardNotEnrolled, CardEnrolled, CardMayBeEnrolled, Unknown
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EnrollmentStatus" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EnrollmentStatus implements Serializable
    {
        private String string;
        private String context;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'Context' attribute value. Enrollment Status context.
         * 
         * @return value
         */
        public String getContext() {
            return context;
        }

        /** 
         * Set the 'Context' attribute value. Enrollment Status context.
         * 
         * @param context
         */
        public void setContext(String context) {
            this.context = context;
        }
    }
    /** 
     * Airline 3D Secure Payment Merchant Account information.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Airline" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ID" minOccurs="0">
     *         &lt;!-- Reference to inner class ID -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Name" minOccurs="0">
     *         &lt;!-- Reference to inner class Name -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Airline implements Serializable
    {
        private ID ID1;
        private Name name;
        private String countryCode;

        /** 
         * Get the 'ID' element value.
         * 
         * @return value
         */
        public ID getID1() {
            return ID1;
        }

        /** 
         * Set the 'ID' element value.
         * 
         * @param ID1
         */
        public void setID1(ID ID1) {
            this.ID1 = ID1;
        }

        /** 
         * Get the 'Name' element value.
         * 
         * @return value
         */
        public Name getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value.
         * 
         * @param name
         */
        public void setName(Name name) {
            this.name = name;
        }

        /** 
         * Get the 'CountryCode' element value. Airline Merchant Country Code. Example: GB

        Encoding Scheme: ISO 3166-1 (two character) Country Code
         * 
         * @return value
         */
        public String getCountryCode() {
            return countryCode;
        }

        /** 
         * Set the 'CountryCode' element value. Airline Merchant Country Code. Example: GB

        Encoding Scheme: ISO 3166-1 (two character) Country Code
         * 
         * @param countryCode
         */
        public void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }
        /** 
         * Airline Merchant Identification Code or Number. Example: BA123
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ID implements Serializable
        {
            private String string;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Context' attribute value. Airline Merchant ID context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Airline Merchant ID context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
        /** 
         * Merchant Name. Example: SecurePay
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Name" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Name implements Serializable
        {
            private String string;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Context' attribute value. Airline Merchant Name context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Airline Merchant Name context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
    }
    /** 
     * Transaction Reference(s).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Reference" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element ref="ACS_TxnReference" minOccurs="0"/>
     *       &lt;xs:element ref="SPM_TxnReference" minOccurs="0"/>
     *       &lt;xs:element name="OriginalTransactionID" minOccurs="0">
     *         &lt;!-- Reference to inner class OriginalTransactionID -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:dateTime" name="TrxTimestamp" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="TxnDescription" minOccurs="0"/>
     *       &lt;xs:element name="TxnDatas" minOccurs="0">
     *         &lt;!-- Reference to inner class TxnDatas -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Reference implements Serializable
    {
        private ACSTxnReference ACSTxnReference;
        private SPMTxnReference SPMTxnReference;
        private OriginalTransactionID originalTransactionID;
        private DateTime trxTimestamp;
        private String txnDescription;
        private TxnDatas txnDatas;

        /** 
         * Get the 'ACS_TxnReference' element value.
         * 
         * @return value
         */
        public ACSTxnReference getACSTxnReference() {
            return ACSTxnReference;
        }

        /** 
         * Set the 'ACS_TxnReference' element value.
         * 
         * @param ACSTxnReference
         */
        public void setACSTxnReference(ACSTxnReference ACSTxnReference) {
            this.ACSTxnReference = ACSTxnReference;
        }

        /** 
         * Get the 'SPM_TxnReference' element value.
         * 
         * @return value
         */
        public SPMTxnReference getSPMTxnReference() {
            return SPMTxnReference;
        }

        /** 
         * Set the 'SPM_TxnReference' element value.
         * 
         * @param SPMTxnReference
         */
        public void setSPMTxnReference(SPMTxnReference SPMTxnReference) {
            this.SPMTxnReference = SPMTxnReference;
        }

        /** 
         * Get the 'OriginalTransactionID' element value.
         * 
         * @return value
         */
        public OriginalTransactionID getOriginalTransactionID() {
            return originalTransactionID;
        }

        /** 
         * Set the 'OriginalTransactionID' element value.
         * 
         * @param originalTransactionID
         */
        public void setOriginalTransactionID(
                OriginalTransactionID originalTransactionID) {
            this.originalTransactionID = originalTransactionID;
        }

        /** 
         * Get the 'TrxTimestamp' element value. 3DS Transaction Timestamp. Example: 2015-01-13T13:59:38Z
         * 
         * @return value
         */
        public DateTime getTrxTimestamp() {
            return trxTimestamp;
        }

        /** 
         * Set the 'TrxTimestamp' element value. 3DS Transaction Timestamp. Example: 2015-01-13T13:59:38Z
         * 
         * @param trxTimestamp
         */
        public void setTrxTimestamp(DateTime trxTimestamp) {
            this.trxTimestamp = trxTimestamp;
        }

        /** 
         * Get the 'TxnDescription' element value. Transaction description. Example: Air Fare Two PAX
         * 
         * @return value
         */
        public String getTxnDescription() {
            return txnDescription;
        }

        /** 
         * Set the 'TxnDescription' element value. Transaction description. Example: Air Fare Two PAX
         * 
         * @param txnDescription
         */
        public void setTxnDescription(String txnDescription) {
            this.txnDescription = txnDescription;
        }

        /** 
         * Get the 'TxnDatas' element value.
         * 
         * @return value
         */
        public TxnDatas getTxnDatas() {
            return txnDatas;
        }

        /** 
         * Set the 'TxnDatas' element value.
         * 
         * @param txnDatas
         */
        public void setTxnDatas(TxnDatas txnDatas) {
            this.txnDatas = txnDatas;
        }
        /** 
         * The identifier of the original transaction that initiated this Traveler authentication. Example: TRN12345
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalTransactionID" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="source"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginalTransactionID implements Serializable
        {
            private String string;
            private String source;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'source' attribute value. ID or name of the source of this Transaction ID.  Examples: UA, ABC123

            Note: If this is an airline ID, use IATA/ A4A (two or three character) Airline Designator Code Encoding Scheme.
             * 
             * @return value
             */
            public String getSource() {
                return source;
            }

            /** 
             * Set the 'source' attribute value. ID or name of the source of this Transaction ID.  Examples: UA, ABC123

            Note: If this is an airline ID, use IATA/ A4A (two or three character) Airline Designator Code Encoding Scheme.
             * 
             * @param source
             */
            public void setSource(String source) {
                this.source = source;
            }
        }
        /** 
         * Other (free form text) Transaction Data(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TxnDatas" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="TxnDate" maxOccurs="3"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TxnDatas implements Serializable
        {
            private List<String> txnDateList = new ArrayList<String>();

            /** 
             * Get the list of 'TxnDate' element items. Other Transaction Data.
             * 
             * @return list
             */
            public List<String> getTxnDateList() {
                return txnDateList;
            }

            /** 
             * Set the list of 'TxnDate' element items. Other Transaction Data.
             * 
             * @param list
             */
            public void setTxnDateList(List<String> list) {
                txnDateList = list;
            }
        }
    }
    /** 
     * 3D Secure Payment Details, including 3DS Transaction Client, Customer Device, Input and Settlement Currency, Order Reservation Detail, Transaction Timestamp and Additional Data.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Details" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:dateTime" name="TrxTimestamp" minOccurs="0"/>
     *       &lt;xs:element name="ClientType" minOccurs="0">
     *         &lt;!-- Reference to inner class ClientType -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="CustomerDevice" minOccurs="0">
     *         &lt;!-- Reference to inner class CustomerDevice -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Currency" minOccurs="0">
     *         &lt;!-- Reference to inner class Currency -->
     *       &lt;/xs:element>
     *       &lt;xs:element ref="ReservationInfo" minOccurs="0"/>
     *       &lt;xs:element name="TxnDatas" minOccurs="0">
     *         &lt;!-- Reference to inner class TxnDatas -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Details implements Serializable
    {
        private DateTime trxTimestamp;
        private ClientType clientType;
        private CustomerDevice customerDevice;
        private Currency currency;
        private SecurePaymentPaxInfoType reservationInfo;
        private TxnDatas txnDatas;

        /** 
         * Get the 'TrxTimestamp' element value. 3DS Transaction Timestamp. Example: 2015-01-13T13:59:38Z
         * 
         * @return value
         */
        public DateTime getTrxTimestamp() {
            return trxTimestamp;
        }

        /** 
         * Set the 'TrxTimestamp' element value. 3DS Transaction Timestamp. Example: 2015-01-13T13:59:38Z
         * 
         * @param trxTimestamp
         */
        public void setTrxTimestamp(DateTime trxTimestamp) {
            this.trxTimestamp = trxTimestamp;
        }

        /** 
         * Get the 'ClientType' element value.
         * 
         * @return value
         */
        public ClientType getClientType() {
            return clientType;
        }

        /** 
         * Set the 'ClientType' element value.
         * 
         * @param clientType
         */
        public void setClientType(ClientType clientType) {
            this.clientType = clientType;
        }

        /** 
         * Get the 'CustomerDevice' element value.
         * 
         * @return value
         */
        public CustomerDevice getCustomerDevice() {
            return customerDevice;
        }

        /** 
         * Set the 'CustomerDevice' element value.
         * 
         * @param customerDevice
         */
        public void setCustomerDevice(CustomerDevice customerDevice) {
            this.customerDevice = customerDevice;
        }

        /** 
         * Get the 'Currency' element value.
         * 
         * @return value
         */
        public Currency getCurrency() {
            return currency;
        }

        /** 
         * Set the 'Currency' element value.
         * 
         * @param currency
         */
        public void setCurrency(Currency currency) {
            this.currency = currency;
        }

        /** 
         * Get the 'ReservationInfo' element value. 3D Secure Transaction Airline Reservation information.
         * 
         * @return value
         */
        public SecurePaymentPaxInfoType getReservationInfo() {
            return reservationInfo;
        }

        /** 
         * Set the 'ReservationInfo' element value. 3D Secure Transaction Airline Reservation information.
         * 
         * @param reservationInfo
         */
        public void setReservationInfo(SecurePaymentPaxInfoType reservationInfo) {
            this.reservationInfo = reservationInfo;
        }

        /** 
         * Get the 'TxnDatas' element value.
         * 
         * @return value
         */
        public TxnDatas getTxnDatas() {
            return txnDatas;
        }

        /** 
         * Set the 'TxnDatas' element value.
         * 
         * @param txnDatas
         */
        public void setTxnDatas(TxnDatas txnDatas) {
            this.txnDatas = txnDatas;
        }
        /** 
         * 3DS TransactionClient Type.
        Examples:
        InteractiveVoiceResponse (IVR)
        Internet
        MailOrTelephoneOrder (MOTO)
        Recurring
        Unattended
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ClientType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ClientType implements Serializable
        {
            private String string;
            private String context;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Context' attribute value. Client Type context.
             * 
             * @return value
             */
            public String getContext() {
                return context;
            }

            /** 
             * Set the 'Context' attribute value. Client Type context.
             * 
             * @param context
             */
            public void setContext(String context) {
                this.context = context;
            }
        }
        /** 
         * Device upon which the secure transaction will occur.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerDevice" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="DeviceType">
         *         &lt;xs:sequence>
         *           &lt;xs:element type="xs:string" name="BowserAcceptHeader" minOccurs="0"/>
         *           &lt;xs:element type="xs:string" name="BrowserUserAgentHeader" minOccurs="0"/>
         *           &lt;xs:element type="xs:string" name="DeviceCategoryCode" minOccurs="0"/>
         *         &lt;/xs:sequence>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CustomerDevice extends DeviceType implements
            Serializable
        {
            private String bowserAcceptHeader;
            private String browserUserAgentHeader;
            private String deviceCategoryCode;

            /** 
             * Get the 'BowserAcceptHeader' element value. Browser Accept Header.

            Note: This contains MIME types accepted by the device.
             * 
             * @return value
             */
            public String getBowserAcceptHeader() {
                return bowserAcceptHeader;
            }

            /** 
             * Set the 'BowserAcceptHeader' element value. Browser Accept Header.

            Note: This contains MIME types accepted by the device.
             * 
             * @param bowserAcceptHeader
             */
            public void setBowserAcceptHeader(String bowserAcceptHeader) {
                this.bowserAcceptHeader = bowserAcceptHeader;
            }

            /** 
             * Get the 'BrowserUserAgentHeader' element value. User Agent String.

            Note: This contains the user agent string.
             * 
             * @return value
             */
            public String getBrowserUserAgentHeader() {
                return browserUserAgentHeader;
            }

            /** 
             * Set the 'BrowserUserAgentHeader' element value. User Agent String.

            Note: This contains the user agent string.
             * 
             * @param browserUserAgentHeader
             */
            public void setBrowserUserAgentHeader(String browserUserAgentHeader) {
                this.browserUserAgentHeader = browserUserAgentHeader;
            }

            /** 
             * Get the 'DeviceCategoryCode' element value. Device type. Example: Desktop, Mobile

            Note: This is the device that the transaction will occur on.
             * 
             * @return value
             */
            public String getDeviceCategoryCode() {
                return deviceCategoryCode;
            }

            /** 
             * Set the 'DeviceCategoryCode' element value. Device type. Example: Desktop, Mobile

            Note: This is the device that the transaction will occur on.
             * 
             * @param deviceCategoryCode
             */
            public void setDeviceCategoryCode(String deviceCategoryCode) {
                this.deviceCategoryCode = deviceCategoryCode;
            }
        }
        /** 
         * Input and Settlement Currency Code(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Currency" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="InputCurrCode" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="SettlementCurrCode" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Currency implements Serializable
        {
            private String inputCurrCode;
            private String settlementCurrCode;

            /** 
             * Get the 'InputCurrCode' element value. Input Payment Currency code. Example: USD

            Encoding Scheme: ISO 4217 (three alpha character) Currency Code
             * 
             * @return value
             */
            public String getInputCurrCode() {
                return inputCurrCode;
            }

            /** 
             * Set the 'InputCurrCode' element value. Input Payment Currency code. Example: USD

            Encoding Scheme: ISO 4217 (three alpha character) Currency Code
             * 
             * @param inputCurrCode
             */
            public void setInputCurrCode(String inputCurrCode) {
                this.inputCurrCode = inputCurrCode;
            }

            /** 
             * Get the 'SettlementCurrCode' element value. Settlement Payment Currency code. Example: CHF

            Encoding Scheme: ISO 4217 (three alpha character) Currency Code
             * 
             * @return value
             */
            public String getSettlementCurrCode() {
                return settlementCurrCode;
            }

            /** 
             * Set the 'SettlementCurrCode' element value. Settlement Payment Currency code. Example: CHF

            Encoding Scheme: ISO 4217 (three alpha character) Currency Code
             * 
             * @param settlementCurrCode
             */
            public void setSettlementCurrCode(String settlementCurrCode) {
                this.settlementCurrCode = settlementCurrCode;
            }
        }
        /** 
         * Other (free form text) Transaction Data(s).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TxnDatas" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="TxnDate" maxOccurs="3"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TxnDatas implements Serializable
        {
            private List<String> txnDateList = new ArrayList<String>();

            /** 
             * Get the list of 'TxnDate' element items. Other Transaction Data.
             * 
             * @return list
             */
            public List<String> getTxnDateList() {
                return txnDateList;
            }

            /** 
             * Set the list of 'TxnDate' element items. Other Transaction Data.
             * 
             * @param list
             */
            public void setTxnDateList(List<String> list) {
                txnDateList = list;
            }
        }
    }
    /** 
     * Secure Payment-related Processing information, including AVS/ CVV Verification Results and Secure Payment Processing Results.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProcessingInfos" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ProcessingInfo" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ProcessingInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ProcessingInfos implements Serializable
    {
        private List<ProcessingInfo> processingInfoList = new ArrayList<ProcessingInfo>();

        /** 
         * Get the list of 'ProcessingInfo' element items.
         * 
         * @return list
         */
        public List<ProcessingInfo> getProcessingInfoList() {
            return processingInfoList;
        }

        /** 
         * Set the list of 'ProcessingInfo' element items.
         * 
         * @param list
         */
        public void setProcessingInfoList(List<ProcessingInfo> list) {
            processingInfoList = list;
        }
        /** 
         * Processing Information detail.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProcessingInfo" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="AddrVerification" minOccurs="0">
         *         &lt;!-- Reference to inner class AddrVerification -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="CAVV" minOccurs="0"/>
         *       &lt;xs:element name="CustomerAuthStatus" minOccurs="0">
         *         &lt;!-- Reference to inner class CustomerAuthStatus -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="xs:string" name="ECI" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ProcessingInfo implements Serializable
        {
            private AddrVerification addrVerification;
            private String CAVV;
            private CustomerAuthStatus customerAuthStatus;
            private String ECI;

            /** 
             * Get the 'AddrVerification' element value.
             * 
             * @return value
             */
            public AddrVerification getAddrVerification() {
                return addrVerification;
            }

            /** 
             * Set the 'AddrVerification' element value.
             * 
             * @param addrVerification
             */
            public void setAddrVerification(AddrVerification addrVerification) {
                this.addrVerification = addrVerification;
            }

            /** 
             * Get the 'CAVV' element value. The unique Cardholder Authentication Verification Value (CAVV) associated with the transaction, provided by the card issuer.
            Example: Q0FWVkNBVlZDQVZWQ0FWVkNBVlY=

            Note: Only returned if card is enrolled and authenticated.
             * 
             * @return value
             */
            public String getCAVV() {
                return CAVV;
            }

            /** 
             * Set the 'CAVV' element value. The unique Cardholder Authentication Verification Value (CAVV) associated with the transaction, provided by the card issuer.
            Example: Q0FWVkNBVlZDQVZWQ0FWVkNBVlY=

            Note: Only returned if card is enrolled and authenticated.
             * 
             * @param CAVV
             */
            public void setCAVV(String CAVV) {
                this.CAVV = CAVV;
            }

            /** 
             * Get the 'CustomerAuthStatus' element value.
             * 
             * @return value
             */
            public CustomerAuthStatus getCustomerAuthStatus() {
                return customerAuthStatus;
            }

            /** 
             * Set the 'CustomerAuthStatus' element value.
             * 
             * @param customerAuthStatus
             */
            public void setCustomerAuthStatus(
                    CustomerAuthStatus customerAuthStatus) {
                this.customerAuthStatus = customerAuthStatus;
            }

            /** 
             * Get the 'ECI' element value. The ECI (E-Commerce Indicator) security level associated with the transaction.
            Example: 05

            Note: Only returned if card is enrolled and authenticated.
             * 
             * @return value
             */
            public String getECI() {
                return ECI;
            }

            /** 
             * Set the 'ECI' element value. The ECI (E-Commerce Indicator) security level associated with the transaction.
            Example: 05

            Note: Only returned if card is enrolled and authenticated.
             * 
             * @param ECI
             */
            public void setECI(String ECI) {
                this.ECI = ECI;
            }
            /** 
             * Address Verification Status Response information.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddrVerification" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Text"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="InvalidInd"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="NoMatchInd"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AddrVerification implements Serializable
            {
                private String code;
                private String text;
                private Boolean invalidInd;
                private Boolean noMatchInd;

                /** 
                 * Get the 'Code' attribute value. AVS Response Code.

                Examples:
                X - Match: Street address and 9-digit ZIP code both match
                Y - Match: Street address and 5-digit ZIP code both match
                A - Partial Match: Street address matches, but both 5-digit and 9-digit ZIP Code do not match
                W - Partial Match: Street address does not match, but 9-digit ZIP code matches
                Z - Partial Match: Street address does not match, but 5-digit ZIP code matches
                N - No Match: Street address, 5-digit ZIP code, and 9-digit ZIP code all do not match
                U - System Unavailable: Address information unavailable. Returned if non-US. AVS is not available or if the AVS in a U.S. bank is not functioning properly.
                R - System Unavailable: Retry - Issuer's System Unavailable or Timed Out.
                E - Invalid: AVS data is invalid
                S - Not Supported: U.S. issuing bank does not support AVS

                Note: This is the address verification response code (AVS) when the ticketing agency performs address verification.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value. AVS Response Code.

                Examples:
                X - Match: Street address and 9-digit ZIP code both match
                Y - Match: Street address and 5-digit ZIP code both match
                A - Partial Match: Street address matches, but both 5-digit and 9-digit ZIP Code do not match
                W - Partial Match: Street address does not match, but 9-digit ZIP code matches
                Z - Partial Match: Street address does not match, but 5-digit ZIP code matches
                N - No Match: Street address, 5-digit ZIP code, and 9-digit ZIP code all do not match
                U - System Unavailable: Address information unavailable. Returned if non-US. AVS is not available or if the AVS in a U.S. bank is not functioning properly.
                R - System Unavailable: Retry - Issuer's System Unavailable or Timed Out.
                E - Invalid: AVS data is invalid
                S - Not Supported: U.S. issuing bank does not support AVS

                Note: This is the address verification response code (AVS) when the ticketing agency performs address verification.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }

                /** 
                 * Get the 'Text' attribute value. Additional Response Text from 3DS Provider.
                 * 
                 * @return value
                 */
                public String getText() {
                    return text;
                }

                /** 
                 * Set the 'Text' attribute value. Additional Response Text from 3DS Provider.
                 * 
                 * @param text
                 */
                public void setText(String text) {
                    this.text = text;
                }

                /** 
                 * Get the 'InvalidInd' attribute value. When true, the specified address was invalid.
                 * 
                 * @return value
                 */
                public Boolean getInvalidInd() {
                    return invalidInd;
                }

                /** 
                 * Set the 'InvalidInd' attribute value. When true, the specified address was invalid.
                 * 
                 * @param invalidInd
                 */
                public void setInvalidInd(Boolean invalidInd) {
                    this.invalidInd = invalidInd;
                }

                /** 
                 * Get the 'NoMatchInd' attribute value. When true, the specified address could not be matched with issuing bank address on record.
                 * 
                 * @return value
                 */
                public Boolean getNoMatchInd() {
                    return noMatchInd;
                }

                /** 
                 * Set the 'NoMatchInd' attribute value. When true, the specified address could not be matched with issuing bank address on record.
                 * 
                 * @param noMatchInd
                 */
                public void setNoMatchInd(Boolean noMatchInd) {
                    this.noMatchInd = noMatchInd;
                }
            }
            /** 
             * 3DS Program ACS Customer Authention Status. 
            Examples:
            Y- Customer authenticated.
            N- Customer not authenticated.
            A- An authentication attempt occurred but could not be completed.
            U- Unable to perform authentication.

            Note: Only returned if card is enrolled.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerAuthStatus" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:simpleContent>
             *       &lt;xs:extension base="xs:string">
             *         &lt;xs:attribute type="xs:string" use="optional" name="Context"/>
             *       &lt;/xs:extension>
             *     &lt;/xs:simpleContent>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CustomerAuthStatus implements Serializable
            {
                private String string;
                private String context;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public String getString() {
                    return string;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param string
                 */
                public void setString(String string) {
                    this.string = string;
                }

                /** 
                 * Get the 'Context' attribute value. Enrollment Status context.
                 * 
                 * @return value
                 */
                public String getContext() {
                    return context;
                }

                /** 
                 * Set the 'Context' attribute value. Enrollment Status context.
                 * 
                 * @param context
                 */
                public void setContext(String context) {
                    this.context = context;
                }
            }
        }
    }
}
