
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * SECURE PAYMENT URL definition.
 A data type for Airline and 3DS Merchant URL(s).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecurePaymentUrlType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ACS_URL" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FailURL" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MerchantURL" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TermURL" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SecurePaymentUrlType implements Serializable
{
    private String ACSURL;
    private String failURL;
    private String merchantURL;
    private String termURL;

    /** 
     * Get the 'ACS_URL' element value. 3DS Access Control System URL.

    Note: This is the URL of the Issuing Bank's ACS, to which the cardholder needs to be re-directed. The browser should simply redirect to this URL.
     * 
     * @return value
     */
    public String getACSURL() {
        return ACSURL;
    }

    /** 
     * Set the 'ACS_URL' element value. 3DS Access Control System URL.

    Note: This is the URL of the Issuing Bank's ACS, to which the cardholder needs to be re-directed. The browser should simply redirect to this URL.
     * 
     * @param ACSURL
     */
    public void setACSURL(String ACSURL) {
        this.ACSURL = ACSURL;
    }

    /** 
     * Get the 'FailURL' element value. Airline URL to which the user will be directed in the event of an secure auhorization failure.
    Example: http://ba.com/paymentResultFailure
     * 
     * @return value
     */
    public String getFailURL() {
        return failURL;
    }

    /** 
     * Set the 'FailURL' element value. Airline URL to which the user will be directed in the event of an secure auhorization failure.
    Example: http://ba.com/paymentResultFailure
     * 
     * @param failURL
     */
    public void setFailURL(String failURL) {
        this.failURL = failURL;
    }

    /** 
     * Get the 'MerchantURL' element value. Verification Merchant website URL.

    Note: This is the verification source merchant URL.
     * 
     * @return value
     */
    public String getMerchantURL() {
        return merchantURL;
    }

    /** 
     * Set the 'MerchantURL' element value. Verification Merchant website URL.

    Note: This is the verification source merchant URL.
     * 
     * @param merchantURL
     */
    public void setMerchantURL(String merchantURL) {
        this.merchantURL = merchantURL;
    }

    /** 
     * Get the 'TermURL' element value. The URL to which the user will be directed to at the conclusion of 3D secure authentication.
    Example: http://ba.com/paymentResultSuccess
     * 
     * @return value
     */
    public String getTermURL() {
        return termURL;
    }

    /** 
     * Set the 'TermURL' element value. The URL to which the user will be directed to at the conclusion of 3D secure authentication.
    Example: http://ba.com/paymentResultSuccess
     * 
     * @param termURL
     */
    public void setTermURL(String termURL) {
        this.termURL = termURL;
    }
}
