
package com.gridnine.farelogix.ndc;

import java.io.Serializable;

/** 
 * OPTIONAL SERVICE ENCODING definition.

 Note: Includes IATA Optional Service Reason for Issuance Code (RFIC) code and Issuance Sub Code.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceEncodingType">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="RFIC" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Type" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Code" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SubCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ServiceEncodingType implements Serializable
{
    private RFIC RFIC;
    private String type;
    private String code;
    private String subCode;
    private String refs;

    /** 
     * Get the 'RFIC' element value.
     * 
     * @return value
     */
    public RFIC getRFIC() {
        return RFIC;
    }

    /** 
     * Set the 'RFIC' element value.
     * 
     * @param RFIC
     */
    public void setRFIC(RFIC RFIC) {
        this.RFIC = RFIC;
    }

    /** 
     * Get the 'Type' element value. Indicator if this option is a discount or a surcharge or a fee formula calculation. Refer to PADIS Codeset SFB for Service Fee Basis
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Indicator if this option is a discount or a surcharge or a fee formula calculation. Refer to PADIS Codeset SFB for Service Fee Basis
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'Code' element value. Service code. Examples:
    XLEG (Extra Leg Room Seat, implementer encoding)
    XBAG (Extra Bag, implementer encoding).  
    Used in conjunction with SubCode (Associated Reason For Issuance SubCode).
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Service code. Examples:
    XLEG (Extra Leg Room Seat, implementer encoding)
    XBAG (Extra Bag, implementer encoding).  
    Used in conjunction with SubCode (Associated Reason For Issuance SubCode).
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'SubCode' element value. Associated Reason For Issuance Sub Code.
    
    Examples:
    0CC (First Checked Bag)
    0B1 (In-flight Entertainment)
    0BX (Lounge)
    0B3 (Meal/ Beverage)
    0B5 (Pre-reserved Seat Assignment)
    0G6 (Priority Boarding)

    Are these on an IATA Codelist or do they need to be added via FastTrack?
     * 
     * @return value
     */
    public String getSubCode() {
        return subCode;
    }

    /** 
     * Set the 'SubCode' element value. Associated Reason For Issuance Sub Code.
    
    Examples:
    0CC (First Checked Bag)
    0B1 (In-flight Entertainment)
    0BX (Lounge)
    0B3 (Meal/ Beverage)
    0B5 (Pre-reserved Seat Assignment)
    0G6 (Priority Boarding)

    Are these on an IATA Codelist or do they need to be added via FastTrack?
     * 
     * @param subCode
     */
    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
