
package com.gridnine.farelogix.ndc;

import java.io.Serializable;
import org.joda.time.DateTime;

/** 
 * Offer/ Offer Item: TICKET BY Time Limit definition.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketByTimeLimitType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:dateTime" name="TicketBy"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ObjAssociationAttrGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ObjAssociationAttrGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="refs"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class TicketByTimeLimitType implements Serializable
{
    private DateTime ticketBy;
    private String refs;

    /** 
     * Get the 'TicketBy' element value. Ticketing By Time Limit.  
    Example: 2017-05-30T09:00:00

    DEPRECATON NOTICE: 
    This element will be deprecated in the 2015.1 publication.

    Notes: This is not the Offer Expiration Time Limit that applies to offers in a shopping response. This is the date/ time when a ticket-associated offer must be ticketed, e.g. applicable to booking versus shopping. It has been left in the specification for backwards compatibility
     * 
     * @return value
     */
    public DateTime getTicketBy() {
        return ticketBy;
    }

    /** 
     * Set the 'TicketBy' element value. Ticketing By Time Limit.  
    Example: 2017-05-30T09:00:00

    DEPRECATON NOTICE: 
    This element will be deprecated in the 2015.1 publication.

    Notes: This is not the Offer Expiration Time Limit that applies to offers in a shopping response. This is the date/ time when a ticket-associated offer must be ticketed, e.g. applicable to booking versus shopping. It has been left in the specification for backwards compatibility
     * 
     * @param ticketBy
     */
    public void setTicketBy(DateTime ticketBy) {
        this.ticketBy = ticketBy;
    }

    /** 
     * Get the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @return value
     */
    public String getRefs() {
        return refs;
    }

    /** 
     * Set the 'refs' attribute value. Object association(s) between this object and any other object or metadata instance(s).
     * 
     * @param refs
     */
    public void setRefs(String refs) {
        this.refs = refs;
    }
}
