/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.payonline;

import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.BinHex;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;

class HandlerCompletePayment {
    HandlerCompletePayment() {
    }

    static void process(Map<String, String> request, Payment payment, List<Message> messages) throws Exception {
        boolean paymentSucceed;
        if (!HandlerCompletePayment.checkSign(request, payment)) {
            throw new Exception("invalid sign");
        }
        payment.setPaymentType(HandlerCompletePayment.getPaymentType(request));
        payment.setAmount(new BigDecimal(String.valueOf(request.get("Amount"))));
        boolean bl = paymentSucceed = request.get("success").equals("1");
        if (paymentSucceed) {
            payment.setStatus(PaymentStatus.SUCCEEDED);
        } else {
            payment.setStatus(PaymentStatus.FAILED);
        }
    }

    private static boolean checkSign(Map<String, String> request, Payment payment) throws Exception {
        MessageDigest md5 = null;
        String dateTime = request.get("DateTime");
        String transactionId = request.get("TransactionID");
        String orderId = request.get("OrderId");
        String amount = request.get("Amount");
        String currency = request.get("Currency");
        SalesContext ctx = PaymentHelper.restoreSalesContext((Payment)payment);
        PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)ctx, (PgName)PgName.PAYONLINE, (Payment)payment);
        String privateSecurityKey = pgParameters.getPgPassword();
        StringBuilder sb = new StringBuilder();
        sb.append("DateTime=");
        sb.append(dateTime);
        sb.append("&TransactionID=");
        sb.append(transactionId);
        sb.append("&OrderId=");
        sb.append(orderId);
        sb.append("&Amount=");
        sb.append(amount);
        sb.append("&Currency=");
        sb.append(currency);
        sb.append("&PrivateSecurityKey=");
        sb.append(privateSecurityKey);
        String result = sb.toString();
        md5 = MessageDigest.getInstance("MD5");
        byte[] b = result.getBytes();
        md5.update(b);
        String digest = BinHex.encode((byte[])md5.digest());
        return digest.equalsIgnoreCase(request.get("SecurityKey"));
    }

    private static PaymentType getPaymentType(Map<String, String> request) {
        String paymentType = request.get("Provider");
        if (paymentType.equalsIgnoreCase("Card")) {
            return PaymentType.CREDIT_CARD_ONLINE_PAYONLINE;
        }
        if (paymentType.equalsIgnoreCase("Qiwi")) {
            return PaymentType.QIWI_PAYONLINE;
        }
        if (paymentType.equalsIgnoreCase("WebMoney")) {
            return PaymentType.WEBMONEY_PAYONLINE;
        }
        return null;
    }
}

