/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.payonline;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationParameters;
import com.gridnine.xtrip.common.pg.model.PaymentInitiationResult;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.BinHex;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.payonline.PayonlineConfiguration;
import com.gridnine.xtrip.server.pg.payonline.PayonlineHelper;
import com.gridnine.xtrip.server.pg.split.PgSabreSessionManager;
import com.gridnine.xtrip.server.pg.split.SplitPaymentHelper;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

class HandlerInitiatePayment {
    private static final Logger log = Logger.getLogger(HandlerInitiatePayment.class);
    private static final CodeTranslator codeTranslator = new CodeTranslator(new String[]{CodeSystem.IATA.name(), CodeSystem.CRT.name()});

    HandlerInitiatePayment() {
    }

    static void process(PaymentInitiationResult result, PaymentInitiationParameters parameters, PGParameters pgParameters, PayonlineConfiguration configuration) throws Exception {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat priceFormatter = new DecimalFormat("0.00", dfs);
        Payment payment = parameters.getPayment();
        boolean isSplitPayment = parameters.getPayment().getPaymentType() == PaymentType.CREDIT_CARD_SPLIT_PAYONLINE;
        EntityContainer bookingFile = PaymentHelper.getBookingFileContainer((Payment)payment);
        Reservation aviaReservation = BookingHelper.getBaseProductReservation((BookingFile)((BookingFile)bookingFile.getEntity()));
        String pnr = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)aviaReservation);
        String longRecord = TranslitUtil.cyr2lat((String)HandlerInitiatePayment.buildLongRecord(payment), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE);
        String redirectUrl = HandlerInitiatePayment.getRedirectUrl(configuration, result, pgParameters);
        result.getRedirectForm().setUrl(redirectUrl);
        List formParameters = result.getRedirectForm().getParameters();
        formParameters.add(NamedValueHelper.namedValue((String)"MerchantId", (String)pgParameters.getPgAccount()));
        formParameters.add(NamedValueHelper.namedValue((String)"OrderId", (String)parameters.getPayment().getPaymentId()));
        String amount = priceFormatter.format(HandlerInitiatePayment.getAmount(payment, configuration).doubleValue());
        formParameters.add(NamedValueHelper.namedValue((String)"Amount", (String)amount));
        formParameters.add(NamedValueHelper.namedValue((String)"Currency", (String)"RUB"));
        BigDecimal commisionAmount = BigDecimal.ZERO;
        if (isSplitPayment) {
            commisionAmount = HandlerInitiatePayment.getCommisionAmount((BookingFile)bookingFile.getEntity(), HandlerInitiatePayment.getAmount(payment, configuration), configuration);
            formParameters.add(NamedValueHelper.namedValue((String)"Commission", (String)priceFormatter.format(commisionAmount)));
            formParameters.add(NamedValueHelper.namedValue((String)"PNR", (String)pnr));
        }
        formParameters.add(NamedValueHelper.namedValue((String)"IData", (String)longRecord));
        if (isSplitPayment) {
            SabreSession createSession = PgSabreSessionManager.createSession((EntityContainer)bookingFile);
            String buildAcceptableCardValue = SplitPaymentHelper.buildAcceptableCardValue((Payment)payment, PayonlineHelper.payonlineCardVendors);
            if (!TextUtil.isBlank((String)buildAcceptableCardValue)) {
                formParameters.add(NamedValueHelper.namedValue((String)"CardVendors", (String)buildAcceptableCardValue));
            }
            formParameters.add(NamedValueHelper.namedValue((String)"ConversationId", (String)createSession.getConversationId()));
            formParameters.add(NamedValueHelper.namedValue((String)"IPCC", (String)createSession.getIpcc()));
            String binarySecurityToken = createSession.getBinarySecurityToken();
            binarySecurityToken = Base64.encode((byte[])binarySecurityToken.getBytes());
            formParameters.add(NamedValueHelper.namedValue((String)"SecurityToken", (String)binarySecurityToken));
        }
        formParameters.add(NamedValueHelper.namedValue((String)"PrivateSecurityKey", (String)pgParameters.getPgPassword()));
        String signature = HandlerInitiatePayment.generateSignature(formParameters);
        for (NamedValue namedValue : formParameters) {
            if (!namedValue.getName().equals("PrivateSecurityKey")) continue;
            namedValue.setName("SecurityKey");
            namedValue.setValue(signature);
            break;
        }
        formParameters.add(NamedValueHelper.namedValue((String)"ReturnUrl", (String)(parameters.getReturnUrl() + "&status=1")));
        formParameters.add(NamedValueHelper.namedValue((String)"FailUrl", (String)(parameters.getReturnUrl() + "&status=0")));
    }

    private static String buildLongRecord(Payment payment) throws Exception {
        String IData = null;
        if (payment.getEntity() != null && BookingFile.class.equals((Object)payment.getEntity().getType())) {
            StringBuilder idataBuilder = new StringBuilder("01");
            BookingFile bookFile = PaymentHelper.getBookingFile((Payment)payment);
            Product aviaTicket = null;
            for (BaseProduct baseProduct : ((Reservation)bookFile.getReservations().get(0)).getProducts()) {
                Product product = (Product)baseProduct;
                if (!DictHelper.isAdultPassengerType((DictionaryReference)product.getPassengerType())) continue;
                aviaTicket = product;
            }
            if (aviaTicket == null) {
                throw new NullPointerException();
            }
            Organization agency = (Organization)((EntityStorage)Environment.getPublished(EntityStorage.class)).resolve(AirProductHelper.getAgency(aviaTicket)).getEntity();
            String agencyCode = TranslitUtil.cyr2lat((String)agency.getCode(), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE);
            if (agencyCode.length() >= 8) {
                idataBuilder.append(agencyCode.substring(0, 8));
            } else {
                idataBuilder.append(agencyCode);
                for (int i = 0; i < 8 - agencyCode.length(); ++i) {
                    idataBuilder.append(' ');
                }
            }
            LinkedList<Segment> segmentList = new LinkedList<Segment>();
            for (SegmentTariff s : aviaTicket.getSegmentTariffs()) {
                for (Segment t : s.getSegments()) {
                    segmentList.add(t);
                }
            }
            if (segmentList.size() > 4) {
                int size = segmentList.size();
                for (int i = 1; i < size; ++i) {
                    segmentList.remove(1);
                    if (segmentList.size() == 4) break;
                }
            }
            for (Segment segment : segmentList) {
                idataBuilder.append(TranslitUtil.cyr2lat((String)codeTranslator.getNativeCode(segment.getAirline()), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE)).substring(0, 2);
                idataBuilder.append(segment.getClassOfSvcCode() == null ? " " : TranslitUtil.cyr2lat((String)segment.getClassOfSvcCode(), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.SIRENA_SERVICE_CLASSES_RULES).substring(0, 1));
                idataBuilder.append(' ');
                idataBuilder.append(TranslitUtil.cyr2lat((String)codeTranslator.getNativeCode(segment.getArriveLocation()), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE).substring(0, 3));
            }
            for (int i = 0; i < 4 - segmentList.size(); ++i) {
                idataBuilder.append("       ");
            }
            idataBuilder.append(' ');
            String locator = TranslitUtil.cyr2lat((String)CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)aviaTicket.getReservation()), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE);
            if (locator.length() >= 14) {
                idataBuilder.append(locator.substring(0, 14));
            } else {
                idataBuilder.append(locator);
                for (int i = 0; i < 14 - locator.length(); ++i) {
                    idataBuilder.append(' ');
                }
            }
            SimpleDateFormat df = new SimpleDateFormat("MMddyy");
            idataBuilder.append(df.format(((Segment)segmentList.get(0)).getStartDate()));
            idataBuilder.append(TranslitUtil.cyr2lat((String)codeTranslator.getNativeCode(((Segment)segmentList.get(segmentList.size() - 1)).getDepartureLocation()), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE).substring(0, 3));
            String name = TranslitUtil.cyr2lat((String)(aviaTicket.getTraveller().getPassport().getLastName() + " " + aviaTicket.getTraveller().getPassport().getFirstName()), (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.US_DEPARTMENT_OF_STATE);
            if (name.length() >= 20) {
                idataBuilder.append(name.substring(0, 20));
            } else {
                idataBuilder.append(name);
                for (int i = 0; i < 20 - name.length(); ++i) {
                    idataBuilder.append(' ');
                }
            }
            IData = idataBuilder.toString();
        }
        return IData;
    }

    static String generateSignature(List<NamedValue> formParameters) throws Exception {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (NamedValue namedValue : formParameters) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append(namedValue.getName());
            sb.append("=");
            sb.append(namedValue.getValue());
            ++i;
        }
        return HandlerInitiatePayment.encode(sb);
    }

    private static String encode(StringBuilder sb) throws Exception {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(sb.toString().getBytes());
        return BinHex.encode((byte[])md5.digest()).toLowerCase();
    }

    private static String getRedirectUrl(PayonlineConfiguration configuration, PaymentInitiationResult result, PGParameters pgParameters) {
        String baseUrl = configuration.getRedirectUrl();
        PaymentType paymentType = result.getPayment().getPaymentType();
        switch (paymentType) {
            case CREDIT_CARD_SPLIT_PAYONLINE: 
            case CREDIT_CARD_ONLINE_PAYONLINE: {
                if (pgParameters.getPgRedirectUrl() != null && !TextUtil.isBlank((String)pgParameters.getPgRedirectUrl().toString())) {
                    log.warn((Object)String.format("Payonline - redirectUrl overrided by rules, paymendId [%s]", result.getPayment().getPaymentId()));
                    return pgParameters.getPgRedirectUrl().toString();
                }
                return baseUrl + HandlerInitiatePayment.getLanguage(result) + "/payment/";
            }
            case WEBMONEY_PAYONLINE: {
                return baseUrl + "ru/payment/select/webmoney/";
            }
            case QIWI_PAYONLINE: {
                return baseUrl + "ru/payment/select/qiwi/";
            }
        }
        return baseUrl + "ru/payment/select/";
    }

    private static BigDecimal getCommisionAmount(BookingFile bookingFile, BigDecimal orderPrice, PayonlineConfiguration config) throws PGException {
        BigDecimal totalPrice = config.isTestMode() ? config.getTestCommission() : SplitPaymentHelper.getSplitPaymentCommisionPartAmount((BookingFile)bookingFile, (BigDecimal)orderPrice);
        return totalPrice;
    }

    private static BigDecimal getAmount(Payment payment, PayonlineConfiguration configuration) {
        BigDecimal totalPrice = configuration.isTestMode() ? configuration.getTestAmount() : payment.getAmount();
        return totalPrice;
    }

    private static String getLanguage(PaymentInitiationResult result) {
        if (result.getPayment().getCustomerInfo() == null) {
            return "ru";
        }
        if (result.getPayment().getCustomerInfo().getPreferredLocale() == null) {
            return "ru";
        }
        Locale prefLocale = result.getPayment().getCustomerInfo().getPreferredLocale();
        if (prefLocale.getLanguage().equals(new Locale("en", "", "").getLanguage())) {
            return "en";
        }
        return "ru";
    }
}

