/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.payonline;

import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.util.BinHex;
import com.gridnine.xtrip.server.pg.PGException;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.payonline.PayonlinePGConnector;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class HandlerRollbackTransaction {
    protected static final Logger log = LoggerFactory.getLogger(HandlerRollbackTransaction.class);
    private static final String OPERATION_ERROR_RESULT = "Error";

    public static void process(PGParameters params, Payment payment, List<Message> messages, PayonlinePGConnector connector, String bookingNumber) {
        String transactionStatus = NamedValueHelper.getValueForName((String)"transaction.status", (Collection)payment.getCustomParameters());
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        try {
            parameters.put("MerchantId", params.getPgAccount());
            parameters.put("TransactionId", NamedValueHelper.getValueForName((String)"transaction.id", (Collection)payment.getCustomParameters()));
            parameters.put("SecurityKey", HandlerRollbackTransaction.generateSign(params.getPgAccount(), NamedValueHelper.getValueForName((String)"transaction.id", (Collection)payment.getCustomParameters()), params.getPgPassword()));
            parameters.put("ContentType", "xml");
            if (log.isWarnEnabled()) {
                log.warn(String.format("BookingFile [%s], wanna to void the payment, parameters [%s]", bookingNumber, parameters));
            }
            if (!"pending".equalsIgnoreCase(transactionStatus) && !"PreAuthorized.".equalsIgnoreCase(transactionStatus)) {
                throw new PGException("Incorrect transaction status");
            }
            Element response = connector.execute(InvocationName.PAYMENT_REFUND, parameters, connector.getConnectorConfiguration().getVoidUrl());
            if (!"transaction".equalsIgnoreCase(response.getNodeName())) {
                throw new PGException("invalid xml response : root element must be 'transaction'");
            }
            Element childEl = (Element)response.getElementsByTagName("result").item(0);
            String result = childEl.getTextContent();
            if (OPERATION_ERROR_RESULT.equals(result)) {
                throw new PGException("Incorrect rollback response");
            }
        }
        catch (Exception e) {
            PGInvocationContext.get().addTraceData(new Date(), InvocationName.PAYMENT_REFUND.toString(), parameters, null, (Throwable)e);
            log.error("", (Throwable)e);
        }
    }

    private static String generateSign(String merchantId, String transactionId, String privateSecurityKey) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("MerchantId");
        sb.append("=");
        sb.append(merchantId);
        sb.append("&");
        sb.append("TransactionId");
        sb.append("=");
        sb.append(transactionId);
        sb.append("&");
        sb.append("PrivateSecurityKey");
        sb.append("=");
        sb.append(privateSecurityKey);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] b = sb.toString().getBytes();
        md5.update(b);
        return BinHex.encode((byte[])md5.digest()).toLowerCase();
    }
}

