/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.payonline;

import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PayonlineConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PayonlineConfiguration.class);
    private final boolean traceEnabled;
    private final String redirectUrl;
    private final Long queuePeriod;
    private final String serviceUrl;
    private final String voidUrl;
    private final BigDecimal testCommission;
    private final BigDecimal testAmount;
    private final boolean testMode;

    private static boolean isTrue(String propertyValue) {
        return Boolean.toString(true).equalsIgnoreCase(propertyValue);
    }

    PayonlineConfiguration(Properties data) {
        this.traceEnabled = PayonlineConfiguration.isTrue(data.getProperty("trace.enabled"));
        this.redirectUrl = data.getProperty("redirect.base.url");
        this.queuePeriod = data.contains("queue.period") ? Long.valueOf(data.getProperty("queue.period")) : null;
        this.serviceUrl = data.getProperty("service.url");
        this.voidUrl = data.getProperty("void.url");
        this.testAmount = this.getBigDecimalValue(data.getProperty("test.amount"), BigDecimal.TEN);
        this.testCommission = this.getBigDecimalValue(data.getProperty("test.commision"), BigDecimal.ONE);
        this.testMode = PayonlineConfiguration.isTrue(data.getProperty("test.enabled"));
    }

    private BigDecimal getBigDecimalValue(String value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            double parseDouble = Double.parseDouble(value);
            return new BigDecimal(parseDouble);
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
            return defaultValue;
        }
    }

    public Long getQueuePeriod() {
        return this.queuePeriod;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public BigDecimal getTestAmount() {
        return this.testAmount;
    }

    public BigDecimal getTestCommission() {
        return this.testCommission;
    }

    public String getVoidUrl() {
        return this.voidUrl;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    boolean isValid() {
        return !TextUtil.isBlank((String)this.redirectUrl);
    }
}

