/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.pg.payonline;

import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.pg.InvocationName;
import com.gridnine.xtrip.common.pg.model.PGParameters;
import com.gridnine.xtrip.common.pg.model.Payment;
import com.gridnine.xtrip.common.pg.model.PaymentCheckParameters;
import com.gridnine.xtrip.common.pg.model.PaymentStatus;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.pg.PGConnector;
import com.gridnine.xtrip.server.pg.PGHelper;
import com.gridnine.xtrip.server.pg.PGInvocationContext;
import com.gridnine.xtrip.server.pg.PGRulesHelper;
import com.gridnine.xtrip.server.pg.PGServlet;
import com.gridnine.xtrip.server.pg.PGServletResponse;
import com.gridnine.xtrip.server.pg.PaymentHelper;
import com.gridnine.xtrip.server.pg.payonline.HandlerRollbackTransaction;
import com.gridnine.xtrip.server.pg.payonline.PayonlinePGConnector;
import com.gridnine.xtrip.server.pg.split.PgSabreSessionManager;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayonlinePGServlet
extends PGServlet {
    private static final long serialVersionUID = 7922731345526412986L;
    private static final Logger log = LoggerFactory.getLogger(PayonlinePGServlet.class);

    protected PgName getId() {
        return PgName.PAYONLINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        log.debug("service() BEGIN");
        PayonlinePGConnector connector = (PayonlinePGConnector)this.getConnector();
        PGInvocationContext.get().begin(InvocationName.SERVLET_SERVICE.toString());
        Date startDate = new Date();
        Map request = PGHelper.convertRequestParametersMap((Map)httpRequest.getParameterMap());
        PGServletResponse response = new PGServletResponse(httpResponse);
        LinkedList<Message> messages = new LinkedList<Message>();
        LinkedList pgLog = new LinkedList();
        String paymentId = null;
        Payment payment = null;
        try {
            paymentId = httpRequest.getParameter("OrderId");
            if (TextUtil.isBlank((String)paymentId)) {
                throw new Exception("missing parameter 'OrderId'");
            }
            try (NamedLock lock = this.getLock(paymentId);){
                if (!lock.tryLock()) {
                    response.setResponseCode(500);
                    log.error("Could not get lock, already processing this payment:" + paymentId);
                    return;
                }
                try {
                    LogicalStorage.get().authorizeAsSystem();
                    PGInvocationContext.get().setPaymentId(paymentId);
                    payment = this.getFromQueue(paymentId);
                    if (payment == null) {
                        log.warn("Payment " + paymentId + " isn't found");
                        response.setResponseCode(200);
                        return;
                    }
                    EntityContainer bookingFileContainer = PaymentHelper.getBookingFileContainer((Payment)payment);
                    Message auditMessage = MessageHelper.createMessage((String)"service ", (Object[])new Object[0]);
                    PGConnector.auditMessage((EntityReference)payment.getEntity(), (Message)auditMessage, (String)"payonline-pgconnector");
                    PgSabreSessionManager.releaseSession((EntityContainer)bookingFileContainer);
                    SalesContext salesContext = PaymentHelper.restoreSalesContext((Payment)payment);
                    PaymentCheckParameters checkParams = new PaymentCheckParameters();
                    checkParams.setPayment(payment);
                    checkParams.setPg(connector.getId());
                    checkParams.setSalesContext(salesContext);
                    checkParams.getCustomParameters().add(NamedValueHelper.namedValue((String)"separate.log.invocation", (String)Boolean.FALSE.toString()));
                    connector.checkPayment(checkParams);
                    if (payment.getStatus() == PaymentStatus.ERROR) {
                        EntityContainer bookingFile = EntityStorage.get().resolve(payment.getEntity());
                        boolean hasSoldProducts = PaymentHelper.hasSoldProducts((BookingFile)((BookingFile)bookingFile.getEntity()));
                        String bookingNumber = TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFile.getEntity()));
                        if (log.isWarnEnabled()) {
                            log.warn(String.format("Booking [%s], hasSoldProducts [%b]", bookingNumber, hasSoldProducts));
                        }
                        if (!hasSoldProducts) {
                            PGParameters pgParameters = PGRulesHelper.getPGParameters((SalesContext)salesContext, (PgName)connector.getId(), (Payment)payment);
                            HandlerRollbackTransaction.process(pgParameters, payment, messages, connector, bookingNumber);
                            Message auditMessage2 = MessageHelper.createMessage((String)"rollback ", (Object[])new Object[0]);
                            PGConnector.auditMessage((EntityReference)payment.getEntity(), (Message)auditMessage2, (String)"payonline-pgconnector");
                        }
                    }
                    PGInvocationContext.get().addTraceData(startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, null);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        catch (Throwable t) {
            log.error("service failed", t);
            response.setResponseCode(500);
            response.setResponseText(t.getMessage());
            PGInvocationContext.get().addTraceData(0, startDate, InvocationName.SERVLET_SERVICE.toString(), (Object)request, (Object)response, t);
        }
        finally {
            PGInvocationContext.get().end((PGConnector)connector, pgLog);
            if (payment != null) {
                PGInvocationContext.get().saveDocs(pgLog, messages, payment.getPayee());
            }
            response.send();
            LogicalStorage.reset();
        }
        log.debug("service() END");
    }
}

