/*
 * Decompiled with CFR 0.152.
 */
package ru.atol.drivers10.fptr;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import ru.atol.drivers10.fptr.WindowsRegistry;

public class FptrNative {
    private static String[] getEnvPaths(String name) {
        String p = System.getenv(name);
        if (p == null) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(p.split(File.pathSeparator)));
        list.removeAll(Arrays.asList("", null));
        return list.toArray(new String[0]);
    }

    private static void raiseNotFoundError(String path) {
        if (path.isEmpty()) {
            throw new UnsatisfiedLinkError("Driver library not found in search folders");
        }
        throw new UnsatisfiedLinkError(String.format("Can`t load driver library from \"%s\"", path));
    }

    private static void loadFromPath(String path) {
        try {
            File f = new File(path);
            if (System.getProperty("os.name").contains("Windows")) {
                if (f.isDirectory()) {
                    path = path + "\\fptr10.dll";
                }
                try {
                    Runtime.getRuntime().load(path);
                }
                catch (UnsatisfiedLinkError ignored) {
                    Runtime.getRuntime().load(path + new File(path).getParent() + "\\msvcp140.dll");
                    Runtime.getRuntime().load(path);
                }
            } else if (System.getProperty("os.name").contains("OS X")) {
                try {
                    if (f.isDirectory()) {
                        path = path + "/fptr10.framework/fptr10";
                    }
                    System.load(path);
                }
                catch (UnsatisfiedLinkError ignored) {
                    if (f.isDirectory()) {
                        path = path + "/libfptr10.dylib";
                    }
                    System.load(path);
                }
            } else {
                if (f.isDirectory()) {
                    path = path + "/libfptr10.so";
                }
                System.load(path);
            }
        }
        catch (UnsatisfiedLinkError ignored) {
            FptrNative.raiseNotFoundError(path);
        }
    }

    public native String version();

    public native int logWrite(long var1, String var3, int var4, String var5);

    public native int showProperties(long var1, int var3, long var4);

    public native long create();

    public native long createWithID(String var1);

    public native void destroy(long var1);

    public native boolean isOpened(long var1);

    public native int setSettings(long var1, String var3);

    public native String getSettings(long var1);

    public native void setSingleSetting(long var1, String var3, String var4);

    public native String getSingleSetting(long var1, String var3);

    public native int errorCode(long var1);

    public native String errorDescription(long var1);

    public native void resetError(long var1);

    public native void setParamBool(long var1, int var3, boolean var4);

    public native void setParamIntI(long var1, int var3, int var4);

    public native void setParamInt(long var1, int var3, long var4);

    public native void setParamDouble(long var1, int var3, double var4);

    public native void setParamString(long var1, int var3, String var4);

    public native void setParamDateTime(long var1, int var3, Date var4);

    public native void setParamByteArray(long var1, int var3, byte[] var4);

    public native void setNonPrintableParamBool(long var1, int var3, boolean var4);

    public native void setNonPrintableParamInt(long var1, int var3, long var4);

    public native void setNonPrintableParamIntI(long var1, int var3, int var4);

    public native void setNonPrintableParamDouble(long var1, int var3, double var4);

    public native void setNonPrintableParamString(long var1, int var3, String var4);

    public native void setNonPrintableParamDateTime(long var1, int var3, Date var4);

    public native void setNonPrintableParamByteArray(long var1, int var3, byte[] var4);

    public native void setUserParamBool(long var1, int var3, boolean var4);

    public native void setUserParamInt(long var1, int var3, long var4);

    public native void setUserParamIntI(long var1, int var3, int var4);

    public native void setUserParamDouble(long var1, int var3, double var4);

    public native void setUserParamString(long var1, int var3, String var4);

    public native void setUserParamDateTime(long var1, int var3, Date var4);

    public native void setUserParamByteArray(long var1, int var3, byte[] var4);

    public native boolean getParamBool(long var1, int var3);

    public native long getParamInt(long var1, int var3);

    public native double getParamDouble(long var1, int var3);

    public native String getParamString(long var1, int var3);

    public native Date getParamDateTime(long var1, int var3);

    public native byte[] getParamByteArray(long var1, int var3);

    public native int applySingleSettings(long var1);

    public native int open(long var1);

    public native int close(long var1);

    public native int resetParams(long var1);

    public native int runCommand(long var1);

    public native int beep(long var1);

    public native int openDrawer(long var1);

    public native int cut(long var1);

    public native int devicePoweroff(long var1);

    public native int deviceReboot(long var1);

    public native int openShift(long var1);

    public native int resetSummary(long var1);

    public native int initDevice(long var1);

    public native int queryData(long var1);

    public native int cashIncome(long var1);

    public native int cashOutcome(long var1);

    public native int openReceipt(long var1);

    public native int cancelReceipt(long var1);

    public native int closeReceipt(long var1);

    public native int checkDocumentClosed(long var1);

    public native int receiptTotal(long var1);

    public native int receiptTax(long var1);

    public native int registration(long var1);

    public native int payment(long var1);

    public native int report(long var1);

    public native int printText(long var1);

    public native int printCliche(long var1);

    public native int beginNonfiscalDocument(long var1);

    public native int endNonfiscalDocument(long var1);

    public native int printBarcode(long var1);

    public native int printPicture(long var1);

    public native int printPictureByNumber(long var1);

    public native int uploadPictureFromFile(long var1);

    public native int clearPictures(long var1);

    public native int writeDeviceSettingRaw(long var1);

    public native int readDeviceSettingRaw(long var1);

    public native int commitSettings(long var1);

    public native int initSettings(long var1);

    public native int resetSettings(long var1);

    public native int writeDateTime(long var1);

    public native int writeLicense(long var1);

    public native int fnOperation(long var1);

    public native int fnQueryData(long var1);

    public native int fnWriteAttributes(long var1);

    public native int externalDevicePowerOn(long var1);

    public native int externalDevicePowerOff(long var1);

    public native int externalDeviceWriteData(long var1);

    public native int externalDeviceReadData(long var1);

    public native int operatorLogin(long var1);

    public native int processJson(long var1);

    public native int readDeviceSetting(long var1);

    public native int writeDeviceSetting(long var1);

    public native int beginReadRecords(long var1);

    public native int readNextRecord(long var1);

    public native int endReadRecords(long var1);

    public native int userMemoryOperation(long var1);

    public native int continuePrint(long var1);

    public native int initMgm(long var1);

    public native int utilFormTlv(long var1);

    public native int utilFormNomenclature(long var1);

    public native int utilMapping(long var1);

    public native int readModelFlags(long var1);

    public native int lineFeed(long var1);

    public native int flashFirmware(long var1);

    public native int softLockInit(long var1);

    public native int softLockQuerySessionCode(long var1);

    public native int softLockValidate(long var1);

    public native int utilCalcTax(long var1);

    public native int downloadPicture(long var1);

    public native int bluetoothRemovePairedDevices(long var1);

    public native int utilTagInfo(long var1);

    public native int utilContainerVersions(long var1);

    public native int activateLicenses(long var1);

    public native int removeLicenses(long var1);

    public native int enterKeys(long var1);

    public native int validateKeys(long var1);

    public native int enterSerialNumber(long var1);

    public native int getSerialNumberRequest(long var1);

    public native int uploadPixelBuffer(long var1);

    public native int downloadPixelBuffer(long var1);

    public native int printPixelBuffer(long var1);

    public native int utilConvertTagValue(long var1);

    public native int parseMarkingCode(long var1);

    public native int callScript(long var1);

    public native int setHeaderLines(long var1);

    public native int setFooterLines(long var1);

    public native int uploadPictureCliche(long var1);

    public native int uploadPictureMemory(long var1);

    public native int uploadPixelBufferCliche(long var1);

    public native int uploadPixelBufferMemory(long var1);

    public native int execDriverScript(long var1);

    public native int uploadDriverScript(long var1);

    public native int execDriverScriptById(long var1);

    public native int writeUniversalCountersSettings(long var1);

    public native int readUniversalCountersSettings(long var1);

    public native int queryUniversalCountersState(long var1);

    public native int resetUniversalCounters(long var1);

    public native int cacheUniversalCounters(long var1);

    public native int readUniversalCounterSum(long var1);

    public native int readUniversalCounterQuantity(long var1);

    public native int clearUniversalCountersCache(long var1);

    public native int disableOfdChannel(long var1);

    public native int enableOfdChannel(long var1);

    public native int validateJson(long var1);

    public native int reflectionCall(long var1);

    public native int getRemoteServerInfo(long var1);

    static {
        String libraryPath = System.getProperty("dto10.library.path");
        if (System.getProperty("os.name").contains("Windows")) {
            if (libraryPath.isEmpty()) {
                try {
                    System.loadLibrary("fptr10");
                }
                catch (UnsatisfiedLinkError ignored) {
                    String path = WindowsRegistry.readRegistry("HKLM\\Software\\ATOL\\Drivers\\10.0\\KKT", "INSTALL_DIR");
                    if (path.isEmpty()) {
                        throw new UnsatisfiedLinkError("Driver not installed");
                    }
                    FptrNative.loadFromPath(path + "\\bin\\fptr10.dll");
                }
            } else {
                FptrNative.loadFromPath(libraryPath);
            }
        } else if (System.getProperty("os.name").contains("OS X")) {
            if (libraryPath.isEmpty()) {
                UnsatisfiedLinkError ex = null;
                ArrayList<String> loadPaths = new ArrayList<String>();
                loadPaths.addAll(Arrays.asList(FptrNative.getEnvPaths("DYLD_FRAMEWORK_PATH")));
                loadPaths.addAll(Arrays.asList(FptrNative.getEnvPaths("DYLD_FALLBACK_FRAMEWORK_PATH")));
                if (loadPaths.isEmpty()) {
                    loadPaths = new ArrayList<String>(Arrays.asList(System.getenv("HOME") + "/Library/Frameworks", "/Library/Frameworks", "/Network/Library/Frameworks", "/System/Library/Frameworks"));
                }
                for (String path : loadPaths) {
                    try {
                        FptrNative.loadFromPath(path);
                        ex = null;
                        break;
                    }
                    catch (UnsatisfiedLinkError e1) {
                        ex = e1;
                    }
                }
                try {
                    if (ex != null) {
                        System.loadLibrary("fptr10");
                    }
                }
                catch (UnsatisfiedLinkError ignored) {
                    FptrNative.raiseNotFoundError(libraryPath);
                }
            } else {
                FptrNative.loadFromPath(libraryPath);
            }
        } else if (libraryPath.isEmpty()) {
            System.loadLibrary("fptr10");
        } else {
            FptrNative.loadFromPath(libraryPath);
        }
    }
}

