/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.LambdaForm;
import java.util.ArrayList;
import java.util.Arrays;

final class LambdaFormBuffer {
    private int arity;
    private int length;
    private LambdaForm.Name[] names;
    private LambdaForm.Name[] originalNames;
    private byte flags;
    private int firstChange;
    private LambdaForm.Name resultName;
    private String debugName;
    private ArrayList<LambdaForm.Name> dups;
    private static final int F_TRANS = 16;
    private static final int F_OWNED = 3;

    LambdaFormBuffer(LambdaForm lambdaForm) {
        this.arity = lambdaForm.arity;
        this.setNames(lambdaForm.names);
        int n = lambdaForm.result;
        if (n == -2) {
            n = this.length - 1;
        }
        if (n >= 0 && lambdaForm.names[n].type != LambdaForm.BasicType.V_TYPE) {
            this.resultName = lambdaForm.names[n];
        }
        this.debugName = lambdaForm.debugName;
        assert (lambdaForm.nameRefsAreLegal());
    }

    private LambdaForm lambdaForm() {
        assert (!this.inTrans());
        return new LambdaForm(this.debugName, this.arity, this.nameArray(), this.resultIndex());
    }

    LambdaForm.Name name(int n) {
        assert (n < this.length);
        return this.names[n];
    }

    LambdaForm.Name[] nameArray() {
        return Arrays.copyOf(this.names, this.length);
    }

    int resultIndex() {
        if (this.resultName == null) {
            return -1;
        }
        int n = LambdaFormBuffer.indexOf(this.resultName, this.names);
        assert (n >= 0);
        return n;
    }

    void setNames(LambdaForm.Name[] nameArray) {
        this.originalNames = nameArray;
        this.names = nameArray;
        this.length = nameArray.length;
        this.flags = 0;
    }

    private boolean verifyArity() {
        int n;
        for (n = 0; n < this.arity && n < this.firstChange; ++n) {
            assert (this.names[n].isParam()) : "#" + n + "=" + this.names[n];
        }
        for (n = this.arity; n < this.length; ++n) {
            assert (!this.names[n].isParam()) : "#" + n + "=" + this.names[n];
        }
        for (n = this.length; n < this.names.length; ++n) {
            assert (this.names[n] == null) : "#" + n + "=" + this.names[n];
        }
        if (this.resultName != null) {
            n = LambdaFormBuffer.indexOf(this.resultName, this.names);
            assert (n >= 0) : "not found: " + this.resultName.exprString() + Arrays.asList(this.names);
            assert (this.names[n] == this.resultName);
        }
        return true;
    }

    private boolean verifyFirstChange() {
        assert (this.inTrans());
        for (int i = 0; i < this.length; ++i) {
            if (this.names[i] == this.originalNames[i]) continue;
            assert (this.firstChange == i) : Arrays.asList(this.firstChange, i, this.originalNames[i].exprString(), Arrays.asList(this.names));
            return true;
        }
        assert (this.firstChange == this.length) : Arrays.asList(this.firstChange, Arrays.asList(this.names));
        return true;
    }

    private static int indexOf(LambdaForm.NamedFunction namedFunction, LambdaForm.NamedFunction[] namedFunctionArray) {
        for (int i = 0; i < namedFunctionArray.length; ++i) {
            if (namedFunctionArray[i] != namedFunction) continue;
            return i;
        }
        return -1;
    }

    private static int indexOf(LambdaForm.Name name, LambdaForm.Name[] nameArray) {
        for (int i = 0; i < nameArray.length; ++i) {
            if (nameArray[i] != name) continue;
            return i;
        }
        return -1;
    }

    boolean inTrans() {
        return (this.flags & 0x10) != 0;
    }

    int ownedCount() {
        return this.flags & 3;
    }

    void growNames(int n, int n2) {
        int n3 = this.length;
        int n4 = n3 + n2;
        int n5 = this.ownedCount();
        if (n5 == 0 || n4 > this.names.length) {
            this.names = Arrays.copyOf(this.names, (this.names.length + n2) * 5 / 4);
            if (n5 == 0) {
                this.flags = (byte)(this.flags + 1);
                assert (this.ownedCount() == ++n5);
            }
        }
        if (this.originalNames != null && this.originalNames.length < this.names.length) {
            this.originalNames = Arrays.copyOf(this.originalNames, this.names.length);
            if (n5 == 1) {
                this.flags = (byte)(this.flags + 1);
                assert (this.ownedCount() == ++n5);
            }
        }
        if (n2 == 0) {
            return;
        }
        int n6 = n + n2;
        int n7 = n3 - n;
        System.arraycopy(this.names, n, this.names, n6, n7);
        Arrays.fill(this.names, n, n6, null);
        if (this.originalNames != null) {
            System.arraycopy(this.originalNames, n, this.originalNames, n6, n7);
            Arrays.fill(this.originalNames, n, n6, null);
        }
        this.length = n4;
        if (this.firstChange >= n) {
            this.firstChange += n2;
        }
    }

    int lastIndexOf(LambdaForm.Name name) {
        int n = -1;
        for (int i = 0; i < this.length; ++i) {
            if (this.names[i] != name) continue;
            n = i;
        }
        return n;
    }

    private void noteDuplicate(int n, int n2) {
        LambdaForm.Name name = this.names[n];
        assert (name == this.names[n2]);
        assert (this.originalNames[n] != null);
        assert (this.originalNames[n2] == null || this.originalNames[n2] == name);
        if (this.dups == null) {
            this.dups = new ArrayList();
        }
        this.dups.add(name);
    }

    private void clearDuplicatesAndNulls() {
        if (this.dups != null) {
            assert (this.ownedCount() >= 1);
            block0: for (LambdaForm.Name name : this.dups) {
                for (int i = this.firstChange; i < this.length; ++i) {
                    if (this.names[i] != name || this.originalNames[i] == name) continue;
                    this.names[i] = null;
                    assert (Arrays.asList(this.names).contains(name));
                    continue block0;
                }
            }
            this.dups.clear();
        }
        int n = this.length;
        for (int i = this.firstChange; i < this.length; ++i) {
            if (this.names[i] != null) continue;
            System.arraycopy(this.names, i + 1, this.names, i, --this.length - i);
            --i;
        }
        if (this.length < n) {
            Arrays.fill(this.names, this.length, n, null);
        }
        assert (!Arrays.asList(this.names).subList(0, this.length).contains(null));
    }

    void startEdit() {
        LambdaForm.Name[] nameArray;
        assert (this.verifyArity());
        int n = this.ownedCount();
        assert (!this.inTrans());
        this.flags = (byte)(this.flags | 0x10);
        LambdaForm.Name[] nameArray2 = this.names;
        LambdaForm.Name[] nameArray3 = nameArray = n == 2 ? this.originalNames : null;
        assert (nameArray != nameArray2);
        if (nameArray != null && nameArray.length >= this.length) {
            this.names = this.copyNamesInto(nameArray);
        } else {
            this.names = Arrays.copyOf(nameArray2, Math.max(this.length + 2, nameArray2.length));
            if (n < 2) {
                this.flags = (byte)(this.flags + 1);
            }
            assert (this.ownedCount() == n + 1);
        }
        this.originalNames = nameArray2;
        assert (this.originalNames != this.names);
        this.firstChange = this.length;
        assert (this.inTrans());
    }

    private void changeName(int n, LambdaForm.Name name) {
        assert (this.inTrans());
        assert (n < this.length);
        LambdaForm.Name name2 = this.names[n];
        assert (name2 == this.originalNames[n]);
        assert (this.verifyFirstChange());
        if (this.ownedCount() == 0) {
            this.growNames(0, 0);
        }
        this.names[n] = name;
        if (this.firstChange > n) {
            this.firstChange = n;
        }
        if (this.resultName != null && this.resultName == name2) {
            this.resultName = name;
        }
    }

    void setResult(LambdaForm.Name name) {
        assert (name == null || this.lastIndexOf(name) >= 0);
        this.resultName = name;
    }

    LambdaForm endEdit() {
        assert (this.verifyFirstChange());
        for (int i = Math.max(this.firstChange, this.arity); i < this.length; ++i) {
            LambdaForm.Name name;
            LambdaForm.Name name2 = this.names[i];
            if (name2 == null || (name = name2.replaceNames(this.originalNames, this.names, this.firstChange, i)) == name2) continue;
            this.names[i] = name;
            if (this.resultName != name2) continue;
            this.resultName = name;
        }
        assert (this.inTrans());
        this.flags = (byte)(this.flags & 0xFFFFFFEF);
        this.clearDuplicatesAndNulls();
        this.originalNames = null;
        if (this.firstChange < this.arity) {
            LambdaForm.Name[] nameArray = new LambdaForm.Name[this.arity - this.firstChange];
            int n = this.firstChange;
            int n2 = 0;
            for (int i = this.firstChange; i < this.arity; ++i) {
                LambdaForm.Name name = this.names[i];
                if (name.isParam()) {
                    this.names[n++] = name;
                    continue;
                }
                nameArray[n2++] = name;
            }
            assert (n2 == this.arity - n);
            System.arraycopy(nameArray, 0, this.names, n, n2);
            this.arity -= n2;
        }
        assert (this.verifyArity());
        return this.lambdaForm();
    }

    private LambdaForm.Name[] copyNamesInto(LambdaForm.Name[] nameArray) {
        System.arraycopy(this.names, 0, nameArray, 0, this.length);
        Arrays.fill(nameArray, this.length, nameArray.length, null);
        return nameArray;
    }

    LambdaFormBuffer replaceFunctions(LambdaForm.NamedFunction[] namedFunctionArray, LambdaForm.NamedFunction[] namedFunctionArray2, Object ... objectArray) {
        assert (this.inTrans());
        if (namedFunctionArray.length == 0) {
            return this;
        }
        for (int i = this.arity; i < this.length; ++i) {
            LambdaForm.Name name = this.names[i];
            int n = LambdaFormBuffer.indexOf(name.function, namedFunctionArray);
            if (n < 0 || !Arrays.equals(name.arguments, objectArray)) continue;
            this.changeName(i, new LambdaForm.Name(namedFunctionArray2[n], name.arguments));
        }
        return this;
    }

    private void replaceName(int n, LambdaForm.Name name) {
        assert (this.inTrans());
        assert (this.verifyArity());
        assert (n < this.arity);
        LambdaForm.Name name2 = this.names[n];
        assert (name2.isParam());
        assert (name2.type == name.type);
        this.changeName(n, name);
    }

    LambdaFormBuffer renameParameter(int n, LambdaForm.Name name) {
        assert (name.isParam());
        this.replaceName(n, name);
        return this;
    }

    LambdaFormBuffer replaceParameterByNewExpression(int n, LambdaForm.Name name) {
        assert (!name.isParam());
        assert (this.lastIndexOf(name) < 0);
        this.replaceName(n, name);
        return this;
    }

    LambdaFormBuffer replaceParameterByCopy(int n, int n2) {
        assert (n != n2);
        this.replaceName(n, this.names[n2]);
        this.noteDuplicate(n, n2);
        return this;
    }

    private void insertName(int n, LambdaForm.Name name, boolean bl) {
        assert (this.inTrans());
        assert (this.verifyArity());
        assert (!bl ? n >= this.arity : n <= this.arity);
        this.growNames(n, 1);
        if (bl) {
            ++this.arity;
        }
        this.changeName(n, name);
    }

    LambdaFormBuffer insertExpression(int n, LambdaForm.Name name) {
        assert (!name.isParam());
        this.insertName(n, name, false);
        return this;
    }

    LambdaFormBuffer insertParameter(int n, LambdaForm.Name name) {
        assert (name.isParam());
        this.insertName(n, name, true);
        return this;
    }
}

