/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt;

import com.sun.applet2.Applet2Host;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BadCertificateDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.security.CodeSource;
import java.security.cert.CertificateException;
import javax.swing.JPanel;
import sun.plugin.JavaRunTime;

public class AWTErrorPanel
extends JPanel
implements MouseListener,
ActionListener {
    private Image errorImage = null;
    private static final String ERROR_IMAGE_FILE = "com/sun/deploy/uitoolkit/impl/awt/graybox_error.png";
    private static final String BLOCKED_IMAGE_FILE = "com/sun/deploy/resources/image/cert_error16.png";
    private static final Color ERROR_BORDER = new Color(204, 204, 204);
    private Color bg_color;
    private Color fg_color;
    private PopupMenu popup;
    private MenuItem open_console;
    private MenuItem about_java;
    private MenuItem reload;
    private boolean offerReload = false;
    private Applet2Host host = null;
    private String title = null;
    private String message = null;
    private Throwable throwable;

    public AWTErrorPanel(Color color, Color color2, Applet2Host applet2Host, boolean bl) {
        this.host = applet2Host;
        this.setBackground(color);
        this.bg_color = color;
        this.fg_color = color2;
        this.setToolTipText(ResourceManager.getMessage((String)"applet.error.message"));
        this.addMouseListener(this);
        this.offerReload = bl;
        if (bl) {
            TrustDecider.resetDenyStore();
        }
    }

    public void setMessage(String string, String string2) {
        this.title = string;
        this.message = string2;
    }

    private String getMasthead() {
        return this.title == null || this.title.length() == 0 ? ResourceManager.getMessage((String)"applet.error.generic.masthead") : this.title;
    }

    private String getMessage() {
        return this.message == null || this.message.length() == 0 ? ResourceManager.getMessage((String)"applet.error.generic.body") : this.message;
    }

    private synchronized Image getErrorImage() {
        if (this.errorImage == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.errorImage = this.isBlocedCertificateException() ? toolkit.createImage(ClassLoader.getSystemResource(BLOCKED_IMAGE_FILE)) : toolkit.createImage(ClassLoader.getSystemResource(ERROR_IMAGE_FILE));
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.errorImage, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.errorImage;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.drawBorder(graphics2D, this.getSize());
        if (this.getWidth() > 24 && this.getHeight() > 24) {
            int n = 4;
            int n2 = 5;
            graphics2D.drawImage(this.getErrorImage(), n, n2, this.bg_color, null);
            this.drawMessage(graphics2D, this.getAppletPaneMessage(), this.getErrorImage().getWidth(null) + n + 7, this.getErrorImage().getHeight(null) + n2 - 4);
        }
        graphics2D.dispose();
    }

    private String getAppletPaneMessage() {
        if (this.isBlocedCertificateException()) {
            String string = ResourceManager.getMessage((String)"applet.error.blocked.message");
            this.setToolTipText(string);
            return string;
        }
        return ResourceManager.getMessage((String)"applet.error.message");
    }

    private void drawBorder(Graphics graphics, Dimension dimension) {
        Color color = ERROR_BORDER;
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.setColor(color2);
    }

    private void drawMessage(Graphics2D graphics2D, String string, int n, int n2) {
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        boolean bl = true;
        if (rectangle2D.getWidth() + (double)n > dimension.getWidth()) {
            int n3;
            bl = false;
            while (!bl && (n3 = string.lastIndexOf(" ")) != -1) {
                string = string.substring(0, n3);
                rectangle2D = fontMetrics.getStringBounds(string = string + "...", graphics2D);
                if (!(rectangle2D.getWidth() + (double)n < dimension.getWidth())) continue;
                bl = true;
            }
            if (!bl && (rectangle2D = fontMetrics.getStringBounds(string = "...", graphics2D)).getWidth() + (double)n < dimension.getWidth()) {
                bl = true;
            }
        }
        if (bl) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.fg_color);
            graphics2D.drawString(string, n, n2);
            graphics2D.setColor(color);
        }
    }

    private PopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new PopupMenu();
            this.open_console = new MenuItem(ResourceManager.getMessage((String)"dialogfactory.menu.open_console"));
            this.popup.add(this.open_console);
            this.popup.add("-");
            this.about_java = new MenuItem(ResourceManager.getMessage((String)"dialogfactory.menu.about_java"));
            this.popup.add(this.about_java);
            if (this.offerReload) {
                this.reload = new MenuItem("Reload applet");
                this.popup.add("-");
                this.popup.add(this.reload);
                this.reload.addActionListener(this);
            }
            this.open_console.addActionListener(this);
            this.about_java.addActionListener(this);
            this.add(this.popup);
        }
        return this.popup;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else if (mouseEvent.getButton() == 1) {
            this.onLeftMouseClick();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else if (mouseEvent.getButton() == 1) {
            this.onLeftMouseClick();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void onLeftMouseClick() {
        int n = -1;
        if (this.isBlocedCertificateException()) {
            BlockedException blockedException = (BlockedException)this.throwable;
            BadCertificateDialog.showDialog((CodeSource)blockedException.getCodeSource(), (AppInfo)blockedException.getAppInfo(), (Exception)blockedException);
        } else if (this.offerReload) {
            UIFactory uIFactory = ToolkitStore.getUI();
            AppInfo appInfo = new AppInfo();
            ToolkitStore.getUI();
            n = uIFactory.showMessageDialog(null, appInfo, 0, null, this.getMasthead(), this.getMessage(), null, "applet.error.details.btn", "applet.error.ignore.btn", "applet.error.reload.btn");
        } else {
            UIFactory uIFactory = ToolkitStore.getUI();
            AppInfo appInfo = new AppInfo();
            ToolkitStore.getUI();
            n = uIFactory.showMessageDialog(null, appInfo, 0, null, this.getMasthead(), this.getMessage(), null, "applet.error.details.btn", "applet.error.ignore.btn", null);
        }
        ToolkitStore.getUI();
        if (n == 0) {
            JavaRunTime.showJavaConsole(true);
        } else {
            ToolkitStore.getUI();
            if (n != 1) {
                ToolkitStore.getUI();
                if (n == 3) {
                    this.reloadApplet();
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.open_console) {
            JavaRunTime.showJavaConsole(true);
        } else if (actionEvent.getSource() == this.about_java) {
            ToolkitStore.getUI().showAboutJavaDialog();
        } else if (actionEvent.getSource() == this.reload) {
            this.reloadApplet();
        }
    }

    private void reloadApplet() {
        if (this.host != null) {
            MemoryCache.clearLoadedResources();
            this.host.reloadAppletPage();
        }
    }

    private boolean isBlocedCertificateException() {
        return this.throwable instanceof BlockedException && ((BlockedException)this.throwable).getCodeSource() != null && ((BlockedException)this.throwable).getCause() instanceof CertificateException;
    }

    void setThrowable(Throwable throwable) {
        this.throwable = throwable;
        this.setToolTipText(this.getAppletPaneMessage());
    }
}

