/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.internal.ResourceMethodInvocationHandlerProvider;

@Singleton
public final class ResourceMethodInvocationHandlerFactory
implements ResourceMethodInvocationHandlerProvider {
    private static final InvocationHandler DEFAULT_HANDLER = new InvocationHandler(){

        @Override
        public Object invoke(Object target, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return method.invoke(target, args);
        }
    };
    private static final Logger LOGGER = Logger.getLogger(ResourceMethodInvocationHandlerFactory.class.getName());
    private final Set<ResourceMethodInvocationHandlerProvider> providers;

    @Inject
    ResourceMethodInvocationHandlerFactory(ServiceLocator locator) {
        this.providers = Providers.getProviders((ServiceLocator)locator, ResourceMethodInvocationHandlerProvider.class);
    }

    @Override
    public InvocationHandler create(Invocable resourceMethod) {
        for (ResourceMethodInvocationHandlerProvider provider : this.providers) {
            try {
                InvocationHandler handler = provider.create(resourceMethod);
                if (handler == null) continue;
                return handler;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_PROCESSING_METHOD(resourceMethod, provider.getClass().getName()), e);
            }
        }
        return DEFAULT_HANDLER;
    }
}

