/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.kkt.booter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class Booter {
    public static void main(String[] args) throws Exception {
        Properties currentProperties;
        String propertiesPath = System.getProperty("booter.properties.path");
        if (propertiesPath == null) {
            propertiesPath = "booter" + FileSystems.getDefault().getSeparator() + "booter.properties";
        }
        if ((currentProperties = Booter.loadCurrentProperties(propertiesPath)).isEmpty()) {
            System.out.println("Properties file not found");
        }
        Properties remoteProperties = new Properties();
        String appBase = currentProperties.getProperty("appBase");
        String remotePropertiesFile = Booter.getRemotePropertiesFile(appBase + "booter.properties");
        if (remotePropertiesFile != null) {
            boolean updateSucceeded;
            try (StringReader reader = new StringReader(remotePropertiesFile);){
                remoteProperties.load(reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Map<String, String> localFiles = Booter.convertPropertiesToProjectFileList(currentProperties);
            Map<String, String> remoteFiles = Booter.convertPropertiesToProjectFileList(remoteProperties);
            boolean bl = updateSucceeded = !remoteFiles.entrySet().stream().filter(entry -> !((String)entry.getValue()).equals(localFiles.get(entry.getKey()))).anyMatch(entry -> !Booter.downloadFile(appBase, (String)entry.getKey(), (String)entry.getValue()));
            if (updateSucceeded) {
                try {
                    Files.write(new File(propertiesPath).toPath(), remotePropertiesFile.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                currentProperties = remoteProperties;
            } else if (!"true".equals(System.getProperty("continue.if.update.fails"))) {
                System.out.println("Update error. Please restart application");
                System.exit(1);
            }
        } else if (!"true".equals(System.getProperty("continue.if.update.fails"))) {
            System.out.println("Unable to load update information. Check your internet connection");
            System.exit(1);
        }
        try {
            String[] cmdLine = currentProperties.getProperty("cmdLine").split(" ");
            Process mainProcess = new ProcessBuilder(cmdLine).inheritIO().start();
            mainProcess.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties loadCurrentProperties(String propertiesPath) {
        Properties result = new Properties();
        try (FileInputStream stream = new FileInputStream(propertiesPath);){
            result.load(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRemotePropertiesFile(String address) throws Exception {
        String string;
        HttpURLConnection connection;
        block5: {
            connection = null;
            URL url = new URL(address);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            if (connection.getResponseCode() == 200) break block5;
            System.out.println("Update file not found on address " + address);
            String string2 = null;
            Booter.closeConnection(connection);
            return string2;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            String string3;
            try {
                e.printStackTrace();
                string3 = null;
            }
            catch (Throwable throwable) {
                Booter.closeConnection(connection);
                throw throwable;
            }
            Booter.closeConnection(connection);
            return string3;
        }
        Booter.closeConnection(connection);
        return string;
    }

    private static void closeConnection(HttpURLConnection connection) {
        if (connection == null) {
            return;
        }
        try {
            Booter.closeQuietly(connection.getInputStream());
            Booter.closeQuietly(connection.getErrorStream());
            Booter.closeQuietly(connection.getOutputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void closeQuietly(AutoCloseable resource) {
        if (resource == null) {
            return;
        }
        try {
            resource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Map<String, String> convertPropertiesToProjectFileList(Properties properties) {
        HashMap<String, ProjectFile> map = new HashMap<String, ProjectFile>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ProjectFile projectFile;
            String fileId;
            String key = (String)entry.getKey();
            if (key.startsWith("file") && key.endsWith("hash")) {
                fileId = key.substring(4, key.length() - 5);
                projectFile = (ProjectFile)map.get(fileId);
                if (projectFile == null) {
                    projectFile = new ProjectFile();
                    map.put(fileId, projectFile);
                }
                projectFile.hash = (String)entry.getValue();
                continue;
            }
            if (!key.startsWith("file") || !key.endsWith("path")) continue;
            fileId = key.substring(4, key.length() - 5);
            projectFile = (ProjectFile)map.get(fileId);
            if (projectFile == null) {
                projectFile = new ProjectFile();
                map.put(fileId, projectFile);
            }
            projectFile.name = (String)entry.getValue();
        }
        return map.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toMap(f -> f.name, f -> f.hash));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean downloadFile(String appBase, String path, String hash) {
        HttpURLConnection connection = null;
        try {
            System.out.print("Downloading file: " + path);
            URL url = new URL(appBase + "/" + path);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            if (connection.getResponseCode() != 200) {
                System.out.println("..Error");
                boolean bl = false;
                Booter.closeConnection(connection);
                return bl;
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DigestInputStream stream = new DigestInputStream(connection.getInputStream(), digest);
            File newFile = new File(path);
            newFile.getParentFile().mkdirs();
            Files.copy(stream, newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            String realHash = Booter.getHexString(digest.digest());
            if (realHash.equals(hash)) {
                System.out.println("..Ok");
                boolean bl = true;
                Booter.closeConnection(connection);
                return bl;
            }
            System.out.println("..Invalid hash. Expected:  " + hash + " received: " + realHash);
            boolean bl = false;
            Booter.closeConnection(connection);
            return bl;
        }
        catch (Exception e) {
            System.out.println("..Error");
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            Booter.closeConnection(connection);
        }
    }

    private static String getHexString(byte[] mdbytes) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < mdbytes.length; ++i) {
            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    private static class ProjectFile {
        String hash;
        String name;

        private ProjectFile() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectFile that = (ProjectFile)o;
            if (this.hash != null ? !this.hash.equals(that.hash) : that.hash != null) {
                return false;
            }
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        public int hashCode() {
            int result = this.hash != null ? this.hash.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }
}

