/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.MS932;
import sun.nio.cs.ext.MS932DB;
import sun.nio.cs.ext.SJIS_0213;

public class MS932_0213
extends Charset {
    public MS932_0213() {
        super("x-MS932_0213", ExtendedCharsets.aliasesFor("MS932_0213"));
    }

    public boolean contains(Charset charset) {
        return charset.name().equals("US-ASCII") || charset instanceof MS932 || charset instanceof MS932_0213;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected static class Decoder
    extends SJIS_0213.Decoder {
        MS932DB.Decoder decMS932;

        protected Decoder(Charset charset) {
            super(charset);
            this.decMS932 = new MS932DB.Decoder(charset);
        }

        protected char decodeDouble(int n, int n2) {
            char c = this.decMS932.decodeDouble(n, n2);
            if (c == '\ufffd') {
                return super.decodeDouble(n, n2);
            }
            return c;
        }
    }

    protected static class Encoder
    extends SJIS_0213.Encoder {
        MS932DB.Encoder encMS932;

        protected Encoder(Charset charset) {
            super(charset);
            this.encMS932 = new MS932DB.Encoder(charset);
        }

        protected int encodeChar(char c) {
            int n = this.encMS932.encodeDouble(c);
            if (n == 0) {
                return super.encodeChar(c);
            }
            return n;
        }
    }
}

