/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultButtonModel
implements ButtonModel,
Serializable {
    protected int stateMask = 0;
    protected String actionCommand = null;
    protected ButtonGroup group = null;
    protected int mnemonic = 0;
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean menuItem = false;
    public static final int ARMED = 1;
    public static final int SELECTED = 2;
    public static final int PRESSED = 4;
    public static final int ENABLED = 8;
    public static final int ROLLOVER = 16;

    public DefaultButtonModel() {
        this.setEnabled(true);
    }

    @Override
    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    @Override
    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public boolean isArmed() {
        return (this.stateMask & 1) != 0;
    }

    @Override
    public boolean isSelected() {
        return (this.stateMask & 2) != 0;
    }

    @Override
    public boolean isEnabled() {
        return (this.stateMask & 8) != 0;
    }

    @Override
    public boolean isPressed() {
        return (this.stateMask & 4) != 0;
    }

    @Override
    public boolean isRollover() {
        return (this.stateMask & 0x10) != 0;
    }

    @Override
    public void setArmed(boolean bl) {
        if (this.isMenuItem() && UIManager.getBoolean("MenuItem.disabledAreNavigable") ? this.isArmed() == bl : this.isArmed() == bl || !this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 1) : (this.stateMask &= 0xFFFFFFFE);
        this.fireStateChanged();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        if (bl) {
            this.stateMask |= 8;
        } else {
            this.stateMask &= 0xFFFFFFF7;
            this.stateMask &= 0xFFFFFFFE;
            this.stateMask &= 0xFFFFFFFB;
        }
        this.fireStateChanged();
    }

    @Override
    public void setSelected(boolean bl) {
        if (this.isSelected() == bl) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
        this.fireItemStateChanged(new ItemEvent(this, 701, this, bl ? 1 : 2));
        this.fireStateChanged();
    }

    @Override
    public void setPressed(boolean bl) {
        if (this.isPressed() == bl || !this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
        if (!this.isPressed() && this.isArmed()) {
            int n = 0;
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof InputEvent) {
                n = ((InputEvent)aWTEvent).getModifiers();
            } else if (aWTEvent instanceof ActionEvent) {
                n = ((ActionEvent)aWTEvent).getModifiers();
            }
            this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), n));
        }
        this.fireStateChanged();
    }

    @Override
    public void setRollover(boolean bl) {
        if (this.isRollover() == bl || !this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 0x10) : (this.stateMask &= 0xFFFFFFEF);
        this.fireStateChanged();
    }

    @Override
    public void setMnemonic(int n) {
        this.mnemonic = n;
        this.fireStateChanged();
    }

    @Override
    public int getMnemonic() {
        return this.mnemonic;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(ItemListener.class, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(ItemListener.class, itemListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ItemListener.class) continue;
            ((ItemListener)objectArray[i + 1]).itemStateChanged(itemEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public Object[] getSelectedObjects() {
        return null;
    }

    @Override
    public void setGroup(ButtonGroup buttonGroup) {
        this.group = buttonGroup;
    }

    public ButtonGroup getGroup() {
        return this.group;
    }

    boolean isMenuItem() {
        return this.menuItem;
    }

    void setMenuItem(boolean bl) {
        this.menuItem = bl;
    }
}

