/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

class SmartGridLayout
implements LayoutManager,
Serializable {
    int rows = 2;
    int columns = 2;
    int xGap = 2;
    int yGap = 2;
    int componentCount = 0;
    Component[][] layoutGrid;

    public SmartGridLayout(int n, int n2) {
        this.rows = n2;
        this.columns = n;
        this.layoutGrid = new Component[n][n2];
    }

    public void layoutContainer(Container container) {
        int n;
        this.buildLayoutGrid(container);
        int[] nArray = new int[this.rows];
        int[] nArray2 = new int[this.columns];
        for (n = 0; n < this.rows; ++n) {
            nArray[n] = this.computeRowHeight(n);
        }
        for (n = 0; n < this.columns; ++n) {
            nArray2[n] = this.computeColumnWidth(n);
        }
        Insets insets = container.getInsets();
        if (container.getComponentOrientation().isLeftToRight()) {
            int n2 = insets.left;
            for (int i = 0; i < this.columns; ++i) {
                int n3 = insets.top;
                for (int j = 0; j < this.rows; ++j) {
                    Component component = this.layoutGrid[i][j];
                    component.setBounds(n2, n3, nArray2[i], nArray[j]);
                    n3 += nArray[j] + this.yGap;
                }
                n2 += nArray2[i] + this.xGap;
            }
        } else {
            int n4 = container.getWidth() - insets.right;
            for (int i = 0; i < this.columns; ++i) {
                int n5 = insets.top;
                n4 -= nArray2[i];
                for (int j = 0; j < this.rows; ++j) {
                    Component component = this.layoutGrid[i][j];
                    component.setBounds(n4, n5, nArray2[i], nArray[j]);
                    n5 += nArray[j] + this.yGap;
                }
                n4 -= this.xGap;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        int n;
        this.buildLayoutGrid(container);
        Insets insets = container.getInsets();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.rows; ++n) {
            n2 += this.computeRowHeight(n);
        }
        for (n = 0; n < this.columns; ++n) {
            n3 += this.computeColumnWidth(n);
        }
        return new Dimension(n3 += this.xGap * (this.columns - 1) + insets.right + insets.left, n2 += this.yGap * (this.rows - 1) + insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    private void buildLayoutGrid(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            int n = 0;
            int n2 = 0;
            if (i != 0) {
                n2 = i % this.columns;
                n = (i - n2) / this.columns;
            }
            this.layoutGrid[n2][n] = componentArray[i];
        }
    }

    private int computeColumnWidth(int n) {
        int n2 = 1;
        for (int i = 0; i < this.rows; ++i) {
            int n3 = this.layoutGrid[n][i].getPreferredSize().width;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private int computeRowHeight(int n) {
        int n2 = 1;
        for (int i = 0; i < this.columns; ++i) {
            int n3 = this.layoutGrid[i][n].getPreferredSize().height;
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }
}

