/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Font;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.peer.MenuPeer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AWTAccessor;
import sun.awt.X11.XBaseMenuWindow;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuWindow;

public class XMenuPeer
extends XMenuItemPeer
implements MenuPeer {
    private static Logger log = Logger.getLogger("sun.awt.X11.XMenuPeer");
    XMenuWindow menuWindow;

    XMenuPeer(Menu menu) {
        super(menu);
    }

    void setContainer(XBaseMenuWindow xBaseMenuWindow) {
        super.setContainer(xBaseMenuWindow);
        this.menuWindow = new XMenuWindow(this);
    }

    public void dispose() {
        if (this.menuWindow != null) {
            this.menuWindow.dispose();
        }
        super.dispose();
    }

    public void setFont(Font font) {
        this.resetTextMetrics();
        XMenuWindow xMenuWindow = this.getMenuWindow();
        if (xMenuWindow != null) {
            XMenuItemPeer[] xMenuItemPeerArray = xMenuWindow.copyItems();
            int n = xMenuItemPeerArray.length;
            for (int i = 0; i < n; ++i) {
                xMenuItemPeerArray[i].setFont(font);
            }
        }
        this.repaintIfShowing();
    }

    public void addSeparator() {
        if (log.isLoggable(Level.FINER)) {
            log.finer("addSeparator is not implemented");
        }
    }

    public void addItem(MenuItem menuItem) {
        XMenuWindow xMenuWindow = this.getMenuWindow();
        if (xMenuWindow != null) {
            xMenuWindow.addItem(menuItem);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Attempt to use XMenuWindowPeer without window");
        }
    }

    public void delItem(int n) {
        XMenuWindow xMenuWindow = this.getMenuWindow();
        if (xMenuWindow != null) {
            xMenuWindow.delItem(n);
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Attempt to use XMenuWindowPeer without window");
        }
    }

    Vector getTargetItems() {
        return AWTAccessor.getMenuAccessor().getItems((Menu)this.getTarget());
    }

    boolean isSeparator() {
        return false;
    }

    String getShortcutText() {
        return null;
    }

    XMenuWindow getMenuWindow() {
        return this.menuWindow;
    }
}

