/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;

class SourceChannelImpl
extends Pipe.SourceChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    FileDescriptor fd;
    int fdVal;
    private volatile long thread = 0L;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;
    private volatile int state = -1;

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    SourceChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor) {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            long l;
            if (this.state != 1) {
                nd.preClose(this.fd);
            }
            if ((l = this.thread) != 0L) {
                NativeThread.signal(l);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                return;
            }
            if (this.state == -1) {
                this.state = 1;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            nd.close(this.fd);
            this.state = 1;
        }
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    public boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & 0x20) != 0) {
            throw new Error("POLLNVAL detected");
        }
        if ((n & 0x18) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            return (n5 & ~n4) != 0;
        }
        if ((n & 1) != 0 && (n3 & 1) != 0) {
            n5 |= 1;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        if (n == 1) {
            n = 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            int n;
            int n2;
            block11: {
                boolean bl;
                int n3;
                block10: {
                    n2 = 0;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            n3 = 0;
                            Object var6_6 = null;
                            this.thread = 0L;
                            bl = n2 > 0 || n2 == -2;
                            break block10;
                        }
                        this.thread = NativeThread.current();
                        while ((n2 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.lock)) == -3 && this.isOpen()) {
                        }
                        n = IOStatus.normalize(n2);
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        this.thread = 0L;
                        this.end(n2 > 0 || n2 == -2);
                        assert (IOStatus.check(n2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(n2));
                return n3;
            }
            Object var6_7 = null;
            this.thread = 0L;
            this.end(n2 > 0 || n2 == -2);
            assert (IOStatus.check(n2));
            return n;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        return this.read(Util.subsequence(byteBufferArray, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long read(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            long l;
            long l2;
            block12: {
                boolean bl;
                long l3;
                block11: {
                    l2 = 0L;
                    try {
                        this.begin();
                        if (!this.isOpen()) {
                            l3 = 0L;
                            Object var8_6 = null;
                            this.thread = 0L;
                            bl = l2 > 0L || l2 == -2L;
                            break block11;
                        }
                        this.thread = NativeThread.current();
                        while ((l2 = IOUtil.read(this.fd, byteBufferArray, nd)) == -3L && this.isOpen()) {
                        }
                        l = IOStatus.normalize(l2);
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        this.thread = 0L;
                        this.end(l2 > 0L || l2 == -2L);
                        assert (IOStatus.check(l2));
                        throw throwable;
                    }
                }
                this.end(bl);
                assert (IOStatus.check(l2));
                return l3;
            }
            Object var8_7 = null;
            this.thread = 0L;
            this.end(l2 > 0L || l2 == -2L);
            assert (IOStatus.check(l2));
            return l;
        }
    }

    static {
        Util.load();
        nd = new FileDispatcher();
    }
}

