/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.ParameterType;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ModelExtension;
import org.java.plugin.registry.xml.ModelParameter;
import org.java.plugin.registry.xml.ParameterValueParser;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExtensionImpl
extends PluginElementImpl<Extension>
implements Extension {
    private final ModelExtension model;
    private List<Extension.Parameter> parameters;
    private Boolean isValid;

    ExtensionImpl(PluginDescriptorImpl descr, PluginFragmentImpl aFragment, ModelExtension aModel) throws ManifestProcessingException {
        super(descr, aFragment, aModel.getId(), aModel.getDocumentation());
        this.model = aModel;
        if (this.model.getPluginId() == null || this.model.getPluginId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "extensionIdIsBlank", descr.getId());
        }
        if (this.model.getPointId() == null || this.model.getPointId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "extendedPointIdIsBlank", descr.getId());
        }
        this.parameters = new ArrayList<Extension.Parameter>(this.model.getParams().size());
        for (ModelParameter parameter : this.model.getParams()) {
            this.parameters.add(new ParameterImpl(null, parameter));
        }
        this.parameters = Collections.unmodifiableList(this.parameters);
        if (this.log.isDebugEnabled()) {
            this.log.debug("object instantiated: " + this);
        }
    }

    @Override
    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getDeclaringPluginDescriptor().getId(), this.getId());
    }

    @Override
    public Collection<Extension.Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Extension.Parameter getParameter(String id) {
        ParameterImpl result = null;
        for (Extension.Parameter parameter : this.parameters) {
            ParameterImpl param = (ParameterImpl)parameter;
            if (!param.getId().equals(id)) continue;
            if (result == null) {
                result = param;
                continue;
            }
            throw new IllegalArgumentException("more than one parameter with ID " + id + " defined in extension " + this.getUniqueId());
        }
        return result;
    }

    @Override
    public Collection<Extension.Parameter> getParameters(String id) {
        LinkedList<Extension.Parameter> result = new LinkedList<Extension.Parameter>();
        for (Extension.Parameter parameter : this.parameters) {
            if (!parameter.getId().equals(id)) continue;
            result.add(parameter);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public String getExtendedPluginId() {
        return this.model.getPluginId();
    }

    @Override
    public String getExtendedPointId() {
        return this.model.getPointId();
    }

    @Override
    public boolean isOptional() {
        return this.model.isOptional();
    }

    @Override
    public boolean isValid() {
        if (this.isValid == null) {
            this.validate();
        }
        return this.isValid;
    }

    Collection<IntegrityCheckReport.ReportItem> validate() {
        ExtensionPoint point = this.findExtensionPoint(this.getExtendedPluginId(), this.getExtendedPointId());
        if (point == null) {
            this.isValid = Boolean.FALSE;
            IntegrityCheckReport.Severity severity = this.isOptional() ? IntegrityCheckReport.Severity.WARNING : IntegrityCheckReport.Severity.ERROR;
            return Collections.singletonList(new IntegrityChecker.ReportItemImpl(severity, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "extPointNotAvailable", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getExtendedPluginId(), this.getExtendedPointId()), this.getUniqueId()}));
        }
        Collection<IntegrityCheckReport.ReportItem> result = this.validateParameters(point.getParameterDefinitions(), this.parameters);
        this.isValid = result.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        return result;
    }

    ExtensionPoint findExtensionPoint(String uniqueId) {
        PluginRegistry registry = this.getDeclaringPluginDescriptor().getRegistry();
        return this.findExtensionPoint(registry.extractPluginId(uniqueId), registry.extractId(uniqueId));
    }

    ExtensionPoint findExtensionPoint(String pluginId, String pointId) {
        PluginRegistry registry = this.getDeclaringPluginDescriptor().getRegistry();
        if (!registry.isPluginDescriptorAvailable(pluginId)) {
            return null;
        }
        for (ExtensionPoint point : registry.getPluginDescriptor(pluginId).getExtensionPoints()) {
            if (!point.getId().equals(pointId)) continue;
            return point;
        }
        return null;
    }

    private Collection<IntegrityCheckReport.ReportItem> validateParameters(Collection<ExtensionPoint.ParameterDefinition> allDefinitions, Collection<Extension.Parameter> allParams) {
        Collection<Extension.Parameter> paramGroup;
        ExtensionPoint.ParameterDefinition def;
        LinkedList<IntegrityCheckReport.ReportItem> result = new LinkedList<IntegrityCheckReport.ReportItem>();
        HashMap groups = new HashMap();
        for (Extension.Parameter param : allParams) {
            def = param.getDefinition();
            if (def == null) {
                result.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "cantDetectParameterDef", new Object[]{param.getId(), this.getUniqueId()}));
                continue;
            }
            if (groups.containsKey(param.getId())) {
                ((Collection)groups.get(param.getId())).add(param);
                continue;
            }
            paramGroup = new LinkedList<Extension.Parameter>();
            paramGroup.add(param);
            groups.put(param.getId(), paramGroup);
        }
        if (!result.isEmpty()) {
            return result;
        }
        List empty_paramGroup = Collections.emptyList();
        Iterator<ExtensionPoint.ParameterDefinition> i$ = allDefinitions.iterator();
        while (i$.hasNext()) {
            paramGroup = (Collection)groups.get((def = i$.next()).getId());
            result.addAll(this.validateParameters(def, paramGroup != null ? paramGroup : empty_paramGroup));
        }
        return result;
    }

    private Collection<IntegrityCheckReport.ReportItem> validateParameters(ExtensionPoint.ParameterDefinition def, Collection<Extension.Parameter> params) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("validating parameters for definition " + def);
        }
        switch (def.getMultiplicity()) {
            case ONE: {
                if (params.size() == 1) break;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "tooManyOrFewParams", new Object[]{def.getId(), this.getUniqueId()}));
            }
            case NONE_OR_ONE: {
                if (params.size() <= 1) break;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "tooManyParams", new Object[]{def.getId(), this.getUniqueId()}));
            }
            case ONE_OR_MORE: {
                if (!params.isEmpty()) break;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "tooFewParams", new Object[]{def.getId(), this.getUniqueId()}));
            }
        }
        if (params.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<IntegrityCheckReport.ReportItem> result = new LinkedList<IntegrityCheckReport.ReportItem>();
        int count = 1;
        for (Extension.Parameter parameter : params) {
            ParameterImpl param = (ParameterImpl)parameter;
            if (!param.isValid()) {
                result.add(new IntegrityChecker.ReportItemImpl(IntegrityCheckReport.Severity.ERROR, this, IntegrityCheckReport.Error.INVALID_EXTENSION, "invalidParameterValue", new Object[]{def.getId(), count, this.getUniqueId()}));
            }
            if (ParameterType.ANY != def.getType() && result.isEmpty()) {
                result.addAll(this.validateParameters(param.getDefinition().getSubDefinitions(), param.getSubParameters()));
            }
            ++count;
        }
        return result;
    }

    public String toString() {
        return "{PluginExtension: uid=" + this.getUniqueId() + "}";
    }

    void registryChanged() {
        this.isValid = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterImpl
    extends PluginElementImpl<Extension.Parameter>
    implements Extension.Parameter {
        private final ModelParameter modelParam;
        private ParameterValueParser valueParser;
        private List<Extension.Parameter> subParameters;
        private ExtensionPoint.ParameterDefinition definition;
        private boolean definitionDetected;
        private final ParameterImpl superParameter;

        ParameterImpl(ParameterImpl aSuperParameter, ModelParameter aModel) throws ManifestProcessingException {
            super(ExtensionImpl.this.getDeclaringPluginDescriptor(), ExtensionImpl.this.getDeclaringPluginFragment(), aModel.getId(), aModel.getDocumentation());
            this.definition = null;
            this.definitionDetected = false;
            this.superParameter = aSuperParameter;
            this.modelParam = aModel;
            this.subParameters = new ArrayList<Extension.Parameter>(this.modelParam.getParams().size());
            for (ModelParameter modelParameter : this.modelParam.getParams()) {
                this.subParameters.add(new ParameterImpl(this, modelParameter));
            }
            this.subParameters = Collections.unmodifiableList(this.subParameters);
            if (this.log.isDebugEnabled()) {
                this.log.debug("object instantiated: " + this);
            }
        }

        @Override
        public Extension getDeclaringExtension() {
            return ExtensionImpl.this;
        }

        @Override
        public PluginDescriptor getDeclaringPluginDescriptor() {
            return ExtensionImpl.this.getDeclaringPluginDescriptor();
        }

        @Override
        public PluginFragment getDeclaringPluginFragment() {
            return ExtensionImpl.this.getDeclaringPluginFragment();
        }

        @Override
        public ExtensionPoint.ParameterDefinition getDefinition() {
            Collection<ExtensionPoint.ParameterDefinition> definitions;
            if (this.definitionDetected) {
                return this.definition;
            }
            this.definitionDetected = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug("detecting definition for parameter " + this);
            }
            if (this.superParameter != null) {
                if (this.superParameter.getDefinition() == null) {
                    return null;
                }
                if (ParameterType.ANY == this.superParameter.getDefinition().getType()) {
                    this.definition = this.superParameter.getDefinition();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("definition detected - " + this.definition);
                    }
                    return this.definition;
                }
                definitions = this.superParameter.getDefinition().getSubDefinitions();
            } else {
                ExtensionPoint extPoint = ExtensionImpl.this.findExtensionPoint(this.getDeclaringExtension().getExtendedPluginId(), this.getDeclaringExtension().getExtendedPointId());
                if (extPoint == null) {
                    return null;
                }
                definitions = extPoint.getParameterDefinitions();
            }
            for (ExtensionPoint.ParameterDefinition def : definitions) {
                if (!def.getId().equals(this.getId())) continue;
                this.definition = def;
                break;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("definition detected - " + this.definition);
            }
            return this.definition;
        }

        @Override
        public Extension.Parameter getSuperParameter() {
            return this.superParameter;
        }

        @Override
        public Collection<Extension.Parameter> getSubParameters() {
            return this.subParameters;
        }

        @Override
        public Extension.Parameter getSubParameter(String id) {
            ParameterImpl result = null;
            for (Extension.Parameter parameter : this.subParameters) {
                ParameterImpl param = (ParameterImpl)parameter;
                if (!param.getId().equals(id)) continue;
                if (result == null) {
                    result = param;
                    continue;
                }
                throw new IllegalArgumentException("more than one parameter with ID " + id + " defined in extension " + ExtensionImpl.this.getUniqueId());
            }
            return result;
        }

        @Override
        public Collection<Extension.Parameter> getSubParameters(String id) {
            LinkedList<Extension.Parameter> result = new LinkedList<Extension.Parameter>();
            for (Extension.Parameter param : this.subParameters) {
                if (!param.getId().equals(id)) continue;
                result.add(param);
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        public String rawValue() {
            return this.modelParam.getValue() != null ? this.modelParam.getValue() : "";
        }

        boolean isValid() {
            if (this.valueParser != null) {
                return this.valueParser.isParsingSucceeds();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("validating parameter " + this);
            }
            this.valueParser = new ParameterValueParser(this.getDeclaringPluginDescriptor().getRegistry(), this.getDefinition(), this.modelParam.getValue());
            if (!this.valueParser.isParsingSucceeds()) {
                this.log.warn("parsing value for parameter " + this + " failed, message is: " + this.valueParser.getParsingMessage());
            }
            return this.valueParser.isParsingSucceeds();
        }

        @Override
        public Boolean valueAsBoolean() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.BOOLEAN != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.BOOLEAN));
            }
            if (this.valueParser.getValue() == null) {
                return (Boolean)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Boolean)this.valueParser.getValue();
        }

        @Override
        public Date valueAsDate() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.DATE != this.definition.getType() && ParameterType.DATE_TIME != this.definition.getType() && ParameterType.TIME != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.DATE) + " nor " + (Object)((Object)ParameterType.DATE_TIME) + " nor" + (Object)((Object)ParameterType.TIME));
            }
            if (this.valueParser.getValue() == null) {
                return (Date)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Date)this.valueParser.getValue();
        }

        @Override
        public Number valueAsNumber() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.NUMBER != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.NUMBER));
            }
            if (this.valueParser.getValue() == null) {
                return (Number)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Number)this.valueParser.getValue();
        }

        @Override
        public String valueAsString() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.STRING != this.definition.getType() && ParameterType.FIXED != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.STRING));
            }
            if (this.valueParser.getValue() == null) {
                return (String)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (String)this.valueParser.getValue();
        }

        @Override
        public Extension valueAsExtension() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.EXTENSION_ID != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.EXTENSION_ID));
            }
            if (this.valueParser.getValue() == null) {
                return (Extension)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Extension)this.valueParser.getValue();
        }

        @Override
        public ExtensionPoint valueAsExtensionPoint() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.EXTENSION_POINT_ID != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.EXTENSION_POINT_ID));
            }
            if (this.valueParser.getValue() == null) {
                return (ExtensionPoint)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (ExtensionPoint)this.valueParser.getValue();
        }

        @Override
        public PluginDescriptor valueAsPluginDescriptor() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.PLUGIN_ID != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.PLUGIN_ID));
            }
            if (this.valueParser.getValue() == null) {
                return (PluginDescriptor)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (PluginDescriptor)this.valueParser.getValue();
        }

        @Override
        public URL valueAsUrl() {
            return this.valueAsUrl(null);
        }

        @Override
        public URL valueAsUrl(PathResolver pathResolver) {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (ParameterType.RESOURCE != this.definition.getType()) {
                throw new UnsupportedOperationException("parameter type is not " + (Object)((Object)ParameterType.RESOURCE));
            }
            if (this.valueParser.getValue() == null && this.rawValue() == null) {
                return this.valueAsUrl(pathResolver, this.getDefinition().getDeclaringExtensionPoint(), (URL)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue(), this.getDefinition().getDefaultValue());
            }
            return this.valueAsUrl(pathResolver, this.getDeclaringPluginDescriptor(), (URL)this.valueParser.getValue(), this.rawValue());
        }

        private URL valueAsUrl(PathResolver pathResolver, Identity idt, URL absoluteUrl, String relativeUrl) {
            if (pathResolver == null || absoluteUrl != null) {
                return absoluteUrl;
            }
            if (relativeUrl == null) {
                return null;
            }
            return pathResolver.resolvePath(idt, relativeUrl);
        }

        public String toString() {
            return "{PluginExtension.Parameter: extUid=" + this.getDeclaringExtension().getUniqueId() + "; id=" + this.getId() + "}";
        }

        @Override
        protected boolean isEqualTo(Identity idt) {
            if (!super.isEqualTo(idt)) {
                return false;
            }
            ParameterImpl other = (ParameterImpl)idt;
            if (this.getSuperParameter() == null && other.getSuperParameter() == null) {
                return true;
            }
            if (this.getSuperParameter() == null || other.getSuperParameter() == null) {
                return false;
            }
            return this.getSuperParameter().equals(other.getSuperParameter());
        }
    }
}

