<%@page import="com.gridnine.xtrip.common.util.TextUtil"%>
<%@page import="java.util.Set"%>
<%@page import="java.util.LinkedList"%>
<%@page import="java.util.TreeSet"%>
<%@page import="com.gridnine.xtrip.common.gen.GenUtil"%>
<%@page import="com.gridnine.xtrip.common.meta.rest.RestMetaRegistry"%>
<%@page import="com.gridnine.xtrip.common.Environment"%>
<%@page import="com.gridnine.xtrip.common.rest.RestDocsHelper"%>
<%@page import="com.gridnine.xtrip.common.rest.RestDocType"%>
<%@page import="com.gridnine.xtrip.common.rest.RestDocTypeItem"%>
<%@ page language="java" session="false"
	contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="common.jspf"%>
<%
	RestService currentService = Environment
			.getPublished(RestMetaRegistry.class).getServices()
			.get(request.getParameter("s"));
	if (currentService == null) {
		response.sendError(response.SC_NOT_FOUND);
		return;
	}
	RestServicePage currentPage = null;
	RestServiceOperation currentOperation = currentService
			.getOperations().get(request.getParameter("o"));
	if (currentOperation == null) {
		response.sendError(response.SC_NOT_FOUND);
		return;
	}
	Set<String> types = new TreeSet<String>();
%>
<!DOCTYPE html>
<html>
<head>
<title><%=currentOperation.getTitle()%></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<link rel="stylesheet" type="text/css" href="lib/bootstrap.css" />
<link rel="stylesheet" type="text/css" href="lib/style.css" />
<link rel="stylesheet" href="lib/codemirror/codemirror.css">
<link rel="stylesheet" href="lib/codemirror/fold/foldgutter.css">
<script src="lib/codemirror/codemirror.js"></script>
<script src="lib/codemirror/fold/foldcode.js"></script>
<script src="lib/codemirror/fold/foldgutter.js"></script>
<script src="lib/codemirror/fold/brace-fold.js"></script>
<script src="lib/codemirror/fold/xml-fold.js"></script>
<script src="lib/codemirror/fold/comment-fold.js"></script>
<script src="lib/codemirror/javascript.js"></script>
<script src="lib/textarea-snippet.js"></script>
</head>
<body style="padding-top: 10px">
	<div class="container-fluid">
		<div class="row-fluid">
			<div class="span3">
				<%@ include file="left.jspf"%>
			</div>
			<div class="span9">
				<!-- content start -->
				<h1><%=currentOperation.getTitle()%><br> <small><span
						class="label"><%=Boolean.TRUE.equals(currentOperation.getWebsocket()) ? "WebSocket" : currentOperation.getMethod()%></span> <%=!Boolean.TRUE.equals(currentOperation.getWebsocket()) ? currentService.getPath() : currentService.getWebSocketPath()%>/<%=currentOperation.getPath()%>
						<%
							if (!TextUtil.isBlank(currentOperation.getValidatingRouteId())) {
						%>, валидация <%=currentService.getPath()%>/<%=currentOperation.getPath()%>/<%=currentService.getValidatingPathSuffix()%>
						<%
							}
						%> </small>
				</h1>
				<%
					if (currentOperation.isDeprecated()) {
				%>
				<p style="color: red">Операция устарела и не рекомендуется к
					использованию.</p>
				<%
					}
					for (String doc : currentOperation.getDocumentation()) {
				%>
				<p><%=doc%></p>
				<%
					}
				%>
				<h2 id="descriptors">Параметры и результат</h2>
				<%
					if (currentOperation.getParametersDescriptor() != null) {
						String typeId = currentOperation.getParametersDescriptor()
								.getTypeId();
						RestDocsHelper.collectTypes(types, typeId);
				%>
				<h3>
					parameters
					<%
					if (!currentOperation.getParametersDescriptor().isOptional()) {
				%>
					<span class="label">обязателен</span>
					<%
						}
							if (currentOperation.getParametersDescriptor().isCollection()) {
					%>
					<span class="label">массив</span>
					<%
						}
					%>
					<small><a href="#<%=typeId%>"><%=GenUtil.getSimpleClassName(typeId)%></a></small>
				</h3>
				<%
					for (RestServiceOperation.DocumentationItem docItem : currentOperation
								.getParametersDescriptor().getDocumentation()) {
							if (docItem.getType() == RestServiceOperation.DocumentationItemType.DESCRIPTION) {
				%>
				<p><%=docItem.getContent()%></p>
				<%
					} else if (docItem.getType() == RestServiceOperation.DocumentationItemType.EXAMPLE) {
				%>
				<p>
					<textarea class="snippet"><%=docItem.getContent()%></textarea>
				</p>
				<%
					}
						}
					}
				%>
				<%
					if (currentOperation.getEntityDescriptor() != null) {
						String typeId = currentOperation.getEntityDescriptor()
								.getTypeId();
						RestDocsHelper.collectTypes(types, typeId);
				%>
				<h3>
					entity
					<%
					if (!currentOperation.getEntityDescriptor().isOptional()) {
				%>
					<span class="label">обязателен</span>
					<%
						}
					%>
					<small><a href="#<%=typeId%>"><%=GenUtil.getSimpleClassName(typeId)%></a></small>
				</h3>
				<%
					for (RestServiceOperation.DocumentationItem docItem : currentOperation
								.getEntityDescriptor().getDocumentation()) {
							if (docItem.getType() == RestServiceOperation.DocumentationItemType.DESCRIPTION) {
				%>
				<p><%=docItem.getContent()%></p>
				<%
					} else if (docItem.getType() == RestServiceOperation.DocumentationItemType.EXAMPLE) {
				%>
				<p>
					<textarea class="snippet"><%=docItem.getContent()%></textarea>
				</p>
				<%
					}
						}
					}
				%>
				<%
					if (currentOperation.getResultDescriptor() != null) {
						String typeId = currentOperation.getResultDescriptor()
								.getTypeId();
						RestDocsHelper.collectTypes(types, typeId);
				%>
				<h3>
					result
					<%
					if (!currentOperation.getResultDescriptor().isOptional()) {
				%>
					<span class="label">обязателен</span>
					<%
						}
							if (currentOperation.getResultDescriptor().isCollection()) {
					%>
					<span class="label">массив</span>
					<%
						}
					%>
					<small><a href="#<%=typeId%>"><%=GenUtil.getSimpleClassName(typeId)%></a></small>
				</h3>
				<%
					for (RestServiceOperation.DocumentationItem docItem : currentOperation
								.getResultDescriptor().getDocumentation()) {
							if (docItem.getType() == RestServiceOperation.DocumentationItemType.DESCRIPTION) {
				%>
				<p><%=docItem.getContent()%></p>
				<%
					} else if (docItem.getType() == RestServiceOperation.DocumentationItemType.EXAMPLE) {
				%>
				<p>
					<textarea class="snippet"><%=docItem.getContent()%></textarea>
				</p>
				<%
					}
						}
					}
				%>
				<h2 id="referencedObjects">Спецификация объектов</h2>
				<dl>
					<%

						String docGen = currentService.getDocHandler();

						final List<RestDocType> docTypes = RestDocsHelper.getDocTypes(
								types, docGen);
						for (RestDocType type : docTypes) {
							final String typeId = type.getId();
							final boolean isEnum = type.isEnum();
					%>
					<dt id="<%=typeId%>"
						<%=type.isDeprecated() ? "style=\"text-decoration: line-through;\""
						: ""%>><%=type.getName()%></dt>
					<dd>
						<%
							{
									String description = type.getDocumentation();
									if (description != null) {
						%><p><%=description%></p>
						<%
							}
									final String superId = type.getSupertype();
									if (superId != null) {
						%><dl>
							<dt>Унаследован от:</dt>
							<dd><%=RestDocsHelper.getLink(RestDocsHelper
								.getLinkTypeId(superId))%></dd>
						</dl>
						<%
							}
							if (type.getInterfaces() != null
									&& type.getInterfaces().size() > 0) {
						%><dl>
							<dt>Реализует:</dt>
							<%
								for (String interfaceId : type.getInterfaces()) {
							%><dd><%=GenUtil.getSimpleClassName(interfaceId)%></dd>
							<%
								}
							%>
						</dl>
						<%
							}
									if (type.getAllKnownSubtypes() != null
											&& type.getAllKnownSubtypes().size() > 0) {
						%><dl>
							<dt>Известные реализации:</dt>
							<%
								for (String subtypeId : type.getAllKnownSubtypes()) {
							%><dd><%=RestDocsHelper.getLink(RestDocsHelper
									.getLinkTypeId(subtypeId))%></dd>
							<%
								}
							%>
						</dl>
						<%
							}
								}
						%>
						<table class="table table-striped table-bordered">
							<thead>
								<tr>
									<%
										if (!isEnum) {
									%>
									<th>Параметр</th>
									<th>Описание</th>
									<th>Формат, значения</th>
									<th>Обязательность</th>
									<%
										} else {
									%>
									<th>Константа</th>
									<th>Описание</th>
									<%
										}
									%>
								</tr>
							</thead>
							<tbody>
								<%
									for (RestDocTypeItem item : type.getItems()) {
								%>
								<tr>
									<td
										<%=item.isDeprecated() ? "style=\"text-decoration: line-through;\""
							: ""%>><%=item.getName()%></td>
									<td><%=item.getDocumentation() != null ? item
							.getDocumentation() : ""%></td>
									<%
										if (!isEnum) {
									%>
									<td><%=item.getTypeName() != null ? item
								.getTypeName() : ""%></td>
									<td><%=item.getRequired() != null ? item
								.getRequired() : ""%></td>
									<%
										}
									%>
								</tr>
								<%
									}
								%>
							</tbody>
						</table>
					</dd>
					<%
						}
					%>
				</dl>
				<!-- content end -->
			</div>
		</div>
	</div>
</body>
</html>