<%!
static <T extends Enum<T>> String getOptionList(final Class<T> cls,
        final T selected) {
    StringBuilder result = new StringBuilder();
    result.append("<option value=\"\"");
    if (selected == null) {
        result.append(" selected=\"selected\"");
    }
    result.append("> - </option>");
    for (T enumConstant : cls.getEnumConstants()) {
        result.append("<option value=\"").append(enumConstant.name())
            .append("\"");
        if (enumConstant == selected) {
            result.append(" selected=\"selected\"");
        }
        result.append(">").append(enumConstant).append("</option>");
    }
    return result.toString();
}

static <T extends Enum<T>> String getOptionList(final Class<T> cls,
        final T selected, final boolean notSelectedEnabled) {
    StringBuilder result = new StringBuilder();
    if (notSelectedEnabled) {
	    result.append("<option value=\"\"");
	    if (selected == null) {
	        result.append(" selected=\"selected\"");
	    }
	    result.append("> - </option>");
    }    
    for (T enumConstant : cls.getEnumConstants()) {
        result.append("<option value=\"").append(enumConstant.name())
            .append("\"");
        if (enumConstant == selected) {
            result.append(" selected=\"selected\"");
        }
        result.append(">").append(enumConstant).append("</option>");
    }
    return result.toString();
}

static String getOptionNumbersList(final int start, final int end,
        final int selected) {
    StringBuilder buf = new StringBuilder();
    for (int i = start; i <= end; i++) {
        buf.append("<option value=\"").append(i).append("\"");
        if (i == selected) {
            buf.append(" selected=\"selected\"");
        }
        buf.append(">").append(i).append("</option>");
    }
    return buf.toString();
}

static String getOptionList(final String selected, final String... options) {
    StringBuilder result = new StringBuilder();
    for (String option : options) {
        result.append("<option value=\"").append(option).append("\"");
        if (com.gridnine.xtrip.common.util.MiscUtil.equals(option, selected)) {
            result.append(" selected=\"selected\"");
        }
        result.append(">").append(
            com.gridnine.xtrip.common.util.TextUtil.isBlank(option) ? " - "
                : option).append("</option>");
    }
    return result.toString();
}

static String getSelected(final boolean flag) {
    return flag ? " selected=\"selected\"" : "";
}

static String getChecked(final boolean flag) {
    return flag ? " checked=\"checked\"" : "";
}

static String getDisabled(final boolean flag) {
    return flag ? " disabled=\"disabled\"" : "";
}

static String escapeHtml(final String text) {
    if (com.gridnine.xtrip.common.util.TextUtil.isBlank(text)) {
        return text;
    }
    StringBuffer result = new StringBuffer();
    for (int i = 0; i < text.length(); i++) {
        char ch = text.charAt(i);
        switch (ch) {
            case '<':
                result.append("&lt;");
                break;
            case '>':
                result.append("&gt;");
                break;
            case '"':
                result.append("&quot;");
                break;
            case '\'':
                result.append("&#39;");
                break;
            case '$':
                result.append("&#36;");
                break;
            default:
                result.append(ch);
                break;
        }
    }
    return result.toString();
}
%>