<%@ page
	language="java"
	contentType="text/html; charset=utf-8"
	errorPage="../error.jsp"
	import="java.util.*"
	import="java.text.*"
	import="com.gridnine.xtrip.common.*"
	import="com.gridnine.xtrip.common.xml.*"
	import="com.gridnine.xtrip.common.util.*"
	import="com.gridnine.xtrip.common.model.*"
	import="com.gridnine.xtrip.common.model.dict.*"
	import="com.gridnine.xtrip.server.storage.*"
%><%@ include file="../resources/lib.jsp" %><%Class<BaseDictionary> type =
    (Class<BaseDictionary>) Class.forName(request.getParameter("type"));
BaseDictionary item = Environment.getPublished(DictionaryCache.class)
	.getAll(type).get(request.getParameter("code"));
if (item == null) {
    item = type.newInstance();
}
if (request.getParameter("view") != null) {
    response.setContentType("text/xml");
    XUtil.serialize(item, response.getOutputStream());
    return;
}
if (request.getParameter("save") != null) {
    XUtil.fromString(request.getParameter("data"), item);
    DictionaryStorage.get().save(item);
    response.sendRedirect("dict-editor.jsp?type="
        + item.getClass().getName() + "&code=" + item.getCode());
    return;
}
SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
	<title><%= item %> - Dictionary Editor - <%= application.getServletContextName() %></title>
	<link rel="StyleSheet" type="text/css" href="../resources/base.css">
</head>

<body>

<form action="dict-editor.jsp" method="post">
<table align="center" width="90%" cellpadding="5" cellspacing="0">
	<tr>
		<td>
			<% if (item.getCreated() != null) { %>
			Created <%= dtf.format(item.getCreated()) %> by <%= item.getCreatedBy() %>.
			<% } %>
			<% if (item.getModified() != null) { %>
			Modified <%= dtf.format(item.getModified()) %> by <%= item.getModifiedBy() %>.
			<% } %>
		</td>
		<td align="right">
			<input type="hidden" name="type" value="<%= item.getClass().getName() %>"/>
			<input type="hidden" name="code" value="<%= item.getCode() %>"/>
			<input type="submit" name="save" value="Save"/>
		</td>
	</tr>
	<tr>
		<td colspan="2">
			<textarea name="data" style="width:100%" rows="25"><%= escapeHtml(XSUtil.toString(item)) %></textarea>
		</td>
	</tr>
	<tr>
		<td colspan="2">
			<a href="meta-browser.jsp#<%= item.getClass().getName() %>">Meta reference</a>
		</td>
	</tr>
</table>
</form>

</body>
</html>
