<%@page import="com.gridnine.xtrip.common.model.asset.AssetsStorage"%>
<%@ page language="java" contentType="text/html; charset=utf-8"
	errorPage="../error.jsp" import="java.util.*" import="java.text.*"
	import="com.gridnine.xtrip.common.*"
	import="com.gridnine.xtrip.common.xml.*"
	import="com.gridnine.xtrip.common.util.*"
	import="com.gridnine.xtrip.common.search.*"
	import="com.gridnine.xtrip.common.model.*"
	import="com.gridnine.xtrip.common.model.assets.*"
	import="com.gridnine.xtrip.common.model.dict.*"
	import="com.gridnine.xtrip.common.model.system.*"
	import="com.gridnine.xtrip.server.storage.*"%><%@ include
	file="../resources/lib.jsp"%><%!static String getMarker(MessageType type) {
        if (type == null) {
            return "&nbsp;";
        }
        switch (type) {
        case ERROR:
            return "<span title='error' style='color:red'>&#8226;&nbsp;E:</span>";
        case WARNING:
            return "<span title='warning' style='color:yellow'>&#8226;&nbsp;W:</span>";
        default:
            return "<span title='message' style='color:green'>&#8226;&nbsp;M:</span>";
        }
    }

    static String getReference(SysLogItem item) {
        if (item.getReferenceType() == null) {
            return "";
        }
        return String.format(
            "<span title='%s:%s'>%s</span>",
            item.getReferenceType(),
            item.getReferenceUid(),
            TextUtil.isBlank(item.getReferenceCaption()) ? item
                .getReferenceUid() : item.getReferenceCaption());
    }%>
<%
    SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    SysLogItem.EventType eventType = CollectionUtil.findEnumConstant(
        SysLogItem.EventType.class, request.getParameter("eventType"));
    String refType = request.getParameter("refType");
    if (refType == null) {
        refType = "";
    }
    String refUid = request.getParameter("refUid");
    if (refUid == null) {
        refUid = "";
    }
    String tag = request.getParameter("tag");
    if (tag == null) {
        tag = "";
    }
    String pattern = request.getParameter("pattern");
    if (pattern == null) {
        pattern = "";
    }
    int limit = 100;
    if (request.getParameter("limit") != null) {
        limit = Integer.parseInt(request.getParameter("limit"));
    }
    SearchQuery query = new SearchQuery();
    if (eventType != null) {
        query
            .getCriteria()
            .getCriterions()
            .add(
                SearchCriterion.eq(
                    SysLogItem.Property.eventType.name(), eventType));
    }
    if (!TextUtil.isBlank(refType)) {
        query
            .getCriteria()
            .getCriterions()
            .add(
                SearchCriterion.eq(
                    SysLogItem.Property.referenceType.name(), refType));
    }
    if (!TextUtil.isBlank(refUid)) {
        query
            .getCriteria()
            .getCriterions()
            .add(
                SearchCriterion.eq(
                    SysLogItem.Property.referenceUid.name(), refUid));
    }
    if (!TextUtil.isBlank(tag)) {
        query
            .getCriteria()
            .getCriterions()
            .add(
                SearchCriterion.eq(SysLogItem.Property.tag.name(), tag));
    }
    if (!TextUtil.isBlank(pattern)) {
        query.getCriteria().setFreeTextPattern(pattern);
    }
    query.getCriteria().getOrders()
        .put(SysLogItem.Property.eventDate.name(), SortOrder.ASC);
    query.setLimit(limit);
    SearchResult<SysLogItem> searchResult = AssetsStorage.get().search(
        SysLogItem.class, query);
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>System Log - <%=application.getServletContextName()%></title>
<link rel="StyleSheet" type="text/css" href="../resources/base.css">
<script type="text/javascript" src="../resources/lib.js"></script>
</head>

<body>

	<form action="sys-log.jsp" method="post">
		<p>
			<label for="eventType">Event Type:</label>&nbsp;<select
				id="eventType" name="eventType">
				<%=getOptionList(SysLogItem.EventType.class, eventType)%>
			</select> <label for="tag">Tag:</label>&nbsp;<input id="tag" size="20"
				type="text" name="tag" value="<%=tag%>" /> <label for="pattern">Free
				Text Pattern:</label>&nbsp;<input id="pattern" size="10" type="text"
				name="pattern" value="<%=pattern%>" /> <label for="limit">Limit:</label>&nbsp;<input
				id="limit" size="3" type="text" name="limit" value="<%=limit%>" />
			<br /> <label for="refType">Reference Type:</label>&nbsp;<input
				id="refType" size="60" type="text" name="refType"
				value="<%=refType%>" /> <label for="refUid">Refernce UID:</label>&nbsp;<input
				id="refUid" size="40" type="text" name="refUid"
				value="<%=refUid%>" /> <br /> <input type="submit" name="search"
				value="Search" />
		</p>
	</form>

	<table border="1" cellspacing="0" cellpadding="5">
		<tr>
			<th>Timestamp</th>
			<th>User</th>
			<th>Type</th>
			<th>Tag</th>
			<th>Reference</th>
			<th>Message</th>
			<th>Metric</th>
			<th>Old Value</th>
			<th>New Value</th>
		</tr>
		<%
		    for (SysLogItem item : searchResult.getData()) {
		%>
		<tr>
			<td nowrap="nowrap"><%=dtf.format(item.getDate())%></td>
			<td><%=item.getUser()%></td>
			<td><%=item.getType()%></td>
			<td><%=item.getTag()%></td>
			<td><%=getReference(item)%></td>
			<td>
				<%
				    if (item.getMessage() != null) {
				%> <%=getMarker(item.getMessage().getType())%>
				<%=item.getMessage().getMessage()%> <%
     if (!TextUtil.isBlank(item.getMessage().getDetails())) {
 %>
				<a href="javascript:toggleVisible('<%=item.getUid()%>')">details</a>
				<textarea id="<%=item.getUid()%>"
					style="display: none; width: 100%" rows="10" wrap="off"><%=item.getMessage().getDetails()%></textarea>
				<%
				    }
				%> <%
     } else {
 %> &nbsp; <%
     }
 %>
			</td>
			<td><%=item.getMetricValue()%></td>
			<td><%=item.getValueOld()%></td>
			<td><%=item.getValueNew()%></td>
		</tr>
		<%
		    }
		%>
	</table>

</body>
</html>
