<%@page import="java.util.Date"%>
<%@page import="java.text.SimpleDateFormat"%>
<%@page import="java.lang.management.LockInfo"%>
<%@page import="java.lang.management.MonitorInfo"%>
<%@page import="java.lang.management.ManagementFactory"%>
<%@page import="java.lang.management.ThreadInfo"%>
<%@page import="java.io.PrintWriter"%>
<%@ page contentType="text/plain; charset=UTF-8"%>
<%!private static final String INDENT = "    ";

    private void dumpThreads(PrintWriter out) {
        out.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS")
            .format(new Date()));
        out.println("Full thread dump " + System.getProperty("java.vm.name")
            + " (" + System.getProperty("java.version") + ')');
        out.println();
        for (ThreadInfo ti : ManagementFactory.getThreadMXBean()
            .dumpAllThreads(true, true)) {
            dumpThread(out, ti);
        }
        out.println();
    }

    private void dumpThread(PrintWriter out, ThreadInfo ti) {
        printThreadInfo(out, ti);
        StackTraceElement[] stacktrace = ti.getStackTrace();
        MonitorInfo[] monitors = ti.getLockedMonitors();
        for (int i = 0; i < stacktrace.length; i++) {
            StackTraceElement ste = stacktrace[i];
            out.println(INDENT + "at " + ste.toString());
            if (i == 0 && ti.getLockInfo() != null) {
                switch (ti.getThreadState()) {
                case BLOCKED:
                    out.println(INDENT + "- blocked on " + ti.getLockInfo());
                    break;
                case WAITING:
                    out.println(INDENT + "- waiting on " + ti.getLockInfo());
                    break;
                case TIMED_WAITING:
                    out.println(INDENT + "- waiting on " + ti.getLockInfo());
                    break;
                default:
                    // no-op
                }
            }
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() == i) {
                    out.println(INDENT + "- locked " + mi);
                }
            }
        }
        out.println();
        printLockInfo(out, ti.getLockedSynchronizers());
    }

    private void printThreadInfo(PrintWriter out, ThreadInfo ti) {
        out.print("\"" + ti.getThreadName() + "\"");
        out.print(" id=" + ti.getThreadId());
        out.print(" in " + ti.getThreadState());
        if (ti.isSuspended()) {
            out.print(" (suspended)");
        }
        if (ti.isInNative()) {
            out.print(" (running in native)");
        }
        out.println();
        if (ti.getLockOwnerName() != null) {
            out.println(INDENT + INDENT + "owned by " + ti.getLockOwnerName()
                + " id=" + ti.getLockOwnerId());
        }
    }

    private void printLockInfo(PrintWriter out, LockInfo[] locks) {
        if (locks.length == 0) {
            return;
        }
        out.println(INDENT + "Locked synchronizers: " + locks.length);
        for (LockInfo li : locks) {
            out.println(INDENT + "- " + li);
        }
        out.println();
    }%><%
    response.addHeader("Content-Disposition", "inline; filename=\""
        + System.currentTimeMillis() + ".tdump\"");
    dumpThreads(response.getWriter());
%>