/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.unifest.profile.server.rest.common;

import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.util.Objects;

class AuthorizationHelper {
    private static final char[] PWD = "nb4KoQPi72oDPLyTSRcj".toCharArray();

    AuthorizationHelper() {
    }

    static String generateToken(String login, String password) throws Exception {
        AuthorizationHelper.auth(login, password);
        StringBuilder token = new StringBuilder();
        token.append(login.trim()).append('|').append(password.trim());
        return Base64.encode((byte[])DesUtil.encrypt((char[])PWD, (byte[])token.toString().getBytes("UTF-8")));
    }

    static void checkToken(String token) throws Exception {
        Objects.requireNonNull(token);
        String[] data = new String(DesUtil.decrypt((char[])PWD, (byte[])Base64.decode((String)token))).split("\\|");
        String login = data[0];
        String password = data[1];
        AuthorizationHelper.auth(login, password);
    }

    private static void auth(String login, String password) throws AuthorizationException {
        Objects.requireNonNull(login);
        Objects.requireNonNull(password);
        UserAccount userAccount = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)login);
        if (Objects.isNull(userAccount)) {
            throw new AuthorizationException(AuthorizationResultCode.INVALID_CREDENTIALS, "UserAccount not found");
        }
        if (!userAccount.isActive()) {
            throw new AuthorizationException(AuthorizationResultCode.USER_BLOCKED, "UserAccount not isActive");
        }
        try {
            LogicalStorage.get().authorize(login, password.toCharArray());
        }
        catch (Throwable t) {
            throw new AuthorizationException(AuthorizationResultCode.INVALID_CREDENTIALS, t.getMessage());
        }
    }

    static class AuthorizationException
    extends Exception {
        private static final long serialVersionUID = -8068321771677751679L;
        private final AuthorizationResultCode result;

        AuthorizationException(AuthorizationResultCode result, String message) {
            super(message);
            this.result = Objects.requireNonNull(result);
        }

        AuthorizationResultCode getResult() {
            return this.result;
        }
    }

    static enum AuthorizationResultCode {
        INVALID_CREDENTIALS,
        USER_BLOCKED;

    }
}

