/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.unifest.profile.server.rest.common;

import com.gridnine.unifest.profile.server.rest.common.AuthorizationHelper;
import com.gridnine.unifest.profile.server.rest.common.AuthorizationParameters;
import com.gridnine.unifest.profile.server.rest.common.AuthorizationResult;
import com.gridnine.unifest.profile.server.rest.common.AuthorizationValidationMessages;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationProcessor
extends BaseProcessor {
    private static final Log authLog = LogFactory.getLog((String)"auth");

    public void process(MessageContext ctx) throws Exception {
        AuthorizationParameters parameters = (AuthorizationParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        RestContext context = (RestContext)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_CONTEXT);
        AuthorizationResult result = (AuthorizationResult)IbusHelper.getForceObject((MessageContext)ctx, (Enum)IBusRestContextKeys.REST_RESULT, (Object)new AuthorizationResult());
        String login = parameters.getLogin();
        String password = parameters.getPassword();
        String token = null;
        try {
            token = AuthorizationHelper.generateToken(login, password);
        }
        catch (AuthorizationHelper.AuthorizationException e) {
            context.setStatus(403);
            switch (e.getResult()) {
                case INVALID_CREDENTIALS: {
                    AuthorizationProcessor.updateValidationMessages(parameters, AuthorizationValidationMessages.getInvalidLoginOrPassword());
                    break;
                }
                case USER_BLOCKED: {
                    AuthorizationProcessor.updateValidationMessages(parameters, AuthorizationValidationMessages.getBlockedUser());
                }
            }
        }
        result.setToken(token);
    }

    private static void updateValidationMessages(AuthorizationParameters parameters, ValidationMessage message) {
        parameters.getValidationContext().getLoginValidationMessages().add(message);
        parameters.getValidationContext().getPasswordValidationMessages().add(message);
    }
}

