/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.standard.helpers;

import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Locale;

public class HttpHelper {
    public static ContentType getContentType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        if ("application/vnd.ms-excel".equals(mimeType)) {
            return ContentType.EXCEL;
        }
        if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(mimeType)) {
            return ContentType.EXCEL_2007;
        }
        if ("application/msword".equals(mimeType)) {
            return ContentType.WORD;
        }
        if ("application/vnd.openxmlformats-officedocument.wordprocessingml.document".equals(mimeType)) {
            return ContentType.WORD_2007;
        }
        if ("text/html; charset=utf-8".equals(mimeType)) {
            return ContentType.HTML;
        }
        if ("application/pdf".equals(mimeType)) {
            return ContentType.PDF;
        }
        if ("application/dbase".equals(mimeType)) {
            return ContentType.DBF;
        }
        if ("application/x-dbase".equals(mimeType)) {
            return ContentType.DBF;
        }
        if ("application/dbf".equals(mimeType)) {
            return ContentType.DBF;
        }
        if ("application/x-dbf".equals(mimeType)) {
            return ContentType.DBF;
        }
        if ("application/xml".equals(mimeType)) {
            return ContentType.XML;
        }
        if ("text/plain; charset=utf-8".equals(mimeType)) {
            return ContentType.TEXT;
        }
        if ("text/css; charset=utf-8".equals(mimeType)) {
            return ContentType.CSS;
        }
        if ("image/gif".equals(mimeType)) {
            return ContentType.GIF;
        }
        if ("image/jpeg".equals(mimeType)) {
            return ContentType.JPEG;
        }
        if ("image/png".equals(mimeType)) {
            return ContentType.PNG;
        }
        if ("text/calendar; charset=utf-8".equals(mimeType)) {
            return ContentType.CALENDAR;
        }
        if ("application/octet-stream".equals(mimeType)) {
            return ContentType.BINARY;
        }
        return null;
    }

    public static String getMimeType(ContentType contentType) {
        if (contentType == null) {
            return null;
        }
        switch (contentType) {
            case EXCEL: {
                return "application/vnd.ms-excel";
            }
            case EXCEL_2007: {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            case WORD: {
                return "application/msword";
            }
            case HTML: {
                return "text/html; charset=utf-8";
            }
            case PDF: {
                return "application/pdf";
            }
            case DBF: {
                return "application/vnd.ms-excel";
            }
            case XML: {
                return "application/xml";
            }
            case TEXT: {
                return "text/plain; charset=utf-8";
            }
            case CSS: {
                return "text/css; charset=utf-8";
            }
            case GIF: {
                return "image/gif";
            }
            case JPEG: {
                return "image/jpeg";
            }
            case PNG: {
                return "image/png";
            }
            case CALENDAR: {
                return "text/calendar; charset=utf-8";
            }
            case WORD_2007: {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
        }
        return "application/octet-stream";
    }

    public static ContentType detectContentType(String fileName) {
        if (TextUtil.isBlank((String)fileName)) {
            return null;
        }
        int p = fileName.lastIndexOf(46);
        if (p == -1 || p == fileName.length() - 1) {
            return ContentType.BINARY;
        }
        String ext = fileName.substring(p + 1).toLowerCase(Locale.ROOT);
        if ("xls".equals(ext) || "xlsm".equals(ext)) {
            return ContentType.EXCEL;
        }
        if ("xlsx".equals(ext)) {
            return ContentType.EXCEL_2007;
        }
        if ("doc".equals(ext) || "docx".equals(ext) || "docm".equals(ext)) {
            return ContentType.WORD;
        }
        if ("htm".equals(ext) || "html".equals(ext)) {
            return ContentType.HTML;
        }
        if ("pdf".equals(ext)) {
            return ContentType.PDF;
        }
        if ("xml".equals(ext)) {
            return ContentType.XML;
        }
        if ("txt".equals(ext)) {
            return ContentType.TEXT;
        }
        if ("gif".equals(ext)) {
            return ContentType.GIF;
        }
        if ("dbf".equals(ext)) {
            return ContentType.DBF;
        }
        if ("jpg".equals(ext) || "jpeg".equals(ext)) {
            return ContentType.JPEG;
        }
        if ("png".equals(ext)) {
            return ContentType.PNG;
        }
        if ("css".equals(ext)) {
            return ContentType.CSS;
        }
        return ContentType.BINARY;
    }
}

