/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.standard.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.system.Message;

public final class SysLogHelper {
    public static final String TAG_ENTITY_MODIFICATION = "entity-modification";

    public static SysLogItem newAuditItem(EntityReference<?> ref, String operationId, Message message) {
        SysLogItem result = new SysLogItem();
        result.setType(SysLogItem.EventType.AUDIT);
        result.setReference(ref);
        result.setTag(operationId);
        result.setMessage(message);
        return result;
    }

    public static SysLogItem newModificationItem(EntityReference<?> ref, String propertyId, String oldValue, String newValue, Message message) {
        SysLogItem result = new SysLogItem();
        result.setType(SysLogItem.EventType.MODIFICATION);
        result.setReference(ref);
        result.setTag(propertyId);
        result.setValueOld(oldValue);
        result.setValueNew(newValue);
        result.setMessage(message);
        return result;
    }

    public static SysLogItem newMetricItem(EntityReference<?> ref, String metricId, double metricValue) {
        SysLogItem result = new SysLogItem();
        result.setType(SysLogItem.EventType.METRIC);
        result.setReference(ref);
        result.setTag(metricId);
        result.setMetricValue(metricValue);
        return result;
    }

    private SysLogHelper() {
    }
}

