/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.standard.helpers;

import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.export.UrlConnectionInfoSettings;
import com.gridnine.xtrip.common.model.net.AuthorizationSettings;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.LogFactory;

public class URLConnectionHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(URL url, AuthorizationSettings settings) {
        byte[] byArray;
        if (url == null) {
            return null;
        }
        InputStream is = URLConnectionHelper.prepareStream(url, settings);
        if (is == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IoUtil.copyStream((InputStream)is, (OutputStream)baos, (int)256);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Exception e) {
                LogFactory.getLog(URLConnectionHelper.class).error((Object)("failed loading content from " + url), (Throwable)e);
                return null;
            }
        }
        is.close();
        return byArray;
    }

    private static InputStream prepareStream(URL url, AuthorizationSettings settings) throws Exception {
        if (url == null) {
            return null;
        }
        if (!"http".equalsIgnoreCase(url.getProtocol())) {
            return IoUtil.getResourceInputStream((URL)url);
        }
        return URLConnectionHelper.prepareURLConnection(url, settings).getInputStream();
    }

    public static URLConnection prepareURLConnection(URL url, AuthorizationSettings settings) throws Exception {
        String encodedUserPwd;
        URLConnection conn;
        UrlConnectionInfoSettings info = URLConnectionHelper.getURLConnectionInfoSettings();
        LogFactory.getLog(URLConnectionHelper.class).debug((Object)String.format("connection: protocol = %s, userName = %s, password = %shost = %s, port = %s, proxyUserName = %s, proxyPassword = %s, ", url.getProtocol(), settings == null ? null : settings.getUserName(), settings == null ? null : settings.getPassword(), info.getProxyHost(), info.getProxyPort(), info.getProxyUserName(), info.getProxyPassword()));
        URLConnection uRLConnection = conn = !TextUtil.isBlank((String)info.getProxyHost()) && !TextUtil.isBlank((String)info.getProxyPort()) ? url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(info.getProxyHost(), Integer.parseInt(info.getProxyPort())))) : url.openConnection();
        if (!TextUtil.isBlank((String)info.getProxyUserName()) && !TextUtil.isBlank((String)info.getProxyPassword())) {
            encodedUserPwd = Base64.encode((byte[])String.format("%s:%s", info.getProxyUserName().trim(), info.getProxyPassword().trim()).getBytes("utf-8"));
            conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
        }
        if (settings != null && !TextUtil.isBlank((String)settings.getUserName()) && !TextUtil.isBlank((String)settings.getPassword())) {
            encodedUserPwd = Base64.encode((byte[])String.format("%s:%s", settings.getUserName().trim(), settings.getPassword().trim()).getBytes("utf-8"));
            conn.setRequestProperty("Authorization", "Basic " + encodedUserPwd);
        }
        return conn;
    }

    private static UrlConnectionInfoSettings getURLConnectionInfoSettings() {
        UrlConnectionInfoSettings result = new UrlConnectionInfoSettings();
        EntityContainer container = EntityStorage.get().load(UrlConnectionInfoSettings.class, UniqueSettingsRegistry.get().getUidByClassName(UrlConnectionInfoSettings.class.getName()));
        if (container == null) {
            LogFactory.getLog(UrlConnectionInfoSettings.class).debug((Object)"No URL connections info settings present!");
            return result;
        }
        UrlConnectionInfoSettings entity = (UrlConnectionInfoSettings)container.getEntity();
        result.setProxyUserName(entity.getProxyUserName());
        result.setProxyPassword(entity.getProxyPassword());
        result.setProxyHost(entity.getProxyHost());
        result.setProxyPort(entity.getProxyPort());
        return result;
    }
}

