/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.standard.helpers;

import com.gridnine.xtrip.common.model.Validatable;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.validation.ValidationHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ValidatableUtil {
    public static void addMessages(Map<String, ?> map, String prefix, Collection<Message> messages) {
        map.forEach((k, v) -> {
            Collection coll;
            if (v instanceof Validatable) {
                ValidatableUtil.addMessages((Validatable)v, prefix + "[" + k + "]", messages);
            } else if (v instanceof Collection && !CollectionUtil.isEmpty((Collection)(coll = (Collection)v)) && coll.iterator().next() instanceof Validatable) {
                ValidatableUtil.addMessages((Collection)v, prefix + "[" + k + "]", messages);
            }
        });
    }

    public static void addMessages(Collection<? extends Validatable> validatableList, String prefix, Collection<Message> messages) {
        int i = 0;
        for (Validatable validatable : validatableList) {
            ValidatableUtil.addMessages(validatable, prefix + "[" + String.valueOf(i) + "]", messages);
            ++i;
        }
    }

    public static void addMessages(Validatable validatable, String prefix, Collection<Message> messages) {
        Map vms = ValidationHelper.getAllValidationMessages((Validatable)validatable);
        for (Map.Entry entry : vms.entrySet()) {
            messages.add(MessagesHelper.createMessage(MessageType.ERROR, prefix + "." + (String)entry.getKey() + ": " + ValidatableUtil.joinMessagesText((Collection)entry.getValue()), new Object[0]));
        }
    }

    public static String joinMessagesText(Collection<ValidationMessage> messages) {
        StringBuilder sb = new StringBuilder();
        for (ValidationMessage vm : messages) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(vm.getText());
        }
        return sb.toString();
    }

    public static List<String> toStrings(Collection<Message> messages) {
        return messages.stream().map(m -> m.getMessage().toString()).collect(Collectors.toList());
    }

    public static List<String> getValidateStrings(Validatable validatable) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ValidatableUtil.addMessages(validatable, "", messages);
        return ValidatableUtil.toStrings(messages);
    }

    public static List<String> getValidateStrings(Collection<? extends Validatable> validatableList, String prefix) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        for (Validatable validatable : validatableList) {
            List<String> validateStrings = ValidatableUtil.getValidateStrings(validatable);
            if (!validateStrings.isEmpty()) {
                result.add(prefix + "[" + String.valueOf(i) + "]" + TextUtil.join((String)"; ", validateStrings));
            }
            ++i;
        }
        return result;
    }
}

