/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.http;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    public static void delete(Cookie cookie) throws NullPointerException {
        Objects.requireNonNull(cookie);
        cookie.setMaxAge(0);
        cookie.setPath("/");
        cookie.setValue("");
    }

    public static Cookie find(HttpServletRequest httpServletRequest, String name) throws NullPointerException {
        Objects.requireNonNull(httpServletRequest);
        Objects.requireNonNull(name);
        Cookie[] cookies = httpServletRequest.getCookies();
        if (Objects.isNull(cookies)) {
            return null;
        }
        Optional<Cookie> find = Stream.of(cookies).filter(Objects::nonNull).filter(cookie -> name.equals(cookie.getName())).findAny();
        return find.orElse(null);
    }

    public static Set<String> getClientIpAddr(HttpServletRequest httpServletRequest) throws NullPointerException {
        Objects.requireNonNull(httpServletRequest);
        Set<String> clientIps = Stream.of("X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR").map(arg_0 -> ((HttpServletRequest)httpServletRequest).getHeader(arg_0)).filter(TextUtil::nonBlank).flatMap(headerValue -> Stream.of(headerValue.split(","))).collect(Collectors.toSet());
        clientIps.add(httpServletRequest.getRemoteAddr());
        return clientIps;
    }
}

