/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.rest;

import com.gridnine.xtrip.server.ibus.rest.RestContext;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RestContextAsync
extends RestContext {
    private final BiConsumer<RestContextAsync, Object> asyncResponseConsumer;
    private final BiConsumer<RestContextAsync, Throwable> asyncErrorConsumer;
    private final Consumer<RestContextAsync> closeHandler;
    private volatile boolean closed = false;

    public RestContextAsync(HttpServletRequest request, HttpServletResponse response, BiConsumer<RestContextAsync, Object> asyncResponseConsumer, BiConsumer<RestContextAsync, Throwable> asyncErrorConsumer, Consumer<RestContextAsync> closeHandler) {
        super(request, response);
        this.asyncResponseConsumer = Objects.requireNonNull(asyncResponseConsumer);
        this.asyncErrorConsumer = Objects.requireNonNull(asyncErrorConsumer);
        this.closeHandler = Objects.requireNonNull(closeHandler);
    }

    public void sendReponse(Object response) {
        if (this.closed) {
            return;
        }
        this.asyncResponseConsumer.accept(this, response);
    }

    public void sendError(Throwable error) {
        if (this.closed) {
            return;
        }
        this.asyncErrorConsumer.accept(this, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            return;
        }
        Consumer<RestContextAsync> consumer = this.closeHandler;
        synchronized (consumer) {
            this.closed = true;
            this.closeHandler.accept(this);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

