/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibus.rest.docs;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.EnumItem;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibus.IntegrationBusRegistry;
import com.gridnine.xtrip.server.ibus.model.AdviceDescription;
import com.gridnine.xtrip.server.ibus.model.BaseNodeDescription;
import com.gridnine.xtrip.server.ibus.model.RestfulInEndpointDescription;
import com.gridnine.xtrip.server.ibus.model.RouteDescription;
import com.gridnine.xtrip.server.ibus.model.SubrouteDescription;
import com.gridnine.xtrip.server.ibus.model.SubrouteMetadata;
import com.gridnine.xtrip.server.ibus.model.SwitchCaseDescription;
import com.gridnine.xtrip.server.ibus.model.SwitchDescription;
import com.gridnine.xtrip.server.ibus.rest.docs.RestDocGroup;
import com.gridnine.xtrip.server.ibus.rest.docs.RestDocItem;
import com.gridnine.xtrip.server.ibus.rest.docs.RestDocMethod;
import com.gridnine.xtrip.server.ibus.rest.docs.RestDocObject;
import com.gridnine.xtrip.server.ibus.rest.docs.RestDocProperty;
import com.gridnine.xtrip.server.ibus.rest.docs.RestDocPropertyMultiplicity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class RestDocHelper {
    public static List<RestDocGroup> getGroups(RestfulInEndpointDescription descr) {
        for (RouteDescription route : ((IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class)).getAllNodes(RouteDescription.class)) {
            if (route.getStartPoint() == null || !route.getStartPoint().equals(descr.getId())) continue;
            return RestDocHelper.getGroups(route);
        }
        return Collections.emptyList();
    }

    private static List<RestDocGroup> getGroups(RouteDescription route) {
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        SwitchDescription methodSwitch = RestDocHelper.findSwitch(route.getNodes());
        if (methodSwitch == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, List<RestDocItem>> map = new LinkedHashMap<String, List<RestDocItem>>();
        for (Map.Entry entry : methodSwitch.getCases().entrySet()) {
            String caseValue = (String)entry.getKey();
            SubrouteDescription subroute = (SubrouteDescription)reg.getNode(((SwitchCaseDescription)entry.getValue()).getRef(), SubrouteDescription.class);
            SwitchDescription pathSwitch = RestDocHelper.findSwitch(subroute.getNodes());
            if (pathSwitch == null) continue;
            for (Map.Entry entry2 : pathSwitch.getCases().entrySet()) {
                SubrouteDescription node = (SubrouteDescription)reg.getNode(((SwitchCaseDescription)entry2.getValue()).getRef(), SubrouteDescription.class);
                RestDocHelper.update(map, caseValue, (String)entry2.getKey(), node);
            }
        }
        ArrayList<RestDocGroup> result = new ArrayList<RestDocGroup>();
        for (Map.Entry entry : map.entrySet()) {
            RestDocGroup group = new RestDocGroup();
            group.setGroupName((String)entry.getKey());
            group.getItems().addAll((Collection)entry.getValue());
            Collections.sort(group.getItems(), new Comparator<RestDocItem>(){

                @Override
                public int compare(RestDocItem o1, RestDocItem o2) {
                    return TextUtil.compare((String)o1.getIssueId(), (String)o2.getIssueId(), (boolean)false, (boolean)false);
                }
            });
            result.add(group);
        }
        Collections.sort(result, new Comparator<RestDocGroup>(){

            @Override
            public int compare(RestDocGroup o1, RestDocGroup o2) {
                return TextUtil.compare((String)o1.getGroupName(), (String)o2.getGroupName(), (boolean)false, (boolean)false);
            }
        });
        return result;
    }

    private static void update(Map<String, List<RestDocItem>> map, String requestType, String issueId, SubrouteDescription node) {
        String group = RestDocHelper.getGroup(node);
        List<RestDocItem> lst = map.get(group);
        if (lst == null) {
            lst = new ArrayList<RestDocItem>();
            map.put(group, lst);
        }
        RestDocItem docItem = new RestDocItem();
        docItem.setIssueId(issueId);
        lst.add(docItem);
        RestDocMethod docMethod = new RestDocMethod();
        docItem.getMethods().put(requestType, docMethod);
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        SubrouteMetadata metadata = (SubrouteMetadata)reg.getMetadata(node.getMetadataRef(), SubrouteMetadata.class);
        docMethod.setDescription(metadata == null ? "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442" : metadata.getDescription());
        if (docItem.getItemName() == null) {
            docItem.setItemName(docMethod.getDescription());
        }
        for (String adviceId : node.getAdvices()) {
            String resultClass;
            RestDocProperty resultProperty;
            RestDocProperty parametersProperty;
            AdviceDescription adviceDescription = reg.getAdvice(adviceId);
            if ("rest:marshalling-advice".equals(adviceDescription.getMetadataRef())) {
                docMethod.setRequest(RestDocHelper.getObject(adviceDescription, "request-class", docItem.getReferencedElements()));
                docMethod.setResponse(RestDocHelper.getObject(adviceDescription, "response-class", docItem.getReferencedElements()));
                break;
            }
            if (!"vip-b2b-rest:entity-marshalling-advice".equals(adviceDescription.getMetadataRef())) continue;
            RestDocObject parametersObj = RestDocHelper.getObject(adviceDescription, "parameters-class", docItem.getReferencedElements());
            RestDocObject parametersListItemObj = RestDocHelper.getObject(adviceDescription, "parameters-list-item-class", docItem.getReferencedElements());
            RestDocObject entityObj = RestDocHelper.getObject(adviceDescription, "entity-class", docItem.getReferencedElements());
            RestDocObject resultListItemObj = RestDocHelper.getObject(adviceDescription, "result-list-item-class", docItem.getReferencedElements());
            RestDocObject resultObj = resultListItemObj == null ? RestDocHelper.getObject(adviceDescription, "result-class", docItem.getReferencedElements()) : null;
            RestDocObject request = new RestDocObject();
            request.setDisplayName("request");
            docMethod.setRequest(request);
            String example = "";
            String comment = "";
            if (parametersListItemObj != null) {
                parametersProperty = new RestDocProperty();
                parametersProperty.setName("parameters");
                parametersProperty.setDescription("");
                String parametersClass = (String)adviceDescription.getParameters().get("parameters-list-item-class");
                String pm = (String)adviceDescription.getParameters().get("parameters-mandatory");
                boolean paramsMandatory = TextUtil.isBlank((String)pm) || MiscUtil.isTrue((String)pm);
                parametersProperty.setFormat(RestDocHelper.getCollectionFormat(parametersClass));
                docItem.getReferencedElements().put(parametersClass, parametersListItemObj);
                parametersProperty.setReferencedObjectId(parametersClass);
                parametersProperty.setMultiplicity(paramsMandatory ? RestDocPropertyMultiplicity.ONE_OR_MORE : RestDocPropertyMultiplicity.ZERO_OR_MORE);
                request.getProperties().add(parametersProperty);
                request.setComment(parametersListItemObj.getComment());
                if (!TextUtil.isBlank((String)parametersListItemObj.getExample())) {
                    request.setExample("<textarea class=\"snippet\">{\n" + RestDocHelper.rtab("parameters: [\n" + RestDocHelper.rtab(RestDocHelper.trim(parametersListItemObj.getExample().replace("<textarea class=\"snippet\">", "").replace("</textarea>", ""))) + "\n]") + "\n}</textarea>");
                }
            } else if (parametersObj != null) {
                parametersProperty = new RestDocProperty();
                parametersProperty.setName("parameters");
                parametersProperty.setDescription("");
                String pm = (String)adviceDescription.getParameters().get("parameters-mandatory");
                boolean paramsMandatory = TextUtil.isBlank((String)pm) || MiscUtil.isTrue((String)pm);
                String paramatersClass = (String)adviceDescription.getParameters().get("parameters-class");
                parametersProperty.setFormat(RestDocHelper.getPropertyFormat(paramatersClass));
                docItem.getReferencedElements().put(paramatersClass, parametersObj);
                parametersProperty.setReferencedObjectId(paramatersClass);
                parametersProperty.setMultiplicity(paramsMandatory ? RestDocPropertyMultiplicity.ONE : RestDocPropertyMultiplicity.ZERO_OR_ONE);
                request.getProperties().add(parametersProperty);
                example = example + RestDocHelper.rtab("parameters: " + RestDocHelper.trim((!TextUtil.isBlank((String)parametersObj.getExample()) ? parametersObj.getExample() : "{\n}").replace("<textarea class=\"snippet\">", "").replace("</textarea>", "")));
                if (!TextUtil.isBlank((String)parametersObj.getComment())) {
                    comment = comment + parametersObj.getComment();
                }
            }
            if (entityObj != null) {
                RestDocProperty entityProperty = new RestDocProperty();
                entityProperty.setName("entity");
                entityProperty.setDescription("");
                String entityClass = (String)adviceDescription.getParameters().get("entity-class");
                entityProperty.setFormat(RestDocHelper.getPropertyFormat(entityClass));
                docItem.getReferencedElements().put(entityClass, entityObj);
                entityProperty.setReferencedObjectId(entityClass);
                entityProperty.setMultiplicity(RestDocPropertyMultiplicity.ONE);
                request.getProperties().add(entityProperty);
                if (!TextUtil.isBlank((String)entityObj.getExample())) {
                    if (!TextUtil.isBlank((String)example)) {
                        example = example + ",\n\n";
                    }
                    try {
                        example = example + RestDocHelper.rtab("entity: " + RestDocHelper.trim(entityObj.getExample().replace("<textarea class=\"snippet\">", "").replace("</textarea>", "")));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!TextUtil.isBlank((String)entityObj.getComment())) {
                    if (!TextUtil.isBlank((String)comment)) {
                        comment = comment + "\n\n";
                    }
                    comment = comment + entityObj.getComment();
                }
            }
            if (!TextUtil.isBlank((String)example)) {
                request.setExample("<textarea class=\"snippet\">{\n" + example + "\n}</textarea>");
            }
            if (!TextUtil.isBlank((String)comment)) {
                request.setComment(comment);
            }
            RestDocObject response = new RestDocObject();
            response.setDisplayName("response");
            docMethod.setResponse(response);
            if (resultListItemObj != null) {
                resultProperty = new RestDocProperty();
                resultProperty.setName("result");
                resultProperty.setDescription("");
                resultClass = (String)adviceDescription.getParameters().get("result-list-item-class");
                resultProperty.setFormat(RestDocHelper.getCollectionFormat(resultClass));
                docItem.getReferencedElements().put(resultClass, resultListItemObj);
                resultProperty.setReferencedObjectId(resultClass);
                resultProperty.setMultiplicity(RestDocPropertyMultiplicity.ONE_OR_MORE);
                response.getProperties().add(resultProperty);
                response.setComment(resultListItemObj.getComment());
                if (TextUtil.isBlank((String)resultListItemObj.getExample())) break;
                response.setExample("<textarea class=\"snippet\">{\n" + RestDocHelper.rtab("result: [\n" + RestDocHelper.rtab(RestDocHelper.trim(resultListItemObj.getExample().replace("<textarea class=\"snippet\">", "").replace("</textarea>", ""))) + "\n]") + "\n}</textarea>");
                break;
            }
            if (resultObj == null) break;
            resultProperty = new RestDocProperty();
            resultProperty.setName("result");
            resultProperty.setDescription("");
            resultClass = (String)adviceDescription.getParameters().get("result-class");
            resultProperty.setFormat(RestDocHelper.getPropertyFormat(resultClass));
            docItem.getReferencedElements().put(resultClass, resultObj);
            resultProperty.setReferencedObjectId(resultClass);
            resultProperty.setMultiplicity(RestDocPropertyMultiplicity.ONE);
            response.getProperties().add(resultProperty);
            response.setComment(resultObj.getComment());
            if (TextUtil.isBlank((String)resultObj.getExample())) break;
            response.setExample("<textarea class=\"snippet\">{\n" + RestDocHelper.rtab("result: " + RestDocHelper.trim(resultObj.getExample().replace("<textarea class=\"snippet\">", "").replace("</textarea>", ""))) + "\n}</textarea>");
            break;
        }
    }

    public static String rtab(String string) {
        return "\t" + string.replaceAll("\n|\r\n", "$0\t");
    }

    public static String trim(String string) {
        char c;
        int e;
        char c2;
        int s;
        for (s = 0; s < string.length() && ((c2 = string.charAt(s)) == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r'); ++s) {
        }
        if (s == string.length()) {
            return "";
        }
        for (e = string.length() - 1; e >= s && ((c = string.charAt(e)) == ' ' || c == '\t' || c == '\n' || c == '\r'); --e) {
        }
        return string.substring(s, e + 1);
    }

    private static RestDocObject getObject(AdviceDescription adviceDescription, String attr, Map<String, RestDocObject> referencedObjects) {
        String typeStr = (String)adviceDescription.getParameters().get(attr);
        if (TextUtil.isBlank((String)typeStr)) {
            return null;
        }
        MetaRegistry reg = MetaRegistry.get();
        EntityType type = (EntityType)reg.getEntities().get(typeStr);
        if (type == null) {
            return null;
        }
        RestDocObject result = new RestDocObject();
        result.setDisplayName(type.getDisplayName());
        result.getProperties().addAll(RestDocHelper.getProperties(type, referencedObjects));
        result.setComment((String)type.getParameters().get("rest_comment"));
        result.setExample((String)type.getParameters().get("rest_example"));
        return result;
    }

    private static List<RestDocProperty> getProperties(EntityType type, Map<String, RestDocObject> referencedObjects) {
        RestDocObject restObject;
        RestDocProperty prop;
        MetaRegistry reg = MetaRegistry.get();
        ArrayList<RestDocProperty> result = new ArrayList<RestDocProperty>();
        for (Property item : MetaRegistryHelper.getAllProperties((EntityType)type).values()) {
            prop = new RestDocProperty();
            if (!RestDocHelper.getBoolean(item.getParameters(), "rest_visible", true)) continue;
            result.add(prop);
            prop.setDescription(item.getDescription());
            prop.setName(item.getId());
            String formatDescription = item.getFormatDescription();
            prop.setFormat(StringUtils.isBlank((String)formatDescription) || formatDescription.indexOf("formatDescription") != -1 ? RestDocHelper.getPropertyFormat(item.getType()) : formatDescription);
            prop.setMultiplicity(RestDocHelper.getBoolean(item.getParameters(), "rest_required", true) ? RestDocPropertyMultiplicity.ONE : RestDocPropertyMultiplicity.ZERO_OR_ONE);
            EntityType et2 = (EntityType)reg.getEntities().get(item.getType());
            if (et2 != null) {
                prop.setReferencedObjectId(et2.getId());
                restObject = new RestDocObject();
                restObject.setDisplayName(et2.getDisplayName());
                restObject.getProperties().addAll(RestDocHelper.getProperties(et2, referencedObjects));
                referencedObjects.put(et2.getId(), restObject);
                continue;
            }
            EnumType et3 = (EnumType)reg.getEnums().get(item.getType());
            if (et3 == null) continue;
            prop.setReferencedObjectId(et3.getId());
            RestDocObject restObject2 = new RestDocObject();
            restObject2.setEnumeration(true);
            restObject2.setDisplayName(et3.getDisplayName());
            restObject2.getProperties().addAll(RestDocHelper.getProperties(et3, referencedObjects));
            referencedObjects.put(et3.getId(), restObject2);
        }
        for (Property item : MetaRegistryHelper.getAllCollections((BaseClassType)type).values()) {
            prop = new RestDocProperty();
            if (!RestDocHelper.getBoolean(item.getParameters(), "rest_visible", true)) continue;
            result.add(prop);
            prop.setDescription(item.getDescription());
            prop.setName(item.getId());
            prop.setFormat(RestDocHelper.getCollectionFormat(item.getElementType()));
            prop.setMultiplicity(RestDocHelper.getBoolean(item.getParameters(), "rest_required", true) ? RestDocPropertyMultiplicity.ONE_OR_MORE : RestDocPropertyMultiplicity.ZERO_OR_MORE);
            EntityType et2 = (EntityType)reg.getEntities().get(item.getElementType());
            if (et2 != null) {
                prop.setReferencedObjectId(et2.getId());
                RestDocObject restObject3 = new RestDocObject();
                restObject3.setDisplayName(et2.getDisplayName());
                restObject3.getProperties().addAll(RestDocHelper.getProperties(et2, referencedObjects));
                referencedObjects.put(et2.getId(), restObject3);
                continue;
            }
            EnumType et3 = (EnumType)reg.getEnums().get(item.getElementType());
            if (et3 == null) continue;
            prop.setReferencedObjectId(et3.getId());
            restObject = new RestDocObject();
            restObject.setEnumeration(true);
            restObject.setDisplayName(et3.getDisplayName());
            restObject.getProperties().addAll(RestDocHelper.getProperties(et3, referencedObjects));
            referencedObjects.put(et3.getId(), restObject);
        }
        return result;
    }

    private static List<RestDocProperty> getProperties(EnumType type, Map<String, RestDocObject> referencedObjects) {
        ArrayList<RestDocProperty> result = new ArrayList<RestDocProperty>();
        for (EnumItem item : type.getItems().values()) {
            RestDocProperty prop = new RestDocProperty();
            result.add(prop);
            prop.setDescription(item.getDescription());
            prop.setName(item.getId());
        }
        return result;
    }

    private static String getCollectionFormat(String type) {
        if (TextUtil.isBlank((String)type)) {
            return "\u041a\u043e\u043b\u043b\u0435\u043a\u0446\u0438\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430";
        }
        if ("String".equals(type) || "text".equals(type)) {
            return "\u041a\u043e\u043b\u043b\u0435\u043a\u0446\u0438\u044f \u0441\u0442\u0440\u043e\u043a";
        }
        if ("Integer".equals(type) || "int".equals(type) || Integer.class.getName().equals(type)) {
            return "\u041a\u043e\u043b\u043b\u0435\u043a\u0446\u0438\u044f \u0446\u0435\u043b\u044b\u0445 \u0447\u0438\u0441\u0435\u043b";
        }
        if ("Boolean".equals(type) || "boolean".equals(type) || Boolean.class.getName().equals(type)) {
            return "\u041a\u043e\u043b\u043b\u0435\u043a\u0446\u0438\u044f \u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445";
        }
        if ("double".equals(type) || "Double".equals(type) || BigDecimal.class.getName().equals(type)) {
            return "\u041a\u043e\u043b\u043b\u0435\u043a\u0446\u0438\u044f \u0434\u0440\u043e\u0431\u043d\u044b\u0445 \u0447\u0438\u0441\u0435\u043b";
        }
        MetaRegistry reg = MetaRegistry.get();
        if (reg.getEntities().containsKey(type)) {
            return "\u041a\u043e\u043b\u043b\u0435\u043a\u0446\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0442\u0438\u043f\u0430";
        }
        if (reg.getEnums().containsKey(type)) {
            return "\u041a\u043e\u043b\u043b\u0435\u043a\u0446\u0438\u044f \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0439 \u0442\u0438\u043f\u0430";
        }
        return "\u041a\u043e\u043b\u043b\u0435\u043a\u0446\u0438\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430";
    }

    private static String getPropertyFormat(String type) {
        if (TextUtil.isBlank((String)type)) {
            return "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f";
        }
        if ("String".equals(type) || "text".equals(type)) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430";
        }
        if ("Integer".equals(type) || "int".equals(type) || Integer.class.getName().equals(type)) {
            return "\u0426\u0435\u043b\u043e\u0435 \u0447\u0438\u0441\u043b\u043e";
        }
        if ("Boolean".equals(type) || "boolean".equals(type) || Boolean.class.getName().equals(type)) {
            return "\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f";
        }
        if ("double".equals(type) || "Double".equals(type) || BigDecimal.class.getName().equals(type)) {
            return "\u0414\u0440\u043e\u0431\u043d\u043e\u0435 \u0447\u0438\u0441\u043b\u043e";
        }
        if (LocalDate.class.getName().equals(type)) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430, (yyyy-MM-dd)";
        }
        if (LocalTime.class.getName().equals(type)) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430, (HH:mm:ss)";
        }
        if (LocalDateTime.class.getName().equals(type)) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430, (yyyy-MM-dd'T'HH:mm:ss)";
        }
        if (DateTime.class.getName().equals(type)) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430, (yyyy-MM-dd'T'HH:mm:ss.SSSZZ)";
        }
        MetaRegistry reg = MetaRegistry.get();
        if (reg.getEntities().containsKey(type)) {
            return "\u041e\u0431\u044a\u0435\u043a\u0442 \u0442\u0438\u043f\u0430";
        }
        if (reg.getEnums().containsKey(type)) {
            return "\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0442\u0438\u043f\u0430";
        }
        return "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f";
    }

    private static boolean getBoolean(Map<String, String> map, String key, boolean def) {
        String str = map.get(key);
        return str != null ? Boolean.parseBoolean(str) : def;
    }

    private static String getGroup(SubrouteDescription node) {
        String groupName = (String)node.getParameters().get("rest-group");
        if (!TextUtil.isBlank((String)groupName)) {
            return groupName;
        }
        if (node.getId().contains("common")) {
            return "\u041e\u0431\u0449\u0435\u0435";
        }
        if (node.getId().contains("hotel")) {
            return "\u041e\u0442\u0435\u043b\u0438";
        }
        if (node.getId().contains("rail")) {
            return "\u0416\u0414";
        }
        if (node.getId().contains("cabinet")) {
            return "\u041b\u0438\u0447\u043d\u044b\u0439 \u043a\u0430\u0431\u0438\u043d\u0435\u0442";
        }
        return "\u0410\u0432\u0438\u0430";
    }

    private static SwitchDescription findSwitch(List<String> nodes) {
        IntegrationBusRegistry reg = (IntegrationBusRegistry)Environment.getPublished(IntegrationBusRegistry.class);
        for (String item : nodes) {
            BaseNodeDescription descr = reg.getNode(item);
            if (!(descr instanceof SwitchDescription)) continue;
            return (SwitchDescription)descr;
        }
        return null;
    }
}

