/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web;

import com.gridnine.xtrip.common.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class Configuration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(Configuration.class);
    private String rootContextId;
    private final HashMap<String, Boolean> contextStates = new HashMap();

    Configuration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void save(Configuration config) {
        try {
            File dataFolder = new File(Environment.getDataFolder(), "web");
            if (!dataFolder.exists()) {
                dataFolder.mkdirs();
            }
            File file = new File(dataFolder, "config.ser");
            try (ObjectOutputStream strm = new ObjectOutputStream(new FileOutputStream(file, false));){
                strm.writeObject(config);
            }
            log.debug((Object)("configuration saved to file " + file));
        }
        catch (Exception e) {
            log.error((Object)"configuration save failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Configuration load() {
        Configuration result;
        try {
            File dataFolder = new File(Environment.getDataFolder(), "web");
            File file = new File(dataFolder, "config.ser");
            if (!file.exists()) {
                return new Configuration();
            }
            try (ObjectInputStream strm = new ObjectInputStream(new FileInputStream(file));){
                result = (Configuration)strm.readObject();
            }
            log.debug((Object)("configuration loaded from file " + file));
        }
        catch (Exception e) {
            log.error((Object)"configuration load failed", (Throwable)e);
            return new Configuration();
        }
        return result;
    }

    String getRootContext() {
        return this.rootContextId;
    }

    void setRootContext(String id) {
        this.rootContextId = id;
    }

    boolean isContextActive(String id) {
        Boolean result = this.contextStates.get(id);
        return result != null ? result : true;
    }

    void setContextState(String id, Boolean isActive) {
        this.contextStates.put(id, isActive);
    }
}

