/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.web;

import com.gridnine.xtrip.server.web.WebContextInfo;
import com.gridnine.xtrip.server.web.WebService;
import java.util.Collection;
import java.util.Collections;

public final class WebContextManager {
    static WebService webService;

    public static Collection<WebContextInfo> getAvailableContexts() {
        return Collections.unmodifiableCollection(webService.getContexts().values());
    }

    public static void setContextState(WebContextInfo ctx, boolean isActive) throws Exception {
        WebContextManager.setContextStateInternal(ctx, isActive);
        webService.getConfiguration().setContextState(ctx.getId(), isActive ? Boolean.TRUE : Boolean.FALSE);
    }

    static void setContextStateInternal(WebContextInfo ctx, boolean isActive) throws Exception {
        if (isActive) {
            ctx.getListener().beforeDeploy(ctx);
            webService.getServer().deploy(ctx);
        } else {
            webService.getServer().undeploy(ctx);
            ctx.getListener().afterUndeploy(ctx);
        }
    }

    public static void makeRootContext(WebContextInfo ctx) throws Exception {
        if (ctx.isRoot()) {
            throw new IllegalArgumentException("context " + ctx + " already root context");
        }
    }

    public static boolean isContextStarted(WebContextInfo ctx) throws Exception {
        return webService.getServer().isStarted(ctx);
    }

    public static void stopContext(WebContextInfo ctx) throws Exception {
        webService.getServer().stop(ctx);
    }

    public static void startContext(WebContextInfo ctx) throws Exception {
        webService.getServer().start(ctx);
    }

    public static void reloadContext(WebContextInfo ctx) throws Exception {
        webService.getServer().reload(ctx);
    }

    private WebContextManager() {
    }
}

